<?php
if (!defined( 'ABSPATH' )) exit;
class ad2app_config
{
	function __construct(){
		$this->config();
	}

	function config(){
		$setting = get_option('app_setting');
		$setting['app_setting']['str_tools_content'] = $setting['app_setting']['str_tools_content'] ? $setting['app_setting']['str_tools_content'] : '';
		$setting['app_setting']['str_about_content'] = $setting['app_setting']['str_about_content'] ? $setting['app_setting']['str_about_content'] : '';
		$setting['app_setting']['str_tell_fields'] = $setting['app_setting']['str_tell_fields'] ? $setting['app_setting']['str_tell_fields'] : '';
		$setting['app_setting']['ad2app_display_expire'] = $setting['app_setting']['ad2app_display_expire'] ? $setting['app_setting']['ad2app_display_expire'] : false;
		$setting['app_setting']['str_map_field'] =  $setting['app_setting']['str_map_field'] ? $setting['app_setting']['str_map_field'] : '';
		//$setting['app_setting']['ad2app_view_map'] = false;

		$setting['app_setting']['main_filter_meta_name'] = $setting['app_setting']['main_filter_meta_name'] ? $setting['app_setting']['main_filter_meta_name'] : '';
		$setting['app_setting']['main_filter_meta_title'] = $setting['app_setting']['main_filter_meta_title'] ? $setting['app_setting']['main_filter_meta_title'] : '';
		$setting['app_setting']['first_login_filter_display'] = $setting['app_setting']['first_login_filter_display'] ? $setting['app_setting']['first_login_filter_display'] : false;
		$setting['app_setting']['first_login_category_filter_display'] = $setting['app_setting']['first_login_category_filter_display'] ? $setting['app_setting']['first_login_category_filter_display'] : false;
		$setting['app_setting']['mainpage_filter_display'] = $setting['app_setting']['mainpage_filter_display'] ? $setting['app_setting']['mainpage_filter_display'] : false;
		$setting['app_setting']['mainpage_category_filter_display'] = $setting['app_setting']['mainpage_category_filter_display'] ? $setting['app_setting']['mainpage_category_filter_display'] : false;


		$setting['app_setting']['clr_main_bg'] = $setting['app_setting']['clr_main_bg'] ? $setting['app_setting']['clr_main_bg'] : 'FFFFFF';
		$setting['app_setting']['clr_act_bg'] = $setting['app_setting']['clr_act_bg'] ? $setting['app_setting']['clr_act_bg'] : 'FFFFFF';
		$setting['app_setting']['clr_act_text'] = $setting['app_setting']['clr_act_text'] ? $setting['app_setting']['clr_act_text'] : 'A62626';
		$setting['app_setting']['clr_tab_bg'] = $setting['app_setting']['clr_tab_bg'] ? $setting['app_setting']['clr_tab_bg'] : 'F7F7F7';
		$setting['app_setting']['clr_tab_text'] = $setting['app_setting']['clr_tab_text'] ? $setting['app_setting']['clr_tab_text'] : '4F4F4F';
		$setting['app_setting']['clr_pbtn_bg'] = $setting['app_setting']['clr_pbtn_bg'] ? $setting['app_setting']['clr_pbtn_bg'] : 'F1F1F1';
		$setting['app_setting']['clr_pbtn_text'] = $setting['app_setting']['clr_pbtn_text'] ? $setting['app_setting']['clr_pbtn_text'] : '1B1B1B';
		$setting['app_setting']['clr_vip_text'] = $setting['app_setting']['clr_vip_text'] ? $setting['app_setting']['clr_vip_text'] : 'CE3B3C';
		$setting['app_setting']['clr_sold_text'] = $setting['app_setting']['clr_sold_text'] ? $setting['app_setting']['clr_sold_text'] : 'CE3B3C';

		$setting['app_setting']['str_imgsplash'] = $setting['app_setting']['clr_sold_text'] ? $setting['app_setting']['str_imgsplash'] : '';
		$setting['app_setting']['num_imgsplash'] = $setting['app_setting']['clr_sold_text'] ? $setting['app_setting']['num_imgsplash'] : '';

		update_option('app_setting' , $setting);
		
        $this->create_tbl_woo2app_slider();
        $this->create_tbl_woo2app_mainpage();

	}

	function create_tbl_woo2app_slider(){
        global $wpdb;
        $charset_collate = $wpdb->get_charset_collate();
        $table_name = $wpdb->prefix . 'woo2app_slider';
        $sql = "CREATE TABLE $table_name (
		sl_id bigint(20) NOT NULL AUTO_INCREMENT,
		PRIMARY KEY (sl_id),
		sl_title varchar(100) NOT NULL ,
		sl_type bigint(4) NOT NULL,
		sl_value varchar(150) NOT NULL,
		sl_pic TEXT NOT NULL,
        sl_sort int NOT NULL
	) $charset_collate;";
        require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
        dbDelta( $sql );
        add_option( 'woo2app_version', '1.3' );
    }

	function create_tbl_woo2app_mainpage(){
        global $wpdb;
        $charset_collate = $wpdb->get_charset_collate();
        $table_name = $wpdb->prefix . 'woo2app_mainpage';
        $sql = "CREATE TABLE $table_name (
			mp_id bigint(20) NOT NULL AUTO_INCREMENT,
			PRIMARY key(mp_id),
			mp_title varchar(100) NOT NULL,
			mp_type bigint(4) NOT NULL ,
			mp_value text NOT NULL ,
			mp_showtype bigint(4) NOT NULL,
			mp_pic text NOT NULL,
			mp_order bigint(20),
			mp_sort text NULL 
		) $charset_collate;";
        require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
        dbDelta( $sql );
        add_option( 'woo2app_version', '1.3' );
    }
}


