<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
class ad2app_api
{
	public $site_address = "";
	function __construct( $url)	{
		$this->site_address = $url;
		add_action( 'init',array ( $this , 'ad2app_regular_all' ));
		add_filter( 'query_vars', array ( $this , 'ad2app_query_vars' ));
		add_action( 'parse_request', array( $this , 'ad2app_parse_request' ));
	}
	function ad2app_regular_all(){
		return;
	}
	function ad2app_query_vars($query_vars) {
		$query_vars[] = 'ad2app_new_get_ads';
		$query_vars[] = 'ad2app_GET_ads';
		$query_vars[] = 'ad2app_GET_ads_cat';
		$query_vars[] = 'ad2app_login';
		$query_vars[] = 'ad2app_register';
		$query_vars[] = 'ad2app_my_ads';
		$query_vars[] = 'ad2app_send_ads';
		$query_vars[] = 'ad2app_send_ads_cf';
		$query_vars[] = 'ad2app_edit_ads';
		$query_vars[] = 'ad2app_edit_ads_cf';
		$query_vars[] = 'ad2app_delete_ads';
		$query_vars[] = 'ad2app_img';
		$query_vars[] = 'ad2app_payment';
		$query_vars[] = 'ad2app_on_top_payment';
		$query_vars[] = 'ad2app_SET_sold';
		$query_vars[] = 'ad2app_setting';
		$query_vars[] = 'ad2app_forget';
		$query_vars[] = 'ad2app_order';
		$query_vars[] = 'ad2app_register_without_password';
		$query_vars[] = 'check_bump';
		$query_vars[] = 'order_in_payment';
		$query_vars[] = 'report_issue';
		$query_vars[] = 'republication';
		$query_vars[] = 'get_time';
		$query_vars[] = 'hami_changepass';
		$query_vars[] = 'get_form_category';
		$query_vars[] = 'ad2app_version';
		return $query_vars;
	}
	public  function ad2app_parse_request(&$wp)
	{
		if ( array_key_exists( 'ad2app_setting', $wp->query_vars ) ) {
			$this->ad2app_setting();
			exit();
		}
		elseif ( array_key_exists( 'ad2app_version', $wp->query_vars ) ) {
			header('Content-Type: application/json; charset=utf-8');
			echo json_encode(array('version' =>  AD2APP_VERSION ));
			exit();
		}
		elseif ( array_key_exists( 'get_time', $wp->query_vars ) ) {
			header('Content-Type: application/json; charset=utf-8');
			echo json_encode(array('server_time' =>  current_time('timestamp')));
			exit();
		}
		elseif ( array_key_exists( 'check_bump', $wp->query_vars ) ) {
			$this->check_bump();
			exit();
		}
		elseif ( array_key_exists( 'ad2app_register_without_password', $wp->query_vars ) ) {
			$this->ad2app_register_without_password();
			exit();
		}
		elseif ( array_key_exists( 'ad2app_SET_sold', $wp->query_vars ) ) {
			$this->ad2app_SET_sold();
			exit();
		}
		elseif ( array_key_exists( 'ad2app_on_top_payment', $wp->query_vars ) ) {
			$this->ad2app_on_top_payment();
			exit();
		}
		elseif ( array_key_exists( 'ad2app_GET_ads', $wp->query_vars ) ) {
			$this->ad2app_GET_ads();
			exit();
		}
		elseif ( array_key_exists( 'ad2app_new_get_ads', $wp->query_vars ) ) {
			$this->ad2app_new_get_ads();
			exit();
		}
		elseif ( array_key_exists( 'ad2app_GET_ads_cat', $wp->query_vars ) ) {
			$this->ad2app_GET_ads_cat();
			exit();
		}
		elseif ( array_key_exists( 'ad2app_login', $wp->query_vars ) ) {
			$this->ad2app_login();
			exit();
		}
		elseif ( array_key_exists( 'ad2app_forget', $wp->query_vars ) ) {
			$this->ad2app_forget();
			exit();
		}
		elseif ( array_key_exists( 'ad2app_register', $wp->query_vars ) ) {
			$this->ad2app_register();
			exit();
		}
		elseif ( array_key_exists( 'ad2app_my_ads', $wp->query_vars ) ) {
			$this->ad2app_my_ads();
			exit();
		}
		elseif ( array_key_exists( 'ad2app_send_ads', $wp->query_vars ) ) {
			$this->ad2app_send_ads();
			exit();
		}
		elseif ( array_key_exists( 'ad2app_send_ads_cf', $wp->query_vars ) ) {
			$this->ad2app_send_ads_cf();
			exit();
		}
		elseif ( array_key_exists( 'ad2app_edit_ads', $wp->query_vars ) ) {
			$this->ad2app_edit_ads();
			exit();
		}
		elseif ( array_key_exists( 'ad2app_edit_ads_cf', $wp->query_vars ) ) {
			$this->ad2app_edit_ads_cf();
			exit();
		}
		elseif ( array_key_exists( 'ad2app_delete_ads', $wp->query_vars ) ) {
			$this->ad2app_delete_ads();
			exit();
		}
		elseif ( array_key_exists( 'ad2app_img', $wp->query_vars ) ) {
			$this->ad2app_img();
			exit();
		}
		elseif ( array_key_exists( 'ad2app_payment', $wp->query_vars ) ) {
			$this->ad2app_payment();
			exit();
		}
		elseif ( array_key_exists( 'ad2app_order', $wp->query_vars ) ) {
			$this->register_order(-1);
			exit();
		}
		elseif ( array_key_exists( 'order_in_payment', $wp->query_vars ) ) {
			$this->order_in_payment();
			exit();
		}
		elseif ( array_key_exists( 'report_issue', $wp->query_vars ) ) {
			$this->report_issue();
			exit();
		}
		elseif ( array_key_exists( 'republication', $wp->query_vars ) ) {
			//$this->republication();
			$this->register_order(-1);
			exit();
		}
		elseif ( array_key_exists( 'hami_changepass', $wp->query_vars ) ){
			$this->hami_changepass_webservice();
			exit();
		}
		elseif ( array_key_exists( 'get_form_category', $wp->query_vars ) ){
			$this->get_form_category();
			exit();
		}
	}

	public function report_issue(){
		header('Content-Type: application/json; charset=utf-8');
		if(isset($_POST['in'])) {
			$in        = $_POST['in'];
			$slashless = stripcslashes( $in );
			$url_json  = urldecode( $slashless );
			$json      = json_decode( $url_json );
			$array = array(
				'post_title'    => $json->title,
				'post_content' => $json->note,
				'post_type'     => 'ad2app_report',
				'post_status'   => 'draft',
			);
			$post = wp_insert_post( $array );
			if($post){
				add_post_meta($post,'ad_id',$json->post_id);
				echo  json_encode(
					array(
						'result' => true,
						'report_id' => $post,
						'msg' => 'گزارش با موفقیت ثبت شد'
					)
				);
				return;
			}
		}
		echo json_encode(
			array(
				'result' => false,
				'msg' => 'ثبت گزارش با خطا مواجه است.'
			)
		);
		return;
	}

	protected function ad2app_sticky($post_id){
		$x = get_option( 'sticky_posts' );
		$x[] = $post_id;
		return update_option('sticky_posts' ,$x);
	}

	public  function ajax_bump_ad($post_id , $pack_id) {
		$obj = new CP_Bump_Ad_Plugin();
		$obj->setup_orders();

		if ( ! isset( $post_id ) ) {
			$response = array(
				'result' => '-1',
				'msg' => ' آگهی انتخاب نشده است.',
			);
			die( json_encode( $response ) );
		}

		$post = get_post( $post_id );
		$user_id = get_current_user_id();

		if ( ! $post ) {
			$response = array(
				'result' => '-1',
				'msg' => ' آگهی وجود ندارد.',
			);
			die( json_encode( $response ) );
		}
		if ( ! $obj->can_bump( $post ) ) {
			$response = array(
				'result' => '-1',
				'msg' => ' آگهی نمیتواند نردبان شود.',
			);
			die( json_encode( $response ) );
		}


		// bump or charge?
		if ( ! $obj->payments_enabled() || current_user_can( 'manage_options' ) ) {
			$ret = $obj->bump_ad( $post_id );
			$response = array( 'success' => $ret );
		} else if ( $obj->has_valid_bump_pack( $user_id ) ) {
			/* user has valid bump pack */
			/* decrease bumps */
			$ret = $obj->packages->decrease_user_bumps( $user_id );
			if ( $ret ) {
				$ret = $obj->bump_ad( $post_id );
			}
			$response = array(
				'result' => '-1',
				'msg' => ' آگهی شما نردبان شد.',
			);
			die( json_encode( $response ) );
		} else {

			$cost = $obj->packages->get_package( $pack_id )->price;
			if ( $cost <= 0 ) {
				$response = array(
					'result' => '-1',
					'msg' => ' نردبان با خطا مواجه شد.',
				);
				die( json_encode( $response ) );
			}
			$order_factory = APP_Order_Factory::create('بسته : ' . $obj->packages->get_package( $pack_id )->pack_name);
			//$order_factory->set_author($json->u_id);
			$order_factory->set_author($user_id);
			$hash = substr( sha1( time() . mt_rand( 0, 1000 ) ), 0, 20 );
			update_post_meta( $order_factory->get_id(), 'checkout_type', 'buy-bump');
			update_post_meta( $order_factory->get_id(), 'checkout_hash', $hash );
			$checkout_url = esc_url_raw( add_query_arg( 'buy_bump', 1, get_permalink( $post->ID ) ) );
			$complete_url = add_query_arg( array( 'step' => 'order-summary', 'hash' => $hash ), $checkout_url );
			$cancel_url = add_query_arg( array( 'step' => 'gateway-select', 'hash' => $hash ), $checkout_url );
			update_post_meta( $order_factory->get_id(), 'complete_url', $complete_url );
			update_post_meta( $order_factory->get_id(), 'cancel_url', $cancel_url );
			$post_order = get_post($order_factory->get_id());
			$item = array();
			$order = new APP_Instant_Order($post_order,$item);
			//return $obj->packages->get_package( $pack_id );
			$order->add_item( $obj->packages->get_package( $pack_id )->post_name , $cost , $post->ID );
			$url = $order->get_return_url();
			$ret = empty( $url ) ? false : true;
			$response = array(
				'result' => '2',
				'msg' => 'سفارش شما ثبت شد.',
				'order_id' => $order_factory->get_id(),
				'post_id' => $post->ID,
				'total' => $order->get_total()
			);
		}

		die( json_encode( $response ) );
	}

	public function publish($post_id){
		global $cp_options;
		if(!$cp_options->moderate_ads){
			//edit post for publish
			$my_post = array(
				'ID'=> $post_id,
				'post_status' => 'publish'
			);
			// Update the post into the database
			wp_update_post( $my_post );
		}
	}

	public function ad2app_setting(){
		//global $cp_options;
		//var_dump($cp_options);
		header('Content-Type: application/json; charset=utf-8');

		$res_cp_options = get_option( 'cp_options' );
		$app_setting = $this->app_setting($res_cp_options);
		$main_filter = $app_setting['main_filter_meta_name'];
		$res_cp_ad_fields = array();
		$setting_fields = $this->setting_fields();
		$res_cp_ad_forms = array();
		$res_cp_ad_meta = array();
		global $wpdb;
		if(isset($_GET['ver']) && $_GET['ver'] >= '2.5.4'){
			$t_name = $wpdb->prefix.'cp_ad_fields';
			$query_cp_ad_fields = "SELECT * FROM $t_name where  field_name = '$main_filter' ";
			$res_cp_ad_fields = $wpdb->get_results($query_cp_ad_fields);
		}
		else{
			//get cp fields
			$t_name = $wpdb->prefix.'cp_ad_fields';
			$query_cp_ad_fields = "SELECT * FROM $t_name";
			$res_cp_ad_fields = $wpdb->get_results($query_cp_ad_fields);
			//get cp forms
			$t_name = $wpdb->prefix.'cp_ad_forms';
			$query_cp_ad_forms = "SELECT * FROM $t_name";
			$res_cp_ad_forms = $wpdb->get_results($query_cp_ad_forms);
			$setting_fields = $this->setting_fields();
			//get cp meta
			$t_name = $wpdb->prefix.'cp_ad_meta';
			$query_cp_ad_meta = "SELECT * FROM $t_name order by field_pos";
			$res_cp_ad_meta = $wpdb->get_results($query_cp_ad_meta);
		}

		//get cp options
		$args = array(
			'posts_per_page' => -1,
			'post_type' => "package-listing" ,
		);
		$singles = new WP_Query($args);
		$sin = array();
		foreach ($singles->posts as $key){
			//echo $key->ID ;
			$single_meta = get_post_meta($key->ID);
			//var_dump($single_meta);
			$sin[] = array(
				'id' => $key->ID,
				'duration' => $single_meta['duration'][0],
				'price' => $single_meta['price'][0],
				'pack_name' => $single_meta['pack_name'][0],
				'description' => $single_meta['description'][0],

			);
		}
		$args = array(
			'posts_per_page' => -1,
			'post_type' => "package-bump" ,
		);
		$singles = new WP_Query($args);
		$package_bump = array();
		foreach ($singles->posts as $key){
			$single_meta = get_post_meta($key->ID);
			$package_bump[] = array(
				'id' => $key->ID,
				'pack_name' => $single_meta['pack_name'][0],
				'description' => $single_meta['description'][0],
				'price' => $single_meta['price'][0],
				'bumps' => $single_meta['bumps'][0],

			);
		}
		$in_app_payment = get_option('ad2app_in_app_payments');
		if(!is_array($in_app_payment)) $in_app_payment = array();
		else $in_app_payment = $in_app_payment['in_app_payments'];


		$cpbump_options = get_option('cpbump_options');
		if(is_array($cpbump_options)){
			$cpbump_options['bump_form_help'] = isset($cpbump_options['bump_form_help']) ? $cpbump_options['bump_form_help'] : '';
			$cpbump_options['charge_for_bump'] = isset($cpbump_options['charge_for_bump']) ? $cpbump_options['charge_for_bump'] : '0';
			$cpbump_options['extend_expiration'] = isset($cpbump_options['extend_expiration']) ? $cpbump_options['extend_expiration'] : '0';
			$cpbump_options['show_bump_in_loop'] = isset($cpbump_options['show_bump_in_loop']) ? $cpbump_options['show_bump_in_loop'] : '0';
			$cpbump_options['default_wait_hours'] = isset($cpbump_options['default_wait_hours']) ? $cpbump_options['default_wait_hours'] : '';
			$cpbump_options['cpbump'] = '0';
		}
		else{
			$cpbump_options['bump_form_help'] = '';
			$cpbump_options['charge_for_bump'] =  '0';
			$cpbump_options['extend_expiration'] =  '0';
			$cpbump_options['show_bump_in_loop'] = '0';
			$cpbump_options['default_wait_hours'] =  '';
			$cpbump_options['cpbump'] = '0';
		}

		include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		if ( is_plugin_active( 'classipress-bump-ad/cp-bump-ad.php' ) ) {
			$cpbump_options['cpbump'] = '1';
		}

		$mainpage_json = $this->get_mainpage();

		$array_all_setting =  array(
			'main_page' => $mainpage_json,
			'app_setting' => $app_setting,
			'cp_ad_fields' => $res_cp_ad_fields,
			'setting_fields' => $setting_fields,
			'cp_ad_forms' => $res_cp_ad_forms,
			'cp_ad_meta' => $res_cp_ad_meta,
			'cp_options' => $res_cp_options,
			'single_price' => $sin,
			'package_bump' => $package_bump,
			'cpbump_options' => $cpbump_options,
			'menu' => $this->get_menu(),
			'in_app_payments' => $in_app_payment,
		);
		echo json_encode($array_all_setting);
	}

	private function get_mainpage(){
		global $wpdb;
		$table_name = $wpdb->prefix . "woo2app_mainpage";
		$rec = $wpdb->get_results("select * from $table_name ORDER BY mp_order ASC");
		$array = array();
		$count_load = "15";

		foreach ($rec as $key ) {
			$action = $key->mp_type;

			if ($key->mp_showtype == 4) {
				$slashless = $key->mp_value;
			}


            elseif ($key->mp_showtype == 10) {
				$slashless = stripcslashes($key->mp_value);
			}
			
            elseif ($key->mp_showtype > 1000 && $key->mp_showtype <= 1009 ) {
				$value = stripslashes($key->mp_value);
				$value = json_decode($value);
				if(is_object($value)){
					$count_load = $value->count_load;
					$slashless = $value->value;
				}
				else{
					$slashless = stripcslashes($key->mp_value);
				}
			}
			
			else{
				$slashless = ($key->mp_value);
			}
			$array[] = array(
				"type" => $action,
				"value" => $slashless,
				"title" => $key->mp_title,
			);
		}
		return $array;
	}

	public function app_setting($res_cp_options){

		$app_setting = get_option('app_setting');
		$app_setting = $app_setting['app_setting'];
		$array['sticky_price'] = $res_cp_options["sys_feat_price"];
		$array = $app_setting;
		$content_post = get_post($app_setting['str_tools_content']);
		if($content_post){
			$content = $content_post->post_content;
			$content = apply_filters('the_content', $content);
			$content = str_replace(']]>', ']]&gt;', $content);
			$array['str_tools_content'] = $content;
		}
		$content_post = get_post($app_setting['str_about_content']);
		if($content_post){
			$content = $content_post->post_content;
			$content = apply_filters('the_content', $content);
			$content = str_replace(']]>', ']]&gt;', $content);
			$array['str_about_content'] = $content;
		}
		$picture = get_option('ad2app_default_post');
		if(!is_array($picture)){
			$picture = array();
			$picture['image_list'] = '' ;
			$picture['image_post'] = '' ;
		}
		$array['default_image'] = $picture;
		$metauser = get_option('ad2app_usermeta');
		if(!is_array($metauser)){
			$metauser = array();
		}
		$array['meta_user'] = $metauser;
		if(!isset($array['category_them'])) $array['category_them'] = '1';
		//*********** blog color setting*******************************************************************
		$array['COLOR_BLOG_SELLOL_BG'] = get_option("COLOR_BLOG_SELLOL_BG")? get_option("COLOR_BLOG_SELLOL_BG") : 'ffffff';
		$array['COLOR_BLOG_SELLOL_TXT'] = get_option("COLOR_BLOG_SELLOL_TXT") ? get_option("COLOR_BLOG_SELLOL_TXT") : '000000';
		$array['COLOR_BLOG_HEADER_BG'] = get_option("COLOR_BLOG_HEADER_BG") ? get_option("COLOR_BLOG_HEADER_BG") : 'F5363E';
		$array['COLOR_BLOG_HEADER_TXT'] = get_option("COLOR_BLOG_HEADER_TXT") ? get_option("COLOR_BLOG_HEADER_TXT") : 'f7f7f7';
		$array['COLOR_BLOG_FOOTER_BG'] = get_option("COLOR_BLOG_FOOTER_BG") ? get_option("COLOR_BLOG_FOOTER_BG") : 'D17777';
		$array['COLOR_BLOG_FOOTER_TXT'] = get_option("COLOR_BLOG_FOOTER_TXT") ? get_option("COLOR_BLOG_FOOTER_TXT") : 'ffffff';

		if(!isset($array['clr_main_bg'])) $array['clr_main_bg'] = 'FFFFFF';
		if(!isset($array['clr_act_bg'])) $array['clr_act_bg'] = '5EA8FF';
		if(!isset($array['clr_act_text'])) $array['clr_act_text'] = 'FFFFFF';
		if(!isset($array['clr_tab_bg'])) $array['clr_tab_bg'] = '5EA8FF';
		if(!isset($array['clr_tab_text'])) $array['clr_tab_text'] = 'FFFFFF';
		if(!isset($array['clr_pbtn_bg'])) $array['clr_pbtn_bg'] = 'E2E2E2';
		if(!isset($array['clr_pbtn_text'])) $array['clr_pbtn_text'] = '5EA8FF';
		if(!isset($array['clr_vip_text'])) $array['clr_vip_text'] = '5EA8FF';
		if(!isset($array['clr_sold_text'])) $array['clr_sold_text'] = '5EA8FF';
		if(!isset($array['clr_send_ads_fields_bg'])) $array['clr_send_ads_fields_bg'] = 'FFFFFF';
		if(!isset($array['clr_send_ads_fields_text'])) $array['clr_send_ads_fields_text'] = '000000';
		if(!isset($array['clr_marks_rules'])) $array['clr_marks_rules'] = 'E2E2E2';
		if(!isset($array['clr_btn_manage_ad'])) $array['clr_btn_manage_ad'] = 'E2E2E2';
		if(!isset($array['str_hint_email'])) $array['str_hint_email'] = '';
		if(!isset($array['blog_tab_catid'])) $array['blog_tab_catid'] = 0;
		if(!isset($array['blog_tab_catid_child'])) $array['blog_tab_catid_child'] = false;
		return $array;
	}

	public function get_menu(){
		global $wpdb;
		$table_name = $wpdb->prefix . "ad2app_menu";
		$rec = $wpdb->get_results("select * from $table_name where menu_menu = 1 ORDER BY menu_order ASC");
		$array = array();
		foreach ($rec as $key) {
			$array[] = array(
				"action" => $key->menu_action,
				"value" => $key->menu_value,
				"title" => $key->menu_title,
				"pic" => $key->menu_pic,
				"order" => $key->menu_order
			);
		}
		$arraymenu1 = array(
			'position' => get_option("NUM_MENU1_POS"),
			'items'    => $array
		);
		return $arrayName = array( $arraymenu1);
	}

	public function setting_fields(){
		global $wpdb;
		$table_option = $wpdb->prefix . "options";
		$r = $wpdb->get_results( "SELECT  * FROM $table_option WHERE option_name LIKE 'ad2app_custom_field_icon_%' " ,OBJECT);
		$icon_fields = array();
		foreach ($r as $key){
			$name = trim(str_replace('ad2app_custom_field_icon_' , '' ,$key->option_name));
			$range = get_option('ad2app_custom_field_range_'.$name);
			$type = get_option('ad2app_custom_field_type_field_'.$name) ? get_option('ad2app_custom_field_type_field_'.$name) : 'general';
			$min_max_range = array();
			if($range == '1'){
				if(is_array(get_option('ad2app_custom_field_min_max_range_'.$name))){
					$min_max_range = get_option('ad2app_custom_field_min_max_range_'.$name);
					if(!isset($min_max_range['min']) || !isset($min_max_range['min'])){
						$min_max_range = array(
							'min' => 0,
							'max' => 0,
							'unit' => '',
							'step' => 0,
						);
					}
				}
			}
			$icon_fields[trim(str_replace('ad2app_custom_field_icon_','',$key->option_name))] = array(
				'name' => $name ,
				'icon' => $key->option_value,
				'range' => $range,
				'type' => $type,
				//'min_max_range' => $min_max_range,
				'min' => $min_max_range['min'] ? $min_max_range['min'] : $this->cp_min_price($name),
				'max' => $min_max_range['max'] ? $min_max_range['max'] : $this->cp_max_price($name),
				'unit' => $min_max_range['unit'] ? $min_max_range['unit'] :'',
				'step' => $min_max_range['step'] ? $min_max_range['step'] : 0,
			);
		}
		return $icon_fields;
	}

	public  function check_bump(){
		header('Content-Type: application/json; charset=utf-8');
		$in = $_POST['in'];
		$slashless = stripcslashes($in);
		$url_json = urldecode($slashless);
		$json = (array) json_decode($url_json);

		wp_set_current_user($json['user_id']);
		$post = get_post($json['post_id']);

		$obj = new CP_Bump_Ad_Plugin();
		if(!$obj->can_bump($post)){
			echo json_encode(array(
				'result' => false,
				'msg' => "نمیتوان پست را نردبان کرد.",
				'error' => -1,
			));
			die();
		}
		$cpbump_options = get_option('cpbump_options');
		if(!isset($cpbump_options['charge_for_bump'])){
			$r = $obj->bump_ad($json['post_id']);
			echo json_encode(array(
				'result' => true,
				'msg' => " نردبان رایگان ، باموفقیت انجام شد.",
				'error' => 1,
			));
			die();
		}
		$user_bump_count = get_user_meta($json['user_id'] , 'bump_pack',true);
		if(isset($user_bump_count['bumps']) && $user_bump_count['bumps'] > 0){
			$r = $obj->bump_ad($json['post_id']);
			if($r){
				$user_bump_count['bumps'] = $user_bump_count['bumps'] - 1;
				update_user_meta($json['user_id'] , 'bump_pack' , $user_bump_count);
				echo json_encode(array(
					'result' => true,
					'msg' => "نردبان باموفقیت انجام شد.",
					'error' => 1,
				));
				die();
			}
			echo json_encode(array(
				'result' => false,
				'msg' => "  نردبان به خطا خورد ، مجدد امتحان کنید.",
				'error' => -2,
			));
			die();
		}
		echo json_encode(array(
			'result' => false,
			'msg' => " نردبانی موجود نیست ، یکی از بسته های نردبان را انتخاب کنید.",
			'error' => 0,
		));
		die();
	}

	// USER Account

	public function ad2app_forget() {
		ob_start();
		if ( ! empty( $_GET["in"] ) ) {
			$in = $_GET['in'];
			$slashless = stripcslashes( $in );
			$url_json = urldecode( $slashless );
			$json = (array) json_decode( $url_json );
			$user = $json['user_name'];
			$x    = $this->retrieve_password( $user );
			ob_clean();
			//var_dump($x->errors);return;
			if ( isset($x->errors)) {
				echo -1;
			} else {
				echo 1;
			}
			return;
		}//end webservice apost
	}

	public function retrieve_password($username) {
		global $wpdb, $current_site, $wp_hasher;

		$errors = new WP_Error();

		if ( empty( $username ) ) {
			$errors->add( 'empty_username', __( '<strong>ERROR</strong>: Enter a username or e-mail address.', APP_TD ) );
		} else if ( strpos($username, '@' ) ) {
			$user_data = get_user_by( 'email', trim( $username ) );
			if ( empty( $user_data ) ) {
				$errors->add( 'invalid_email', __( '<strong>ERROR</strong>: There is no user registered with that email address.', APP_TD ) );
			}
		} else {
			$login = trim( $username );
			$user_data = get_user_by( 'login', $login );
		}

		do_action( 'lostpassword_post' );

		if ( $errors->get_error_code() ) {
			return $errors;
		}

		if ( ! $user_data ) {
			$errors->add( 'invalidcombo', __( '<strong>ERROR</strong>: Invalid username or e-mail.', APP_TD ) );
			return $errors;
		}

		// redefining user_login ensures we return the right case in the email
		$user_login = $user_data->user_login;
		$user_email = $user_data->user_email;

		do_action( 'retreive_password', $user_login );  // Misspelled and deprecated
		do_action( 'retrieve_password', $user_login );

		$allow = apply_filters( 'allow_password_reset', true, $user_data->ID );

		if ( ! $allow ) {
			return new WP_Error( 'no_password_reset', __( 'Password reset is not allowed for this user', APP_TD ) );
		} else if ( is_wp_error( $allow ) ) {
			return $allow;
		}

		// Generate something random for a key...
		$key = wp_generate_password( 20, false );

		do_action( 'retrieve_password_key', $user_login, $key );

		// Now insert the key, hashed, into the DB.
		if ( empty( $wp_hasher ) ) {
			require_once ABSPATH . WPINC . '/class-phpass.php';
			$wp_hasher = new PasswordHash( 8, true );
		}
		$hashed = time() . ':' . $wp_hasher->HashPassword( $key );
		$wpdb->update( $wpdb->users, array( 'user_activation_key' => $hashed ), array( 'user_login' => $user_login ) );

		$message = __( 'Someone requested that the password be reset for the following account:', APP_TD ) . "\r\n\r\n";
		$message .= site_url() . "\r\n\r\n";
		$message .= sprintf( __( 'Username: %s', APP_TD ), $user_login ) . "\r\n\r\n";
		$message .= __( 'If this was a mistake, just ignore this email and nothing will happen.', APP_TD ) . "\r\n\r\n";
		$message .= __( 'To reset your password, visit the following address:', APP_TD) . "\r\n\r\n";

		$url = appthemes_get_password_reset_url();
		$url = esc_url_raw( add_query_arg( array( 'action' => 'rp', 'key' => $key, 'login' => rawurlencode( $user_login ) ), $url ) );

		$message .= $url . "\r\n";

		if ( is_multisite() ) {
			$blogname = $GLOBALS['current_site']->site_name;
		} else {
			// The blogname option is escaped with esc_html on the way into the database in sanitize_option
			// we want to reverse this for the plain text arena of emails.
			$blogname = wp_specialchars_decode( get_option( 'blogname' ), ENT_QUOTES );
		}

		$title = sprintf( __( '[%s] Password Reset', APP_TD ), $blogname );

		$title = apply_filters( 'retrieve_password_title', $title );
		$message = apply_filters( 'retrieve_password_message', $message, $key, $user_login, $user_data );

		if ( $message && ! wp_mail( $user_email, $title, $message ) ) {
			wp_die( __( 'The e-mail could not be sent.', APP_TD ) . "<br />\n" . __( 'Possible reason: your host may have disabled the mail() function...', APP_TD ) );
		}

		return true;
	}

	public function ad2app_login(){
		header('Content-Type: application/json; charset=utf-8');
		$in = $_POST['in'];
		//$in =  '{"username":"ghasemy1.hani@gmail.com","pass":"123456"}';
		$slashless = stripcslashes($in);
		$url_json = urldecode($slashless);
		$json = (array) json_decode($url_json);
		$user = get_user_by( "login", $json["username"] );
		if(!$user){
			$user = get_user_by( "email", $json["username"] );
		}
		if ( $user && wp_check_password( $json["pass"], $user->data->user_pass, $user->ID) )
		{
			$bump_count = 0;
			$bump = get_user_meta($user->ID , 'bump_pack' , true);
			if($bump){
				$bump_count = $bump['bumps'];
			}
			echo json_encode(
				array(
					'error' => '1',
					'user' => array(
						"id" => $user->data->ID,
						'username' => $user->data->user_login,
						'email' => $user->data->user_email,
						'bump' => $bump_count
						//'pass' => $json["pass"]
					)
				)
			);
		}
		else{
			echo json_encode(array("error" => 0));
		}
	}

	public function ad2app_register_without_password(){
		header('Content-Type: application/json; charset=utf-8');
		$result = array(
			'result' => array(
				'user_id' => -1,
				'msg' 	  => 'ایمیل یا نام کاربری تکراری است ، لطفا وارد شوید و مجدد ارسال کنید.',
				'status'  => -1,
				'user' => "",
			)
		);
		$in = $_POST['in'];
		$slashless = stripcslashes($in);
		$url_json = urldecode($slashless);
		$json = (array) json_decode($url_json);
		$email_address = $json['email'];
		if( null == username_exists( $json['email'] ) && null == email_exists($json['email']) ) {
			// Generate the password and create the user
			$password = wp_rand( 100000,999999 );
			//remove_action('user_register' , 'ncpmr_user_register');
			$user_id =  wp_create_user( $email_address, $password, $email_address );
			if($user_id->errors){
				foreach ($user_id->errors as $key ) {
					$result = array(
						'result' => array(
							'user_id' => -1,
							'msg' 	  => $key[0],
							'status'  => -1,
							'user' => "",
						)
					);
				}
			}
			else{
				$sms = get_option('mr2app_sms');
				if(!isset($sms['one-time']) ||  $sms['one-time'] == 0) {
					if ( is_array( $sms ) ) {
						$register_class = new class_custom_register();
						if ( $sms['enable'] ) {
							$func  = $sms['panel'];
							$msg   = get_option( 'blogname' );
							$msg   .= "\n";
							$msg   .= 'رمز عبور جدید :';
							$msg   .= "\n";
							$msg   .= $password;
							$to [] = $email_address;
							$register_class->$func( $to, $msg, $password, $email_address );
							//var_dump($x);return;
						}
					}
				}
				update_user_meta( $user_id, 'hannanstd_is_user_verified', 1 );
				// Set the nickname
				wp_update_user(
					array(
						'ID'          =>    $user_id,
						'nickname'    =>    $email_address
					)
				);
				// Set the role
				$user = new WP_User( $user_id );
				$user->set_role( 'contributor' );
				// Email the user
				$msg = "<div style='width:100%;direction:rtl'>";
				$msg .= '<h3>'.get_option('blogname').'</h3>';
				$msg .= "\n";
				$msg .= "<p>";
				$msg .= ' رمز عبور شما: ' . $password;
				$msg .= "</p></div>";
				wp_mail( $email_address, 'خوش آمدید !',  $msg);
				$result = array(
					'result' => array(
						'user_id' => $user_id,
						'msg' 	  => 'رمز عبور به ایمیل شما ارسال گردید',
						'status'  => 1,
						'user' => array("id" => $user->data->ID,
						                'username' => $user->data->user_login,
						                'email' => $user->data->user_email,
						                'pass' => $password
						)
					)
				);
			}
		} // end if
		echo json_encode($result);
		return;
	}

	public function ad2app_register(){
		header('Content-Type: application/json; charset=utf-8');
		$in = $_POST['in'];
		//$in =  '{"username":"hani","email":"ghasemy.hani@gmail.com","pass":"123456"}';
		$slashless = stripcslashes($in);
		$url_json = urldecode($slashless);
		$json = (array) json_decode($url_json);
		$userdata = array(
			'user_login' =>  $json["username"],
			'user_email'   =>  $json["email"],
			'user_pass'  => $json["pass"] , // When creating an user, `user_pass` is expected.
			'role' => 'contributor'
		);
		$user = wp_insert_user($userdata);
		//$user = wp_create_user($json["username"] , $json["email"] , $json["pass"]);
		//wp_create_user();
		if($user->errors){
			foreach ($user->errors as $key ) {
				//var_dump($key);
				echo json_encode(array("error" => 0 , 'msg' => $key[0]));
				return;
			}
		}
		elseif($user){
			cp_new_user_notification($user );
			update_user_meta( $user, 'hannanstd_is_user_verified', 1 );
			echo json_encode(array('error' => '1',
			                       'user' => array("id" => $user,
			                                       'username' => $json["username"],
			                                       'email' => $json["email"])
				)
			);
			return;
		}
		else{
			echo json_encode(array("error" => 0 , 'msg' => "مشکلی رخ داده است."));
			return;
		}
	}

	// SEND Ads

	public function ad2app_send_ads_cf(){
		header('Content-Type: application/json; charset=utf-8');
		$in = $_POST['in'];
		$slashless = stripcslashes($in);
		$url_json = urldecode($slashless);
		$json = (array) json_decode($url_json);
		$meta = (array) ($json["meta"]);
		if($json["single"] != ""){
			$p_m = get_post_meta($json['single'],'duration');
			$meta['cp_sys_ad_duration'] = $p_m[0];
		}
		else{
			global  $cp_options;
			$meta['cp_sys_ad_duration'] = $cp_options->prun_period;
		}
		$meta['cp_sys_ad_conf_id'] = cp_generate_id();
		$meta['cp_sys_userIP'] = appthemes_get_ip();
		$meta['cp_sys_total_ad_cost'] = 0;

		$defaults = array(
			'post_author' => $json["user"],
			'post_content' => $json["desc"],
			'post_content_filtered' => '',
			'post_title' => $json["title"],
			'post_excerpt' => '',
			'post_status' => 'pending',
			'post_type' => 'ad_listing',
			'comment_status' => '',
			'ping_status' => '',
			'post_password' => '',
			'to_ping' =>  '',
			'pinged' => '',
			'post_parent' => 0,
			'menu_order' => 0,
			'guid' => '',
			'import_id' => 0,
			'context' => '',
			//'meta_input' => $meta
		);
		//check for admin confirm to publish
		$res_cp_options = get_option( 'cp_options' );

		$cats = explode(",",$json["cats"]);
		$tags = explode(",",$json["tags"]);

		$post = wp_insert_post($defaults,false);

		if(!is_wp_error($post) && $post != 0 )
		{
			wp_set_current_user($json["user"]);
			if($res_cp_options['new_ad_email']){
				cp_new_ad_email($post);
			}
			cp_owner_new_ad_email($post);
			foreach ($meta as $key => $val){
				if(is_array($val)){
					//delete_post_meta($post,$key);
					foreach ($val as $key1){
						add_post_meta($post , $key,$key1);
					}
				}
				else{
					add_post_meta($post , $key,$val);
				}
			}
			wp_set_post_terms( $post , $cats , "ad_cat" );
			wp_set_post_terms( $post , $tags, "ad_tag" );
			if($json["sticky"] == 1){
				stick_post( $post );
			}
			//echo json_encode(array("error" => 1 , "data" => $post));
			if($json["category"] == "" && $json["featured"] == "" &&  $json["single"] == ""){
				if(!$res_cp_options['charge_ads']){
					if($res_cp_options["moderate_ads"]){
						$msg = "اگهی شما پس از تایید مدیر ، منتشر خواهد شد.";
					}
					else{
						$this->ad2app_payments_handle_ad_listing_activated('publish',$post);
						$msg = "اگهی شما منتشر شد.";
					}
				}
				else{
					$msg = "اگهی شما پس از تایید مدیر ، منتشر خواهد شد.";
				}
				echo json_encode(array(
					'result' => 1,
					'msg' => $msg,
					'order_id' => -1,
					'post_id' => $post
				));
			}
			else{
				return $this->register_order($post);

			}
		}else{
			//echo json_encode(array("error" => 0));
			echo json_encode(array(
				'result' => '0',
				'msg' => 'ثبت آگهی به خطا مواجه شد.',
				'order_id' => -1,
				'post_id'=> -1
			));
		}
	}

	public function ad2app_send_ads(){
		$in = $_POST['in'];
		$slashless = stripcslashes($in);
		$url_json = urldecode($slashless);
		$json = (array) json_decode($url_json);
		//$in =  '{"user":"","title":"","price":"","city":"","state":","street":"","tags":"","images":"","desc":"","phone":"","email":"","cats":"","sticky":""}';
		$defaults = array(
			'post_author' => $json["user"],
			'post_content' => $json["desc"],
			'post_content_filtered' => '',
			'post_title' => $json["title"],
			'post_excerpt' => '',
			'post_status' => 'pending',
			'post_type' => 'ad_listing',
			'comment_status' => '',
			'ping_status' => '',
			'post_password' => '',
			'to_ping' =>  '',
			'pinged' => '',
			'post_parent' => 0,
			'menu_order' => 0,
			'guid' => '',
			'import_id' => 0,
			'context' => '',
			'meta_input' => array('cp_price' => $json["price"],'cp_street' => $json["street"] , 'cp_id_472' => $json["email"],
			                      'cp_city' => $json["city"],'cp_state' => $json["state"] , 'cp__' => $json["phone"])
		);
		//check for admin confirm to publish
		$res_cp_options = get_option( 'cp_options' );
		if ($res_cp_options["moderate_ads"])
			$defaults['post_status'] ="pending";
		else
			$defaults['post_status'] ="publish";
		$cats = explode(",",$json["cats"]);
		$tags = explode(",",$json["tags"]);
		//$images = explode(",",$json["images"]);
		//$images = (array) $json["images"];
		$post = wp_insert_post($defaults,false);
		if(!is_wp_error($post) && $post != 0 )
		{
			wp_set_post_terms( $post , $cats , "ad_cat" );
			wp_set_post_terms( $post , $tags, "ad_tag" );
			if($json["sticky"] == 1){
				stick_post( $post );
			}
			echo json_encode(array("error" => 1 , "data" => $post));
		}else{
			echo json_encode(array("error" => 0));
		}
	}

	public function ad2app_edit_ads(){
		$in = $_POST['in'];
		$slashless = stripcslashes($in);
		$url_json = urldecode($slashless);
		$json = (array) json_decode($url_json);
		$defaults = array(
			'ID' => $json["id"],
			'post_content' => $json["desc"],
			'post_content_filtered' => '',
			'post_title' => $json["title"],
			'post_excerpt' => '',
			'post_status' => 'pending',
			'post_type' => 'ad_listing',
			'comment_status' => '',
			'ping_status' => '',
			'post_password' => '',
			'to_ping' =>  '',
			'pinged' => '',
			'post_parent' => 0,
			'menu_order' => 0,
			'guid' => '',
			'import_id' => 0,
			'context' => '',
			'meta_input' => array('cp_price' => $json["price"],'cp_street' => $json["street"] , 'cp_id_472' => $json["email"],
			                      'cp_city' => $json["city"],'cp_state' => $json["state"] , 'cp__' => $json["phone"])
		);
		//check for admin confirm to publish
		$res_cp_options = get_option( 'cp_options' );
		if ($res_cp_options["moderate_edited_ads"])
			$defaults['post_status'] ="pending";
		else
			$defaults['post_status'] ="publish";
		$tags = explode(",",$json["tags"]);
		$post = wp_update_post($defaults,false);
		if(!is_wp_error($post) && $post != 0 )
		{
			// comment by hani => Because If needed one by one  remove image in ad2app_img  service

			wp_set_post_terms( $post , $tags, "ad_tag" );

			echo json_encode(array("error" => 1 , "data" => $post));
		}else{
			echo json_encode(array("error" => 0));
		}
	}

	public function ad2app_edit_ads_cf(){
		$in = $_POST['in'];
		$slashless = stripcslashes($in);
		$url_json = urldecode($slashless);
		$json = (array) json_decode($url_json);
		$meta = (array) ($json["meta"]);
		$defaults = array(
			'ID' => $json["id"],
			'post_content' => $json["desc"],
			'post_content_filtered' => '',
			'post_title' => $json["title"],
			'post_excerpt' => '',
			'post_status' => 'pending',
			'post_type' => 'ad_listing',
			'comment_status' => '',
			'ping_status' => '',
			'post_password' => '',
			'to_ping' =>  '',
			'pinged' => '',
			'post_parent' => 0,
			'menu_order' => 0,
			'guid' => '',
			'import_id' => 0,
			'context' => '',
			//'meta_input' => $meta
		);
		//check for admin confirm to publish
		$post = get_post($json["id"]);
		if($post){
			$res_cp_options = get_option( 'cp_options' );
			if($post->post_status == 'pending'){
				$defaults['post_status'] ="pending";
			}
			else{
				if ($res_cp_options["moderate_edited_ads"])
					$defaults['post_status'] ="pending";
				else
					$defaults['post_status'] ="publish";
			}
			$tags = explode(",",$json["tags"]);
			$post = wp_update_post($defaults,false);
			if(!is_wp_error($post) && $post != 0 )
			{
				foreach ($meta as $key => $val){
					delete_post_meta($post,$key);
					if(is_array($val)){
						foreach ($val as $key1){
							add_post_meta($post , $key,$key1);
						}
					}
					else{
						add_post_meta($post , $key,$val);
					}
				}
				wp_set_post_terms( $post , $tags, "ad_tag" );

				echo json_encode(array("error" => 1 , "data" => $post));
			}else{
				echo json_encode(array("error" => 0));
			}
		}
	}

	public function ad2app_delete_ads(){
		$in = $_GET['in'];
		$slashless = stripcslashes($in);
		$url_json = urldecode($slashless);
		$json = (array) json_decode($url_json);
		//$in =  '{"id":""}';
		$post = wp_delete_post($json["id"]);
		if($post) echo json_encode(array("error"=>1));
		else echo json_encode(array("error"=>0));
	}

	public function delete_attachments_with_post( $postid ){
		$attachments = get_posts( array( 'post_type' => 'attachment', 'posts_per_page' => -1, 'post_status' => '', 'post_parent' => $postid ) );
		if( !$attachments )
			return;
		foreach( $attachments as $attachment )
			wp_delete_attachment( $attachment->ID );
	}

	public function ad2app_img() {
		$in = $_POST['in'];
		$slashless = stripcslashes($in);
		$url_json = urldecode($slashless);
		$json = (array) json_decode($url_json);
		$post = $json["post"];
		$img = $json["image"];
		if(isset( $json["img_id"] ) ) {
			if($json["img_id"] != ""){
				//echo $json["img_id"].'#$#$$#$##$##$$';return;
				$media_meta = get_post_meta($post , "_app_media");
				$media_apps = array();
				if(!empty($media_meta) && !is_null($media_meta))
				{
					foreach ($media_meta as $key1) {
						if(!is_array($key1)) continue;
						foreach ($key1 as $value) {
							if($value == $json['img_id']) continue;
							$media_apps[] = $value ;
						}
					}
				}
				update_post_meta($post , "_app_media" ,$media_apps);
				echo json_encode(array("error" => 2));
				return;
			}
		}
		$upload_dir       = wp_upload_dir();
		// @new
		$upload_path      = str_replace( '/', DIRECTORY_SEPARATOR, $upload_dir['path'] ) . DIRECTORY_SEPARATOR;
		$img = str_replace('data:image/jpg;base64,', '', $img);
		$img = str_replace(' ', '+', $img);
		$decoded          = base64_decode($img) ;
		$filename         = '.jpg';
		$hashed_filename  = mt_rand( 1000, 1000000 ) . $filename;
		file_put_contents( $upload_path . $hashed_filename, $decoded );
		//HANDLE UPLOADED FILE
		if( !function_exists( 'wp_handle_sideload' ) ) {
			require_once( ABSPATH . 'wp-admin/includes/file.php' );
		}
		// Without that I'm getting a debug error!?
		if( !function_exists( 'wp_get_current_user' ) ) {
			require_once( ABSPATH . 'wp-includes/pluggable.php' );
		}
		// @new
		$file             = array();
		$file['error']    = '';
		$file['tmp_name'] = $upload_path . $hashed_filename;
		$file['name']     = $hashed_filename;
		$file['type']     = 'image/jpg';
		$file['size']     = filesize( $upload_path . $hashed_filename );
		// upload file to server
		// @new use $file instead of $image_upload
		$file_return    = wp_handle_sideload( $file, array( 'test_form' => false ) );
		$filename = $file_return['file'];
		$post_object = get_post( $post );
		$attachment = array(
			'post_author' => $post_object->post_author,
			'post_mime_type' => $file_return['type'],
			'post_title' => get_the_title($post),
			'post_content' => $post_object->post_content,
			'post_status' => 'inherit',
			'guid' => $file_return['url'] . '/' . basename($filename)
		);
		$attach_id = wp_insert_attachment( $attachment, $filename, $post );
		require_once(ABSPATH . 'wp-admin/includes/image.php');
		$attach_data = wp_generate_attachment_metadata( $attach_id, $filename );
		wp_update_attachment_metadata( $attach_id, $attach_data );
		$media_meta = get_post_meta($post , "_app_media");
		$media_apps = array();
		if(!empty($media_meta) && !is_null($media_meta))
		{
			foreach ($media_meta as $key1) {
				if(!is_array($key1)) continue;
				foreach ($key1 as $value) {
					$media_apps[] = $value ;
				}
			}
		}
		array_push($media_apps , $attach_id);
		$flag = update_post_meta($post , "_app_media" ,$media_apps);
		add_post_meta($attach_id , "iw-is-watermarked" , 1);
		add_post_meta($attach_id , "_wp_attachment_metadata" ,$attach_data);
		add_post_meta($attach_id , "_wp_attachment_image_alt" ,"test");
		add_post_meta($attach_id , "_app_attachment_type" ,"file");
		if($flag){
			echo json_encode(array("error" => 1));
		}else{
			echo json_encode(array("error" => 0));
		}
	}

	public function ad2app_SET_sold(){
		$in = $_GET['in'];
		$slashless = stripcslashes($in);
		$url_json = urldecode($slashless);
		$json = (array) json_decode($url_json);
		$id = $json["id"];
		$sold = get_post_meta( $id, 'cp_ad_sold', true );
		if ( $sold != 'yes' ) {
			update_post_meta($id , 'cp_ad_sold' , 'yes');
			echo json_encode(array("error" => 1));
		}else{
			update_post_meta($id , 'cp_ad_sold' , 'no');
			echo json_encode(array("error" => 1));
		}
	}


	// GET Ads

	public function ad2app_new_get_ads() {

		global $wpdb, $cp_options;
		$meta_query = array();
		$args = array(
			'posts_per_page' => 10,
			'paged' => 1,
			'post_type' => "ad_listing" ,
		);
		if(isset($_POST['in'])){
			$in = $_POST['in'];
			$slashless = stripcslashes($in);
			$url_json = urldecode($slashless);
			$json = (array) json_decode($url_json);
			$args = array(
				'posts_per_page' => $json["count"],
				'paged' => $json["page"],
				'post_type' => "ad_listing"
			);


			//Features
			$stickies = get_option( 'sticky_posts' );
			if(isset($json['filter']->featured)){
				$featuredEnable = $json['filter']->featured;
				if ($featuredEnable == 1)
					$args['post__in'] = $stickies;
			}


			//Check for sort query
			$sortType = $json["sort"];
			switch ($sortType){
				case 'NEWEST':
					$args['orderby'] = 'date ID';
					$args['order'] = 'DESC';
					break;
				case 'VISIT':
					$args['orderby'] = "meta_value_num ID";
					$args['order'] = 'DESC';
					$args['meta_key'] = 'cp_total_count';
					break;
			}


		}
		if(isset($_POST['in'])){
			if(isset($json['filter'])){
				foreach ( $json["filter"] as $key => $value ) {

					if ( empty( $value ) ) {
						continue;
					}
					switch ( $key ) {

						case 'category':
							$args ["tax_query"] = array(
								array( 'taxonomy' => 'ad_cat',
								       'field'    => 'ID',
								       'terms'    => $value)
							);
							break;

						case 'search' :
							$args ["s"] = $value;
							break;

						case 'id_ads':
							$args ["p"] = $value;
							break;

						// case 'cp_city_zipcode' :
						// 	$region = $cp_options->gmaps_region;
						// 	$value = urlencode( $value );
						// 	$geocode = json_decode( wp_remote_retrieve_body( wp_remote_get( "http://maps.googleapis.com/maps/api/geocode/json?address=$value&region=$region" ) ) );
						// 	if ( 'OK' == $geocode->status ) {
						// 		$args->set( 'app_geo_query', array(
						// 			'lat' => $geocode->results[0]->geometry->location->lat,
						// 			'lng' => $geocode->results[0]->geometry->location->lng,
						// 			'rad' => intval( $json["filter"]->distance ),
						// 		) );
						// 	} else {
						// 		// Google Maps API error
						// 	}
						// 	break;

						default :
							if ( 'cp_' == substr( $key, 0, 3 ) ) {
								if ( $value === null ) {
									break;
								}
								global $wpdb;
								$tbl_cp_ad_fields = $wpdb->prefix.'cp_ad_fields';
								$field = $wpdb->get_row( $wpdb->prepare( "SELECT * FROM $tbl_cp_ad_fields WHERE field_name = %s", $key ) );
								//$range = get_option('ad2app_custom_field_range_'.$key);
								if(isset($value->min)){
									//$int = explode(',',$value);
									$min = empty( $value->min ) ? 0 : (int) $value->min;
									$max = empty( $value->max ) ? 9999999999 : (int) $value->max;
									$value = array( $min, $max );
									$meta_query[] = array(
										'key' => $key,
										'value' => $value,
										'compare' => 'BETWEEN',
										'type' => 'numeric',
									);
								}
								else{
									if ( $value === null ) {
										break;
									}
									//									if(is_array($value)){
									//										echo $key;
									//									}
									$compare = ( in_array( $field->field_type, array( 'radio', 'checkbox', 'drop-down' ) ) ) ? 'IN' : 'LIKE';
									if(is_array($value)){
										foreach ($value as $kk){
											$meta_query[] = array(
												'key'   => $key,
												'value' => $kk,
												'compare' => $compare,
											);
										}
									}
									else{
										$meta_query[] = array(
											'key'   => $key,
											'value' => $value,
											'compare' => 'LIKE',
										);
									}
								}
							}
							break;
					}
				}
				$args['meta_query']  = $meta_query ;
				$args['meta_query']['relation'] = 'AND';
			}
		}
		$this->ad2app_GET_ads1($args);
		exit();
	}

	public function ad2app_GET_ads1($query){
		// var_dump($query);
		// echo json_encode($query);
		header('Content-Type: application/json; charset=utf-8');
		//$sticky = get_option("sticky_posts");
		$picture_setting = get_option('ad2app_default_post');
		if(isset($picture_setting['image_zie'])){
			$image_size = $picture_setting['image_zie'];
		}
		else{
			$image_size = 'thumbnail';
		}
		$posts = new WP_Query( $query );
		if( !is_null($posts->posts) && !empty($posts->posts) ){
			foreach ($posts->posts as $key ) {
				$key->post_content = apply_filters("the_content" , $key->post_content);
				$x = get_post_meta($key->ID);
				$xx = array();
				foreach ($x as $k => $v){
					$xx[$k][] = implode(',',$v);
				}
				$key->post_meta = $xx;//get_post_meta($key->ID);
				//$key->post_meta = get_post_meta($key->ID);
				$media_meta = get_post_meta($key->ID , "_app_media");
				$f_src = 0;
				$f_src_id = 0;
				$images = null;
				$new_images = null;
				if(!empty($media_meta)){
					foreach ($media_meta as $key1) {
						if(!is_array($key1)) continue;
						foreach ($key1 as $value) {
							if($f_src == 0){
								$f_src_id = $value;
								$f_src = 1;
							}
							$images[] = wp_get_attachment_url( $value );
							$new_images[] = array(
								'url' => wp_get_attachment_url( $value ),
								'id' => $value,
							);
						}
					}
				}
				$key->sticky = intval(is_sticky($key->ID));
				$key->images = $images;
				$key->new_images = $new_images;
				$categories = get_the_terms($key->ID,"ad_cat");
				if(!empty($categories)){
					foreach( $categories as $category ) {
						$key->cats = $category->name;
						$key->cat_id = $category->term_id;
					}
				}
				$images =  array();
				global $wpdb;
				$query = "SELECT * FROM $wpdb->p2p where p2p_type = 'order-connection' and p2p_to = $key->ID";
				if($query){
					$key->payment = 1;
				}else{
					$key->payment = 0;
				}
				$sold = get_post_meta($key->ID , "cp_ad_sold");
				if ( $sold != 'yes' ) {
					$key->sold = 0;
				}else{
					$key->sold = 1;
				}
				$metauser = get_option("ad2app_usermeta");
				$key->metauser = array();
				if(is_array($metauser)){
					foreach ($metauser as $meta){
						$metauser_val = get_user_meta($key->post_author , $meta['metauser'], true);
						$key->metauser[] = array(
							$meta['metauser'],
							$metauser_val
						);
					}
				}
				$key->featured_src = wp_get_attachment_image_src( $f_src_id, $image_size) ? wp_get_attachment_image_src( $f_src_id, $image_size)[0] : '';
				$key->publish_time = strtotime($key->post_date);
				$key->expire_time = (int)strtotime(get_post_meta($key->ID , 'cp_sys_expire_date' , true));
			}
		}
		echo json_encode($posts->posts);
	}

	public function ad2app_GET_ads(){
		header('Content-Type: application/json; charset=utf-8');
		$in = $_POST['in'];
		$slashless = stripcslashes($in);
		$url_json = urldecode($slashless);
		$json = (array) json_decode($url_json);
		$args = array(
			'posts_per_page' => $json["count"],
			'paged' => $json["page"],
			'post_type' => "ad_listing" ,
		);
		if(!is_null($json["filter"]->category) && !empty($json["filter"]->category))
		{
			$args ["tax_query"] = array(
				array( 'taxonomy' => 'ad_cat',
				       'field'    => 'ID',
				       'terms'    => $json["filter"]->category )
			);
		}
		if(! is_null($json["filter"]->city) && !empty($json["filter"]->city))
		{
			$args ["meta_key"] = "cp_state";
			$args ["meta_value"] = $json["filter"]->city;
		}
		if(! is_null($json["filter"]->search) && !empty($json["filter"]->search))
		{
			$args ["s"] = $json["filter"]->search;
		}
		if(isset($json['id'])){
			if($json['id'] != ""){
				$args ["p"] = $json["id"];
			}
		}
		//$sticky = get_option("sticky_posts");
		$posts = new WP_Query( $args );
		if( !is_null($posts->posts) && !empty($posts->posts) ){
			foreach ($posts->posts as $key ) {
				$key->post_content = apply_filters("the_content" , $key->post_content);
				$x = get_post_meta($key->ID);
				$xx = array();
				foreach ($x as $k => $v){
					$xx[$k][] = implode(',',$v);
				}
				$key->post_meta = $xx;//get_post_meta($key->ID);
				//$key->post_meta = get_post_meta($key->ID);
				$media_meta = get_post_meta($key->ID , "_app_media");
				$new_images = array();
				foreach ($media_meta as $key1) {
					foreach ($key1 as $value) {
						$images[] = /*get_attached_file*/wp_get_attachment_url( $value );
						$new_images[] = array(
							'url' => wp_get_attachment_url( $value ),
							'id' => $value,
						);
					}
				}

				$key->sticky = intval(is_sticky($key->ID));
				$key->images = $images;
				$key->new_images = $new_images;
				$categories = get_the_terms($key->ID,"ad_cat");
				if(!empty($categories)){
					foreach( $categories as $category ) {
						$key->cats = $category->name;
						$key->cat_id = $category->term_id;
					}
				}
				$images = "";
				global $wpdb;
				$query = "SELECT * FROM $wpdb->p2p where p2p_type = 'order-connection' and p2p_to = $key->ID";
				if($query){
					$key->payment = 1;
				}else{
					$key->payment = 0;
				}
				$sold = get_post_meta($key->ID , "cp_ad_sold");
				if ( $sold != 'yes' ) {
					$key->sold = 0;
				}else{
					$key->sold = 1;
				}
			}
		}
		echo json_encode($posts->posts);
	}

	public function ad2app_GET_ads_cat(){
		header('Content-Type: application/json; charset=utf-8');
		$cats = get_categories(array('taxonomy' => 'ad_cat','hide_empty'=> 0));
		$arr_cats = array();
		foreach($cats as $cat){
			$cat->icon = get_term_meta($cat->term_id,'icon',true)?: '';
			$cat->related_post_cat = get_term_meta($cat->term_id,'related_post_cat',true)?: '';
			$arr_cats[] = $cat;
		}
		echo json_encode($arr_cats);
	}

	public function ad2app_my_ads(){

		header('Content-Type: application/json; charset=utf-8');
		$in = $_GET['in'];
		//$in =  '{"p_id":6764,"id":251}';
		$slashless = stripcslashes($in);
		$url_json = urldecode($slashless);
		$json = (array) json_decode($url_json);
		$args = array(
			'author' => $json["id"],
			//'paged' => 1,
			'posts_per_page' => -1,
			'post_type' => "ad_listing" ,
			'post_status' => 'any',
		);
		if(isset($json['p_id'])){
			if($json['p_id'] != ""){
				$args ["p"] = $json["p_id"];
			}
		}
		$creds = array(
			'user_login'    => $json["username"],
			'user_password' => $json["password"],
			'remember'      => true
		);
		remove_action("wp_login","cp_redirect_to_home_page");
		$user1 = wp_signon( $creds, false );
		if ( !is_wp_error( $user1 ) ) {
			echo 0;
			return;
		}
		//$sticky = get_option("sticky_posts");
		$posts = new WP_Query( $args );
		$new_images = array();$images = array();
		$xx = array();
		foreach ($posts->posts as $key ) {
			$x = get_post_meta($key->ID);
			$xx = array();
			foreach ($x as $k => $v){
				$xx[$k][] = implode(',',$v);
			}
			$key->post_meta = $xx;//get_post_meta($key->ID);
			//$key->post_meta = get_post_meta($key->ID);
			$media_meta = get_post_meta($key->ID , "_app_media");
			$f_src = 0;
			$f_src_id = 0;
			if(!empty($media_meta)){
				foreach ($media_meta as $key1) {
					if(!is_array($key1)) continue;
					foreach ($key1 as $value) {
						if($f_src == 0){
							$f_src_id = $value;
							$f_src = 1;
						}
						$images[] = wp_get_attachment_url( $value );
						$new_images[] = array(
							'url' => wp_get_attachment_url( $value ),
							'id' => $value,
						);
					}
				}
			}
			$key->sticky = intval(is_sticky($key->ID));
			$key->images = $images;
			$key->new_images = $new_images;
			$categories = get_the_terms($key->ID,"ad_cat");
			if(is_array($categories)){
				foreach( $categories as $category ) {
					$key->cats = $category->name;
					$key->cat_id = $category->term_id;
				}
			}
			$images = array();
			$new_images = "";
			global $wpdb;
			$order_p2p = $wpdb->get_row( $wpdb->prepare( "SELECT * FROM $wpdb->p2p WHERE p2p_to = %d", $json["id"] ));
			if(get_post_status( $order_p2p->p2p_from ) == "tr_completed"){
				$key->payment = 1;
			}else{  $key->payment = 0; }
			$sold = get_post_meta($key->ID , "cp_ad_sold");
			if ( $sold != 'yes' ) {
				$key->sold = 0;
			}else{
				$key->sold = 1;
			}
			$key->order = $this->get_order_agahi($key->ID);
			$key->featured_src = wp_get_attachment_image_src( $f_src_id, $image_size) ? wp_get_attachment_image_src( $f_src_id, $image_size)[0] : '';
			$key->publish_time = strtotime($key->post_date);
			$key->expire_time = (int)strtotime(get_post_meta($key->ID , 'cp_sys_expire_date' , true));
		}
		echo json_encode($posts->posts);
		return;
	}

	public function cp_min_price($cf){
		global $wpdb;
		$tbl_posts = $wpdb->prefix.'posts';
		$tbl_postmeta = $wpdb->prefix.'postmeta';
		return str_replace( ',', '', $wpdb->get_var( "SELECT min( CAST( m.meta_value AS UNSIGNED ) ) FROM $tbl_postmeta m INNER JOIN $tbl_posts p ON m.post_id = p.ID WHERE m.meta_key = '".$cf."' AND p.post_status = 'publish'" ) );
	}

	public function cp_max_price($cf){
		global $wpdb;
		$tbl_posts = $wpdb->prefix.'posts';
		$tbl_postmeta = $wpdb->prefix.'postmeta';
		return str_replace( ',', '', $wpdb->get_var( "SELECT max( CAST( m.meta_value AS UNSIGNED ) ) FROM $tbl_postmeta m INNER JOIN $tbl_posts p ON m.post_id = p.ID WHERE m.meta_key = '".$cf."' AND p.post_status = 'publish'" ) );
	}

	// ORDER

	public function register_order($post_id){
		header('Content-Type: application/json; charset=utf-8');
		$msg  = "";
		if(isset($_POST['in'])){
			$in = $_POST['in'];
			$slashless = stripcslashes($in);
			$url_json = urldecode($slashless);
			$json = json_decode($url_json);
			if($post_id == -1){
				$post_id = $json->post_id;
				if(!isset($_GET['ad2app_order'])){
					$this->update_agahi('pending',$post_id , $json->single);
				}
			}
			$agahi = get_post($post_id);
			if($json->category != "" && $agahi->post_status != 'publish'){
				$this->order_category($json , $agahi);
			}
			elseif ($json->single != "" && $agahi->post_status != 'publish'){
				$this->order_single($json , $agahi);
			}
			elseif($json->featured != "" && $agahi->post_status != 'publish'){
				$this->order_featured($json , $agahi);
			}
			elseif (($json->featured != "" || $json->single != "" || $json->category) && $agahi->post_status == 'publish'){
				$msg = 'امکان ثبت سفارش آگهی برای این آگهی نیست !';
			}
			elseif($json->bump_id != ""){

				wp_set_current_user($json->user);
				$this->ajax_bump_ad($post_id,$json->bump_id);

				return;
			}
			else{
				$this->republication();
				return;
			}
		}
		echo json_encode(array(
			'result' => '0',
			'msg' => $msg,
			'post_id' => $post_id,
			'order_id' => -1
		));
		return;
	}

	private function order_featured($json , $agahi){
		$post_id = $agahi->ID;
		$label = "رایگان بجز این که ویژه شود ";
		if($json->featured != ""){
			$label = $label . " / ویژگی ";
			stick_post($post_id);
		}
		$order_factory = APP_Order_Factory::create($agahi->post_title.'::'.$label);
		$order_factory->set_author($agahi->post_author);
		$hash = substr( sha1( time() . mt_rand( 0, 1000 ) ), 0, 20 );
		update_post_meta( $order_factory->get_id(), 'checkout_type', 'create-listing' );
		update_post_meta( $order_factory->get_id(), 'checkout_hash', $hash );
		$checkout_url = get_permalink( CP_Add_New::get_id() );
		$complete_url = add_query_arg( array( 'step' => 'order-summary', 'hash' => $hash ), $checkout_url );
		$cancel_url = add_query_arg( array( 'step' => 'gateway-select', 'hash' => $hash ), $checkout_url );
		update_post_meta( $order_factory->get_id(), 'complete_url', $complete_url );
		update_post_meta( $order_factory->get_id(), 'cancel_url', $cancel_url );
		$post = get_post($order_factory->get_id());
		$item = array();
		$order = new APP_Instant_Order($post,$item);
		$s_price = get_option("cp_options");
		$sticky_price = $s_price["sys_feat_price"];
		$order->add_item(  'featured' , 0 , $agahi->ID);
		$order->add_item(  'featured-listing' , $sticky_price , $agahi->ID);
		$total_price = (int) $order->get_total();
		if($total_price == 0){
			$this->order_complete($order->get_id());
			$this->action_post( $agahi->ID);
		}
		update_post_meta($agahi->ID , 'cp_sys_total_ad_cost' , (int)$order->get_total());
		echo json_encode(array(
			'result' => '1',
			'msg' => 'سفارش شما ثبت شد.',
			'order_id' => $order_factory->get_id(),
			'post_id' => $post_id,
			'total' => $order->get_total(),
			'total_price' => $total_price
		));
		die();
	}

	private function order_single($json , $agahi){
		$post_id = $agahi->ID;
		$baste = get_post($json->single);
		$meta_baste = get_post_meta($json->single);
		$label = $baste->post_title;
		if($json->featured != ""){
			$label = $baste->post_title . "/ ویژگی";
			stick_post($post_id);
		}
		else{
			unstick_post($post_id);
		}
		$order_factory = APP_Order_Factory::create($agahi->post_title.'::'.$label);
		//$order_factory->set_author($json->u_id);
		$order_factory->set_author($agahi->post_author);
		$hash = substr( sha1( time() . mt_rand( 0, 1000 ) ), 0, 20 );
		update_post_meta( $order_factory->get_id(), 'checkout_type', 'create-listing' );
		update_post_meta( $order_factory->get_id(), 'checkout_hash', $hash );
		$checkout_url = get_permalink( CP_Add_New::get_id() );
		$complete_url = add_query_arg( array( 'step' => 'order-summary', 'hash' => $hash ), $checkout_url );
		$cancel_url = add_query_arg( array( 'step' => 'gateway-select', 'hash' => $hash ), $checkout_url );
		update_post_meta( $order_factory->get_id(), 'complete_url', $complete_url );
		update_post_meta( $order_factory->get_id(), 'cancel_url', $cancel_url );
		update_post_meta($order_factory->get_id() , "gateway" ,  'zarinpal');
		update_post_meta($order_factory->get_id() , "_checked" , "no" );
		$post = get_post($order_factory->get_id());
		$item = array();
		$order = new APP_Instant_Order($post,$item);
		$order->add_item(  $baste->post_name , $meta_baste["price"][0] , $agahi->ID);
		if($json->featured != ""){
			$s_price = get_option("cp_options");
			$sticky_price = $s_price["sys_feat_price"];
			$order->add_item(  'featured-listing' , $sticky_price , $agahi->ID);
		}
		$total_price = (int) $order->get_total();
		if($total_price == 0){
			$this->order_complete($order->get_id());
			$this->action_post( $agahi->ID);
			//$this->publish($post_id);
		}
		update_post_meta($agahi->ID , 'cp_sys_total_ad_cost' , (int)$order->get_total());
		echo json_encode(array(
			'result' => '1',
			'msg' => 'سفارش شما ثبت شد..',
			'order_id' => $order_factory->get_id(),
			'post_id' => $agahi->ID,
			'total' => $order->get_total(),
			'total_price' => $total_price
		));
		die();
	}

	private function order_category($json , $agahi){
		$post_id = $agahi->ID;
		$price_cats = get_option( 'cp_options' );
		$price_cats = $price_cats['price_per_cat'];
		foreach ($price_cats as $cat_id => $price){
			if($cat_id == $json->category){
				$cat_price = $price;
				break;
			}
		}
		$label = "هزینه برای هر دسته ";
		if($json->featured != ""){
			$label = "هزینه برای هر دسته / ویژگی";
			stick_post($post_id);
		}
		else{
			unstick_post($post_id);
		}
		$order_factory = APP_Order_Factory::create($agahi->post_title.'::'.$label);
		$order_factory->set_author($agahi->post_author);
		$hash = substr( sha1( time() . mt_rand( 0, 1000 ) ), 0, 20 );
		update_post_meta( $order_factory->get_id(), 'checkout_type', 'create-listing' );
		update_post_meta( $order_factory->get_id(), 'checkout_hash', $hash );
		$checkout_url = get_permalink( CP_Add_New::get_id() );
		$complete_url = add_query_arg( array( 'step' => 'order-summary', 'hash' => $hash ), $checkout_url );
		$cancel_url = add_query_arg( array( 'step' => 'gateway-select', 'hash' => $hash ), $checkout_url );
		update_post_meta( $order_factory->get_id(), 'complete_url', $complete_url );
		update_post_meta( $order_factory->get_id(), 'cancel_url', $cancel_url );
		update_post_meta($order_factory->get_id() , "gateway" ,  'zarinpal');
		$post = get_post($order_factory->get_id());
		$item = array();
		$order = new APP_Instant_Order($post,$item);
		$order->add_item(  'category' , $cat_price , $agahi->ID);

		if($json->featured != ""){
			$s_price = get_option("cp_options");
			$sticky_price = $s_price["sys_feat_price"];
			$order->add_item(  'featured-listing' , $sticky_price , $agahi->ID);
		}
		$total_price = (int) $order->get_total();
		if($total_price == 0){
			$this->order_complete($order->get_id());
			$this->action_post( $agahi->ID);
		}
		update_post_meta($agahi->ID , 'cp_sys_total_ad_cost' , (int)$order->get_total());
		echo json_encode(array(
			'result' => '1',
			'msg' => 'سفارش شما ثبت شد.',
			'order_id' => $order_factory->get_id(),
			'post_id' => $post_id,
			'total' => $order->get_total(),
			'total_price' => $total_price
		));
		die();
	}

	public function order_in_payment(){
		header('Content-Type: application/json; charset=utf-8');
		if(isset($_POST['in'])) {
			$in = $_POST['in'];
			$slashless = stripcslashes($in);
			$url_json = urldecode($slashless);
			$json = json_decode($url_json);
			//$r = $this->register_order_in_payment($json->post_id);
			$r = array();
			$r['action'] = false;
			if(isset($json->order_id) && !empty($json->order_id)){
				update_post_meta($json->order_id,'gateway' , 'in_app_payment');
				update_post_meta($json->order_id,'_checked' , 'yes');
				add_post_meta($json->order_id,'transaction_id' , $json->transaction_id);
				$post = get_post($json->order_id);
				$item = array();
				$order = new APP_Instant_Order($post,$item);
				$order->complete();
				//$order->activate();
				if($json->bump_id != ''){
					wp_set_current_user($json->user_id);
					$obj = new CP_Bump_Ad_Plugin();
					$obj->setup_orders();
					$item = array();
					$order = new APP_Instant_Order($post,$item);
					//$obj->payments_handle_ad_bump_activated($order);
					if ( $obj->packages ) {
						$user = get_user_by( 'id', $order->get_author() );
						$package = $obj->packages->get_package( $json->bump_id );
						//var_dump($package);return;
						if ( $package && $user ) {
							/* save purchased bump pack if exists */
							$obj->packages->update_user_package( $user->ID, $package );
							$post_id = $obj->_cp_get_order_ad_id( $order );
							/* decrease bumps */
							$try_bump = $obj->packages->decrease_user_bumps( $user->ID );
						}
					} else {
						$post_id = $obj->_cp_get_order_ad_id( $order );
						$try_bump = true;
					}

					if ( $try_bump ) {
						/* bump */
						$obj->bump_ad( $post_id );
					}
				}

				if($json->category != "" || $json->single != "" || $json->bump != ""){

					$this->action_post($json->post_id);
				}
				$r['action'] = true;
				$r['msg'] = 'سفارش تکمیل شده است.';
			}
			echo json_encode($r);
			return;
		}
		echo json_encode(array('success' => false , 'msg' => 'ورودی ها اشتباه است'));
		return;
	}

	protected function register_order_in_payment($post_id){
		header('Content-Type: application/json; charset=utf-8');
		if(isset($_POST['in'])){
			$in = $_POST['in'];
			$slashless = stripcslashes($in);
			$url_json = urldecode($slashless);
			$json = json_decode($url_json);
			//var_dump($json);return;
			if($json->category != ""){
				$price_cats = get_option( 'cp_options' );
				$price_cats = $price_cats['price_per_cat'];
				foreach ($price_cats as $cat_id => $price){
					if($cat_id == $json->category){
						$cat_price = $price;
						break;
					}
				}
				//$agahi = get_post($json->post_id);
				$agahi = get_post($post_id);
				$label = "هزینه برای هر دسته ";
				if($json->featured != ""){
					$label = "هزینه برای هر دسته / ویژگی";
				}
				$order_factory = APP_Order_Factory::create($agahi->post_title.'::'.$label);
				//$order_factory->set_author($json->u_id);
				$order_factory->set_author($json->user);
				$hash = substr( sha1( time() . mt_rand( 0, 1000 ) ), 0, 20 );
				update_post_meta( $order_factory->get_id(), 'checkout_type', 'create-listing' );
				update_post_meta( $order_factory->get_id(), 'checkout_hash', $hash );
				$checkout_url = get_permalink( CP_Add_New::get_id() );
				$complete_url = add_query_arg( array( 'step' => 'order-summary', 'hash' => $hash ), $checkout_url );
				$cancel_url = add_query_arg( array( 'step' => 'gateway-select', 'hash' => $hash ), $checkout_url );
				update_post_meta( $order_factory->get_id(), 'complete_url', $complete_url );
				update_post_meta( $order_factory->get_id(), 'cancel_url', $cancel_url );
				$post = get_post($order_factory->get_id());
				$item = array();
				$order = new APP_Instant_Order($post,$item);
				$order->add_item(  'category' , $cat_price , $agahi->ID);

				if($json->featured != ""){
					$s_price = get_option("cp_options");
					$sticky_price = $s_price["sys_feat_price"];
					$order->add_item(  'featured-listing' , $sticky_price , $agahi->ID);
					$this->ad2app_sticky($json->post_id);

				}
				$total_price = get_post_meta($order_factory->get_id(),'total_price');
				if($total_price == 0){
					$this->publish($post_id);
				}
				return array(
					'result' => '1',
					'msg' => 'سفارش شما ثبت شد.',
					'order_id' => $order_factory->get_id(),
					'post_id' => $post_id,
				);
			}
			elseif ($json->single != ""){
				$agahi = get_post($json->post_id);
				$baste = get_post($json->single);
				$meta_baste = get_post_meta($json->single);
				$label = $baste->post_title;
				if($json->featured != ""){
					$label = $baste->post_title . " / ویژگی ";
				}
				$order_factory = APP_Order_Factory::create($agahi->post_title.'::'.$label);
				//$order_factory->set_author($json->u_id);
				$order_factory->set_author($json->user);
				$hash = substr( sha1( time() . mt_rand( 0, 1000 ) ), 0, 20 );
				update_post_meta( $order_factory->get_id(), 'checkout_type', 'create-listing' );
				update_post_meta( $order_factory->get_id(), 'checkout_hash', $hash );
				$checkout_url = get_permalink( CP_Add_New::get_id() );
				$complete_url = add_query_arg( array( 'step' => 'order-summary', 'hash' => $hash ), $checkout_url );
				$cancel_url = add_query_arg( array( 'step' => 'gateway-select', 'hash' => $hash ), $checkout_url );
				update_post_meta( $order_factory->get_id(), 'complete_url', $complete_url );
				update_post_meta( $order_factory->get_id(), 'cancel_url', $cancel_url );
				$post = get_post($order_factory->get_id());
				$item = array();
				$order = new APP_Instant_Order($post,$item);
				$order->add_item(  $baste->post_name , $meta_baste["price"][0] ,$agahi->ID);
				if($json->featured != ""){
					$s_price = get_option("cp_options");
					$sticky_price = $s_price["sys_feat_price"];
					$order->add_item(  'featured-listing' , $sticky_price , $agahi->ID);
					$this->ad2app_sticky($json->post_id);
				}
				$total_price = get_post_meta($order_factory->get_id(),'total_price');
				if($total_price == 0){
					$this->publish($post_id);
				}
				return array(
					'result' => '1',
					'msg' => 'سفارش شما ثبت شد.',
					'order_id' => $order_factory->get_id(),
					'post_id' => $post_id,
				);
			}
			elseif($json->featured != ""){
				$agahi = get_post($json->post_id);
				$this->ad2app_sticky($json->post_id);
				$label = "رایگان بجز این که ویژه شود ";
				if($json->featured != ""){
					$label = $label . " / ویژگی ";
				}
				$order_factory = APP_Order_Factory::create($agahi->post_title.'::'.$label);
				//$order_factory->set_author($json->u_id);
				$order_factory->set_author($json->user);
				$hash = substr( sha1( time() . mt_rand( 0, 1000 ) ), 0, 20 );
				update_post_meta( $order_factory->get_id(), 'checkout_type', 'create-listing' );
				update_post_meta( $order_factory->get_id(), 'checkout_hash', $hash );
				$checkout_url = get_permalink( CP_Add_New::get_id() );
				$complete_url = add_query_arg( array( 'step' => 'order-summary', 'hash' => $hash ), $checkout_url );
				$cancel_url = add_query_arg( array( 'step' => 'gateway-select', 'hash' => $hash ), $checkout_url );
				update_post_meta( $order_factory->get_id(), 'complete_url', $complete_url );
				update_post_meta( $order_factory->get_id(), 'cancel_url', $cancel_url );
				$post = get_post($order_factory->get_id());
				$item = array();
				$order = new APP_Instant_Order($post,$item);
				$s_price = get_option("cp_options");
				$sticky_price = $s_price["sys_feat_price"];
				$order->add_item(  'featured' , 0 , $agahi->ID);
				$order->add_item(  'featured-listing' , $sticky_price , $agahi->ID);
				$total_price = get_post_meta($order_factory->get_id(),'total_price');
				if($total_price == 0){
					$this->publish($post_id);
				}
				return array(
					'result' => '1',
					'msg' => 'سفارش شما ثبت شد.',
					'order_id' => $order_factory->get_id(),
					'post_id' => $post_id,
				);
			}
			elseif($json->bump != ""){

				wp_set_current_user($json->user);
				$obj = new CP_Bump_Ad_Plugin();
				$obj->setup_orders();
				$cost = $obj->packages->get_package( $json->bump_id )->price;
				if ( $cost <= 0 ) {
					return;
				}
				$post = get_post( $post_id );
				$order_factory = APP_Order_Factory::create('بسته : ' . $obj->packages->get_package( $json->bump_id )->pack_name);
				//$order_factory->set_author($json->u_id);
				$order_factory->set_author($json->user);
				$hash = substr( sha1( time() . mt_rand( 0, 1000 ) ), 0, 20 );
				update_post_meta( $order_factory->get_id(), 'checkout_type', 'buy-bump');
				update_post_meta( $order_factory->get_id(), 'checkout_hash', $hash );
				$checkout_url = esc_url_raw( add_query_arg( 'buy_bump', 1, get_permalink( $post->ID ) ) );
				$complete_url = add_query_arg( array( 'step' => 'order-summary', 'hash' => $hash ), $checkout_url );
				$cancel_url = add_query_arg( array( 'step' => 'gateway-select', 'hash' => $hash ), $checkout_url );
				update_post_meta( $order_factory->get_id(), 'complete_url', $complete_url );
				update_post_meta( $order_factory->get_id(), 'cancel_url', $cancel_url );
				$post_order = get_post($order_factory->get_id());
				$item = array();
				$order = new APP_Instant_Order($post_order,$item);
				//return $obj->packages->get_package( $pack_id );
				$order->add_item(   $obj->packages->get_package( $json->bump_id )->post_name , $cost, $post->ID);
				$url = $order->get_return_url();

				return $response = array(
					'result' => '2',
					'msg' => 'سفارش شما ثبت شد.',
					'order_id' => $order_factory->get_id(),
					'post_id' => $post->ID,
				);

			}
		}
		return array(
			'result' => '0',
			'msg' => 'سفارش موجود نمی باشد',
			'post_id' => $post_id,
			'order_id' => -1
		);
	}

	protected function order_complete($order_id){
		$my_post = array(
			'ID'=> $order_id,
			'post_status' => APPTHEMES_ORDER_COMPLETED
		);
		// Update the post into the database
		wp_update_post( $my_post );
	}

	public function get_order_agahi($post_id){
		$connected = _appthemes_orders_get_connected( $post_id );
		$orders = array();
		if(isset($connected->post) && $connected->post->post_status == 'tr_pending'){
			$order = get_order( $connected->post->ID );

			$orders = array(
				'order_id' => $connected->post->ID ,
				'total' => intval($order->get_total()),
				'total_string' => get_the_order_total($connected->post->ID) ,
				'gateway' => get_post_meta($connected->post->ID , 'gateway' , true),
				'order_status' => $connected->post->post_status ,
				'order_status' => $connected->post->post_status ,
				'post_title' => $connected->post->post_title ,
				'post_date' => $connected->post->post_date ,
			);
		}
		return $orders;
	}

	public function republication(){
		header('Content-Type: application/json; charset=utf-8');
		$result = array(
			'result' => 0 ,
			'msg' => 'تمدید آگهی با خطا مواجه شد.'
		);
		if(isset($_POST['in'])) {
			$in        = $_POST['in'];
			$slashless = stripcslashes( $in );
			$url_json  = urldecode( $slashless );
			$json      = json_decode( $url_json );
			global $cp_options;
			if(!$cp_options->charge_ads){
				if(cp_is_listing_expired($json->post_id)){
					$ad_expire_date = appthemes_mysql_date( current_time( 'mysql' ) , $cp_options->prun_period );
					if(!$cp_options->moderate_ads){
						$my_post = array(
							'ID'=> $json->post_id,
							'post_status' => 'publish'
						);
					}
					else{
						$my_post = array(
							'ID'=> $json->post_id,
							'post_status' => 'pending'
						);
					}
					if($r = wp_update_post( $my_post )){
						update_post_meta($json->post_id,'cp_sys_expire_date' , $ad_expire_date);
						update_post_meta($json->post_id,'cp_sys_ad_duration' , $cp_options->prun_period);
						$result = array(
							'result' => $r ,
							'msg' => 'آگهی با موفقیت ، تمدید شد.'
						);
					}
				}
			}
		}
		echo json_encode($result);
		return;
	}

	protected function action_post($post_id){
		global $cp_options;

		if(!$cp_options->moderate_ads){
			//edit post for publish
			return $this->ad2app_payments_handle_ad_listing_activated('publish',$post_id);
		}
		else{
			return $this->ad2app_payments_handle_ad_listing_activated('pending',$post_id);

		}
		return false;
	}

	public function update_agahi($publish, $ad_id = 0  , $single){
		global $cp_options;

		if ( ! $ad_id ) {
			return;
		}

		// update listing status
		if($single != ""){
			$p_m = get_post_meta($single,'duration');
			$duration = $p_m[0];
		}
		else{
			$duration = $cp_options->prun_period;
		}
		$listing_args = array(
			'ID'            => $ad_id,
			'post_status'   => $publish,
			'post_date'     => current_time( 'mysql' ),
			'post_date_gmt' => current_time( 'mysql', 1 ),
			'meta_input' => array(
				'cp_sys_ad_duration' => $duration
			)
		);

		return wp_update_post( $listing_args );
	}

	protected  function ad2app_payments_handle_ad_listing_activated( $publish, $ad_id = 0 ) {
		global $cp_options;

		if ( ! $ad_id ) {
			return;
		}

		// update listing status
		$listing_args = array(
			'ID'            => $ad_id,
			'post_status'   => $publish,
			'post_date'     => current_time( 'mysql' ),
			'post_date_gmt' => current_time( 'mysql', 1 ),
		);

		$listing_id = wp_update_post( $listing_args );

		$ad_length = get_post_meta( $listing_id, 'cp_sys_ad_duration', true );
		if ( empty( $ad_length ) ) {
			$ad_length = $cp_options->prun_period;
		}

		$ad_expire_date = appthemes_mysql_date( current_time( 'mysql' ), $ad_length );
		return update_post_meta( $listing_id, 'cp_sys_expire_date', $ad_expire_date );

	}

	public function ad2app_payment(){

//		$r = array(
//			'user' => $_SERVER['PHP_AUTH_USER'],
//			'pass' => $_SERVER['PHP_AUTH_PW'],
//			'base64' => base64_encode('09155103877:1122')
//		);
//		echo json_encode($r);return;
		if(isset($_GET['gateway']) && isset($_GET['order_id'])) {
			$order_id = $_GET['order_id'];
			$gateway  = $_GET['gateway'];
			$json = base64_decode($_GET['api_key']);
			$json =  (array) json_decode($json);
			$username = isset($json['username']) ? $json['username'] : $json['nameKarbari'];
			$password = isset($json['password']) ? $json['password'] : $json['ramz'];
			$this->action_order_pay($order_id , $gateway , $username , $password);
		}
		elseif(isset($_POST['in'])){
			$in = $_POST['in'];
			$slashless = stripcslashes($in);
			$url_json = urldecode($slashless);
			$json = json_decode($url_json);
			$order_id = $json->order_id;
			$gateway  = $json->gateway;
			$username = $json->username;
			$password = $json->password;
			$this->action_order_pay($order_id , $gateway , $username , $password);
		}
	}
	public function action_order_pay($order_id , $gateway , $username , $password){
		update_post_meta( $order_id, "gateway", $gateway );
		update_post_meta( $order_id, "_checked", "no" );
		$checkout_url = get_option('siteurl');
		$complete_url = add_query_arg( array( 'transaction' => $order_id ), $checkout_url );
		$user = array(
			'user_login'    => $username,
			'user_password' => $password,
			'remember'      => true
		);
		remove_action("wp_login","cp_redirect_to_home_page");
		// login user to browser ...
		$u = wp_signon( $user, false );
		if($u->errors){
			if($u = get_user_by( 'login', $username )){
				if(get_user_meta($u->ID , 'app-sms-code' , true) == $password){
					$new_pass = rand(100000,999999);
					wp_update_user( array(
						'ID' => $u->ID,
						'user_pass' => $new_pass
					));
					$user = array(
						'user_login'    => $username,
						'user_password' => $new_pass,
						'remember'      => true
					);
					wp_signon( $user, false );
				}
			}
		}
		//redirect user to gateway with classipress
		wp_redirect( $complete_url);
	}

	function hami_changepass_webservice(){
		ob_start();
		if(!empty($_GET["in"])){
			$in = $_GET['in'];
			$slashless = stripcslashes($in);
			$url_json = urldecode($slashless);
			$json = (array)  json_decode($url_json);
			$user = isset($json["user_name"]) ? $json["user_name"] : $json["nameKarbari"];
			$pass = isset($json["old_pass"]) ? $json["old_pass"] : $json["old_ramz"];
			$new_pass = isset($json["new_pass"]) ? $json["new_pass"] : $json["new_ramz"];
			$flag = 0;
			$hami_check = get_user_by( 'login', $user );
			if(username_exists( $user ) == false){
				ob_clean();
				echo $flag = -1;
			}elseif ( $hami_check && !wp_check_password( $pass, $hami_check->data->user_pass, $hami_check->ID)){
				ob_clean();
				echo $flag = -1;
			}
			if ($flag != -1) {
				$update_user = wp_update_user( array (
						'ID' => $hami_check->ID,
						'user_pass' => $new_pass
					)
				);
				if ($update_user) {
					ob_clean();
					echo 1;
				}
			}
		}else{
			return 0;
		}
	}//end webservice hami login

	public function get_form_category(){
		header('Content-Type: application/json; charset=utf-8');
		ob_start();
		if(!empty($_GET["in"])) {
			$in        = $_GET['in'];
			$slashless = stripcslashes( $in );
			$url_json  = urldecode( $slashless );
			$json      = (array) json_decode( $url_json );
			$category = $json['cat_id'];
			$form_id = cp_get_form_id($category);
			$fields = cp_get_custom_form_fields($form_id);
			echo json_encode(array('fields' => $fields));
		}
	}
}
