<?php
/**
 * Created by PhpStorm.
 * User: hani
 * Date: 12/11/17
 * Time: 4:21 PM
 */
?>
<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
class ad2app_lang {
	public $site_address = "";

	function __construct( $url ) {
		$this->site_address = $url;
		add_action( 'init', array( $this, 'ad2app_regular_all' ) );
		add_filter( 'query_vars', array( $this, 'ad2app_query_vars' ) );
		add_action( 'parse_request', array( $this, 'ad2app_parse_request' ) );
	}

	function ad2app_regular_all() {
		return;
	}

	function ad2app_query_vars( $query_vars ) {
		$query_vars[] = 'ad2app_get_lang';
		$query_vars[] = 'ad2app_get_word';

		return $query_vars;
	}

	function ad2app_parse_request( &$wp ) {
		if ( array_key_exists( 'ad2app_get_lang', $wp->query_vars ) ) {
			$this->ad2app_get_lang();
			exit();
		}
		if ( array_key_exists( 'ad2app_get_word', $wp->query_vars ) ) {
			$this->ad2app_get_word();
			exit();
		}
	}

	function ad2app_get_lang() {
		header('Content-Type: application/json; charset=utf-8');
		$args      = array(
			'post_type'   => 'ad2app_lang',
			'post_status' => 'close'
		);
		$the_query = get_posts( $args );
		//var_dump($the_query);
		$array = array();
		foreach ( $the_query as $key ) {
			$array['language'][] = array(
				'ID' => $key->ID,
				'title' => $key->post_title,
				'slug' => $key->post_name,
				'icon' => $key->post_excerpt,
				'category' => $key->post_content,
				'direction' => $key->pinged,
				'display' => $key->post_password,
			);
		}
		echo json_encode($array);
		return;
	}
	function ad2app_get_word() {
		header('Content-Type: application/json; charset=utf-8');
		$args      = array(
			'post_type'   => 'ad2app_lang',
			'post_status' => 'close'
		);
		$the_query = get_posts( $args );
		$array = array();
		foreach ( $the_query as $key ) {
			$x = get_post_meta($key->ID);
			foreach ($x as $key1=>$val){
				$array['words'][] = array(
					'word_id' => $key1,
					'lang_id' => $key->ID,
					'translate' => $val[0]
				);
			}
		}
		echo json_encode($array);
		return;
	}
}
