<?php
/*
Plugin Name: AD2App
Plugin URI: http://mr2app.com
Description: افزونه اپلیکیشن ساز آگهی مستر تو اپ
Version: 3.0.1
Author: مستر تو اپ
Author URI: http://mr2app.com
Text Domain: Mr2app
*/
if (!defined( 'ABSPATH' )) exit;
define('AD2APP_VERSION' , "3.0.1");
define( 'AD2APP_PATH' , plugin_dir_path( __FILE__ ));
define('AD2APP_URL', plugin_dir_url(__FILE__));
define('AD2APP_CSS_URL', trailingslashit(AD2APP_URL.'files/css'));
define('AD2APP_JS_URL', trailingslashit(AD2APP_URL.'files/js'));
define('AD2APP_SITE_URL', get_site_url());
//error_reporting(E_ALL);
ini_set('display_errors', 0);
if(!class_exists('AD2APP_install')){
    class AD2APP_install{

        function __construct(){
            $this->ad2app_api();
            add_action('admin_menu' , array($this , 'ad2app_config_menu'));
        }

        static  function ad2app_config_menu(){
            include_once( 'ad2app_config/config_ad2app_menu.php') ;
            $ad2app_config_menu = new ad2app_config_menu();
        }

        function ad2app_api(){
            include_once( 'ad2app_service/ad2app_api.php') ;
            $ad2app_api = new ad2app_api(AD2APP_SITE_URL);

            include_once( 'ad2app_service/ad2app_api_lang.php') ;
            $ad2app_api_lang = new ad2app_lang(AD2APP_SITE_URL);

	        include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
	        if (!is_plugin_active( 'wp2appir/wp2appir.php')) {
		        //wp2app plugin is not activated
		        require_once AD2APP_PATH . 'ad2app_service/woo2app_api_default_blog.php';
		        $woo = new woo2app_api_default_blog();
		        require_once AD2APP_PATH . 'ad2app_service/woo2app_api_primary_blog.php';
		        $woo = new woo2app_api_primary_blog();
	        }
        }
        static function ad2app_config(){
            include_once( 'ad2app_config/ad2app_config.php');
            $ad2app_config = new ad2app_config();
            ad2app_custom_register();
        }
    }
}

require_once  "register/class_custom_register.php";
$class_custom_register = new class_custom_register();

function ad2app_custom_register(){
    $default_fields = array();
    $default_fields [] = array( 'name' => 'user_login' , 'title' => 'نام کاربری','order' => 1);
    $default_fields [] = array( 'name' => 'user_email' , 'title' => 'ایمیل','order' => 3);
    $default_fields [] = array( 'name' => 'user_pass' , 'title' => 'رمز عبور','order' => 4);
    $default_fields [] = array( 'name' => 'user_url' , 'title' => 'آدرس سایت','order' => 5);
    $default_fields [] = array( 'name' => 'display_name' , 'title' => 'نام نمایشی','order' => 6);
    $default_fields [] = array( 'name' => 'first_name' , 'title' => 'نام','order' => 7);
    $default_fields [] = array( 'name' => 'last_name' , 'title' => 'نام خانوادگی','order' => 8);
    $default_fields [] = array( 'name' => 'description' , 'title' => 'توضیحات','order' => 9);
    $array_name_new = array('user_login','user_email','user_pass','user_url','display_name','first_name','last_name','description');
    $args      = array(
        'post_type'   => 'ad2app_register',
        'post_status' => 'draft',
        'posts_per_page' => -1,
        'orderby' => 'menu_order',
        'order' => 'ASC',
    );
    $the_query = get_posts( $args );
    $array_name_old = array();
    foreach ($the_query as $p){
        $array_name_old[] = $p->post_content;
    }
    $result = array_diff($array_name_new,$array_name_old);
    foreach ($default_fields as $f){
        if(in_array($f['name'] , $result)) {
            $array = array(
                'post_title'    => $f['title'],
                'post_content' => $f['name'],
                'post_type'     => 'ad2app_register',
                'post_status'   => 'draft',
                'menu_order' => $f['order'],
            );
            $post = wp_insert_post( $array );
            add_post_meta($post,'default','');
            add_post_meta($post,'required',1);
            add_post_meta($post,'active',1);
            add_post_meta($post,'display_edit',1);
            add_post_meta($post,'display_register',1);
            add_post_meta($post,'values','');
            add_post_meta($post,'type','text');
            add_post_meta($post,'validate','general');
        }
    }
    $array = array(
        'enable' => 0,
        'field' => '',
        'panel' => '',
        'number' => '',
        'username'=> '',
        'password' => ''
    );
    if(!get_option('mr2app_sms')){
        add_option('mr2app_sms',$array);
    }
}

function ad2app_tm_additional_profile_fields( $user ) {
    $default_fields = array('user_login','user_email','user_pass','user_url','display_name','first_name','last_name','description');
    $args      = array(
        'post_type'   => 'ad2app_register',
        'post_status' => 'draft',
        'posts_per_page' => -1,
        'orderby' => 'menu_order',
        'order' => 'ASC'
    );
    $the_query = get_posts( $args );
    ?>
    <table class="form-table">
        <script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?key=AIzaSyB1grFb5dYPNOQ5FaDHMkZLmVz3s3OerbI"></script>
        <?php
        foreach ($the_query as $f){
            if(in_array($f->post_content,$default_fields)){
                continue;
            }
            $x = get_user_meta($user->ID,$f->post_content , true);
            if(get_post_meta($f->ID , 'type',true) == 'map'){
                $x = explode(',',$x);
                if($x[0]){ $lat = $x[0];} else{ $lat = '32.2972692';}
                if($x[1]){ $lng = $x[1];} else{ $lng = '54.582283';}
                ?>
                <tr>
                    <th><label >  <?= $f->post_title;?></label></th>
                    <td>
                        <div id="map-canvas_<?= $f->ID;?>" style="width: 300px;height: 150px"></div><!-- #map-canvas -->
                        <script type="text/javascript">
                            google.maps.event.addDomListener( window, 'load', gmaps_results_initialize );
                            var map;
                            var markers = [];
                            function gmaps_results_initialize() {
                                map = new google.maps.Map( document.getElementById( 'map-canvas_' + <?= $f->ID;?> ), {
                                    zoom:           13,
                                    center:         new google.maps.LatLng( <?= $lat ;?>, <?= $lng ;?> ),
                                });
                                var  marker = new google.maps.Marker({
                                    position: new google.maps.LatLng( <?= $lat ;?>, <?= $lng ;?> ),
                                    map:      map,
                                    animation: google.maps.Animation.BOUNCE
                                });
                            }
                        </script>
                    </td>
                </tr>
                <?php
            }
            else{
                ?>
                <tr>
                    <th><label>  <?= $f->post_title;?></label></th>
                    <td>
                        <input type="text" id="<?= $f->post_content; ?>" name="<?= $f->post_content; ?>" class="regular-text" value="<?= $x; ?>">
                    </td>
                </tr>
                <?php
            }
        }
        ?>
    </table>
    <?php
}
add_action( 'edit_user_profile', 'ad2app_tm_additional_profile_fields' );

// Hook is used to save custom fields that have been added to the WordPress profile page (if not current user)

add_action( 'edit_user_profile_update', 'ad2app_update_extra_profile_fields' );
function ad2app_update_extra_profile_fields( $user_id ) {
    if ( current_user_can( 'edit_user', $user_id ) ){

        $args      = array(
            'post_type'   => 'ad2app_register',
            'post_status' => 'draft',
            'posts_per_page' => -1,
            'orderby' => 'menu_order',
            'order' => 'ASC'
        );
        $the_query = get_posts( $args );
        foreach ($the_query as $f){
            update_user_meta( $user_id, $f->post_content, $_POST["$f->post_content"] );
        }
    }
}

register_activation_hook( __FILE__ ,  array('AD2APP_install' , 'ad2app_config'));
$WP2APPIR_install = new AD2APP_install();

if(!get_option('app_setting') || !is_array(get_option('app_setting'))){
    update_option('app_setting',array('app_setting' => array()));

}
//add extra fields to category edit form hook
add_action ( 'ad_cat_edit_form_fields', 'add2app_extra_ad_cat_fields');

//add extra fields to category edit form callback function

function add2app_extra_ad_cat_fields( ) {    //check for existing featured ID
    // Save attachment ID
	wp_register_style( 'select2css', '//cdnjs.cloudflare.com/ajax/libs/select2/3.4.8/select2.css', false, '1.0', 'all' );
	wp_register_script( 'select2', '//cdnjs.cloudflare.com/ajax/libs/select2/3.4.8/select2.js', array( 'jquery' ), '1.0', true );
	wp_enqueue_style( 'select2css' );
	wp_enqueue_script( 'select2' );
    wp_enqueue_media();
    ?>
    <tr class="form-field">
        <th scope="row" valign="top"><label for="cat_Image_url"><?php _e('Image'); ?></label></th>
        <td>
            <div class='image-preview-wrapper'>
                <?php
                $icon = get_term_meta($_GET['tag_ID'],'icon',true);
                $related = get_term_meta($_GET['tag_ID'],'related_post_cat',true);
                ?>
                <img id='image-preview' src="<?= $icon ? $icon : 'http://placehold.it/64x64&text=1x1';?>" style="max-width: 128px;" >
            </div>
            <?php
            if(!empty($icon)){
                ?>
                <button onclick="remove_icon()" class="button" style="color: red;" type="button">  <?php _e( 'Remove image' ); ?></button>
                <?php
            }
            ?>
            <input id="upload_image_button" type="button" class="button" value="<?php _e( 'Upload image' ); ?>" />
            <input type='hidden' name='image_attachment_id' id='image_attachment_id' value='<?= $icon;?>'>
        </td>
    </tr>
    <tr class="form-field">
        <th scope="row" valign="top"><label for="cat_Image_url">  ارتباط با دسته بندی پست </label></th>
        <td>
            <select name="related_post_cat[]"  multiple style="width: 100%" class="regular-text js-example-basic-single">
                <?php
                $cats = get_categories(array('taxonomy' => 'category','hide_empty'=> 0));
                foreach ($cats as $cat){
                    ?>
                    <option <?= in_array( $cat->term_id,  $related ) ? 'selected'  : '' ?> value="<?= $cat->term_id?>"> <?= $cat->name;?></option>
                <?php
                }
                ?>
            </select>
        </td>
    </tr>
    <script>
        jQuery(document).ready(function() {
            jQuery('.js-example-basic-single').select2();
        });
        var custom_uploader_hami;
        jQuery('#upload_image_button').click(function (e) {
            e.preventDefault();
            custom_uploader_hami = wp.media.frames.custom_uploader_hami = wp.media({
                title: 'انتخاب تصویر',
                library: {type: 'image'},
                button: {text: 'انتخاب'},
                multiple: false
            });
            custom_uploader_hami.on('select', function() {
                attachment = custom_uploader_hami.state().get('selection').first().toJSON();
                jQuery('#image_attachment_id').val(attachment.url);
                url_image = attachment.url;

                jQuery('#image-preview').attr("src",url_image);
            });
            custom_uploader_hami.open();
        })
        function remove_icon() {
            jQuery("#image-preview").attr("src" ,'http://placehold.it/64x64&text=1x1');
            jQuery("#image_attachment_id").val('');
        }
    </script>
    <?php
}
add_filter('edited_ad_cat', 'ad2app_update_ad_cat_fields');
function ad2app_update_ad_cat_fields($term_id) {
    if($_POST['taxonomy'] == 'ad_cat'):
        delete_term_meta($term_id,'icon');
        update_term_meta($term_id,'icon',$_POST['image_attachment_id']);
        update_term_meta($term_id,'related_post_cat',$_POST['related_post_cat']);
    endif;
}
function ad2app_wpse27856_set_content_type(){
    return "text/html";
}
add_filter( 'wp_mail_content_type','ad2app_wpse27856_set_content_type' );

require_once 'pages/config_ad2app_ajax.php';

//add_action( 'user_register', 'so27450945_user_register', 10, 1 );
function so27450945_user_register( $user_id ){

    $user = get_user_by( 'id', $user_id );
    $blogname = wp_specialchars_decode( get_option( 'blogname' ), ENT_QUOTES );

    $message  = sprintf( __( 'New user registration on your site %s:' ), $blogname ) . "\r\n\r\n";
    $message .= sprintf( __( 'Username: %s'), $user->user_login ) . "\r\n\r\n";
    $message .= sprintf( __( 'E-mail: %s'), $user->user_email ) . "\r\n";

    @wp_mail( get_option( 'admin_email' ), sprintf( __( '[%s] New User Registration' ), $blogname ), $message);
}