<?php
session_start();
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
wp_register_style( 'bootstrap', AD2APP_CSS_URL.'bootstrap.css'  );
wp_enqueue_style('bootstrap');
//wp_register_style( 'woo2app_style', AD2APP_CSS_URL.'woo2app_style.css'  );
//wp_enqueue_style( 'woo2app_style' );
?>
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/css/select2.min.css" rel="stylesheet" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/js/select2.min.js"></script>

<?php
function send_notif($description , $sound , $action , $value) {
	$app_id = get_option('app_id');
	$api_id = get_option('api_id');
	$content = array(
		"en" => $description
	);
	if($sound == 2){ //mute notifaction
		$fields = array(
			'app_id' => $app_id,
			'included_segments' => array('All'),
			'data' => array(
				"action" => $action,
				'value' => $value,
				'title' => get_option('blogname'),
				'alert' => get_option('blogname'),
				'time' => time()
			),
			'contents' =>  $content,
			'android_sound' => 'mute',
			'ios_sound' => 'mute.wav'
		);
	}
	else{
		$fields = array(
			'app_id' => $app_id,
			'included_segments' => array('All'),
			'data' => array(
				"action" => $action,
				'value' => $value,
				'title' =>  get_option('blogname'),
				'alert' => get_option('blogname'),
				'time' => time()),
			'contents' =>  $content,
		);
	}
	$fields = json_encode($fields);
	//return $app->wp->one_app_id;
	$ch1 = curl_init();
	curl_setopt($ch1, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
	curl_setopt($ch1, CURLOPT_HTTPHEADER, array('Content-Type: application/json',
		"Authorization: Basic  ". $api_id  ));
	curl_setopt($ch1, CURLOPT_RETURNTRANSFER, TRUE);
	curl_setopt($ch1, CURLOPT_HEADER, FALSE);
	curl_setopt($ch1, CURLOPT_POST, TRUE);
	curl_setopt($ch1, CURLOPT_POSTFIELDS, $fields);
	curl_setopt($ch1, CURLOPT_SSL_VERIFYPEER, FALSE);
	$response = curl_exec($ch1);
	curl_close($ch1);
	//var_dump($response);
	return $response;
}

function send_notif_mr2app($description , $sound , $action , $value){


	$email = get_option('email_WOO2APP');
	$pass = get_option('password_WOO2APP');
	$appid = get_option('appid_WOO2APP');
	if($sound == 1){
		$data = array(
			"sound" => 1,
			"title" => "",
			"description" => $_POST["txt_title"],
			"action" => $action,
			"value" => $value
		);
		$data = json_encode($data);
		$data = array(
			"data" => $data
		);
	}
    elseif($sound == 2){
		$data = array(
			"sound" => 2,
			"title" => "",
			"description" => $_POST["txt_title"],
			"action" => $action,
			"value" => $value
		);
		$data = json_encode($data);
		$data = array(
			"data" => $data
		);
	}


	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, "http://panel.wp2app.ir/panel/api/send_notification2all?email=$email&password=$pass&app_id=$appid");
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		"Content-Type:multipart/form-data"	));
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
	curl_setopt($ch, CURLOPT_POST, TRUE);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
	$response = curl_exec($ch);
	curl_close($ch);
	return $response;
}

if(isset($_POST['save_api'])){
	if($_POST['type'] == 'direct'){

		$notif_type = trim(update_option('notification_type',$_POST['type']));
		$app_id = trim(update_option('app_id',$_POST['app_id']));
		$api_id = trim(update_option('api_id' , $_POST['api_id']));
	}
    elseif($_POST['type'] == 'mr2app'){
		$notif_type = trim(update_option('notification_type',$_POST['type']));
		$email = trim(update_option('email_WOO2APP',$_POST['mr2app_username']));
		$pass = trim(update_option('password_WOO2APP' , $_POST['mr2app_password']));
		$app_id_2 = trim(update_option('appid_WOO2APP' , $_POST['mr2app_app_id']));
	}
}

$app_id = get_option('app_id');
$api_id = get_option('api_id');
$email = get_option('email_WOO2APP');
$pass = get_option('password_WOO2APP');
$app_id_2 = get_option('appid_WOO2APP');
$notif_type = get_option('notification_type');

if ( isset( $_POST['send_notif_wp2appir'] ) &&
     wp_verify_nonce( $_POST["send_notif_wp2appir"], 'wp2appir_send_notif' ) && current_user_can("update_plugins") ) {
    $action = 1;
    $value = $_POST["txt_link"];
	if($notif_type == 'direct'){
		$r = send_notif($_POST["txt_title"],$_POST["wp2app_voice"], 1 ,$value);
		$r = json_decode($r , true);
	}
	else{
		$r = send_notif_mr2app( $_POST["txt_title"],$_POST["wp2app_voice"], 1 ,$value);
		$r = json_decode($r , true);
	}
}

?>
<div class="wrap div_mainpage">
    <div class="col-md-8 pull-right" style="margin-top: 10px">
        <form method="POST">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h4 class="panel-title">
                        <a data-toggle="collapse" href="#collapse1">تنظیم روش ارسال</a>
                    </h4>
                </div>
                <div id="collapse1" class="panel-collapse collapse <?= (!get_option('notification_type')) ? 'in':''?>">
                    <div class="panel-body">
                        <input type="radio" name="type" value="direct" checked/>
                        ارسال مستقیم

                        <input type="radio" name="type" value="mr2app" <?= (get_option('notification_type') == 'mr2app') ? 'checked': ''?> />
                        ارسال از طریق مستر 2 اپ
                        <hr>
                        <div id="info_onesignal" class="<?= ($notif_type== 'direct' || $notif_type == '') ? '': 'hide'?>">
                            <div class="col-md-12 form-group">
                                <input name="app_id"  placeholder=" کلید اپ نوتیفیکیشن (درصفحه مشخصات اپ مشاهده کنید) " value="<?= $app_id;?>" class="form-control" type="text">
                            </div>
                            <div  class="col-md-12 form-group">
                                <input name="api_id" placeholder="  کلید api نوتیفیکیشن (درصفحه مشخصات اپ مشاهده کنید)  " value="<?= $api_id;?>" class="form-control" type="text">
                            </div>
                        </div>
                        <div id="info_mr2app" class="<?= ($notif_type == 'mr2app') ? '': 'hide'?>">
                            <div class="col-md-12 form-group">
                                <input name="mr2app_username"  placeholder=" ایمیل (ایمیلی که در مستر2اپ ثبت نام کرده اید) " value="<?= $email;?>" class="form-control" type="text">
                            </div>
                            <div class="col-md-12 form-group" >
                                <input name="mr2app_password" placeholder=" رمز عبور (رمزعبور مستر2اپ) " value="<?= $pass;?>" class="form-control" type="text">
                            </div>
                            <div class="col-md-12 form-group" >
                                <input name="mr2app_app_id" placeholder=" کلید اپ ( عدد 7 رقمی که در لیست اپ های من مشاهده کنید) " value="<?= $app_id_2;?>" class="form-control" type="text">
                            </div>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                    <div class="panel-footer text-left">
                        <button type="submit" name="save_api" class="button button-primary">
                            ذخیره
                        </button>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <div class="col-md-8 pull-right" >
        <div class="panel panel-default">
            <div class="panel-heading">
                ارسال نوتیفیکیشن
            </div>
            <form method="POST">
				<?php wp_nonce_field('wp2appir_send_notif' , 'send_notif_wp2appir'); ?>
                <div class="panel-body">
					<?php
					if(isset($r['recipients'])){
						?>
                        <span style="color:green">
					نوتیفیکیشن برای
                            <?= $r['recipients']; ?>
                            نفر ارسال شد.
				</span>
                        <div class="clearfix"></div>
                        <hr>
						<?php
					}
					?>
                    <div class="col-md-12">
                        <div class="col-md-6 pill-right">
                            <p>
                                <input checked="" type="radio" class="form-control" value="2" name="wp2app_voice" id="wp2app_silent">
                                <span>بی صدا</span>
                            </p>
                        </div>
                        <div class="col-md-6 pill-right">
                            <p>
                                <input checked="" type="radio" class="form-control" value="1" name="wp2app_voice" id="wp2app_voice">
                                <span>با صدا</span>
                            </p>
                        </div>
                    </div>
                    <div class="col-md-12" style="margin-bottom : 10px;">
                        <div class="col-md-10" style="padding:0px; ">
                            <textarea name="txt_title" class="form-control text-right"></textarea>
                        </div>
                        <div class="col-md-2 text-right" style="padding:0px;">
                            عنوان پیام :
                        </div>
                    </div>

                    <div id="link_notif_hami" class="col-md-12 " style="margin-bottom : 10px;">
                        <div class="col-md-10" style="padding:0px;">
                            <input type="text" name="txt_link" class="form-control text-left " style="direction:ltr;" placeholder="[http || https] :// mysite.ir">
                            <p>
                                در هنگام قرار دادن لینک حتما مقدار وارد شده را با http یا https وارد نمایید.
                            </p>
                        </div>
                        <div class="col-md-2 text-right" style="padding:0px;">
                            لینک پیام :
                        </div>
                    </div>
                    <div class="col-md-12" style="margin-top:10px;padding:0px;">
                        <div class="col-md-6 text-left">

                        </div>
                        <div class="col-md-6"></div>
                    </div>

                </div>
                <div class="panel-footer text-left">
                    <button type="submit" class="button button-primary">
                        ارسال پیام
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php
wp_enqueue_script( 'notification_hami.js' , AD2APP_JS_URL.'notification_hami.js', array('jquery'));
wp_enqueue_script( 'bootstrap.min.js' , AD2APP_JS_URL.'bootstrap.min.js', array('jquery'));
wp_enqueue_script( 'loadajax.js' , AD2APP_JS_URL.'loadAjaxPosts.js', array('jquery'));
?>
<script>
    jQuery('input[type=radio][name=type]').change(function() {
        if (this.value == 'direct') {
            jQuery("#info_onesignal").removeClass('hide')
            jQuery("#info_mr2app").addClass('hide')
        }
        else if (this.value == 'mr2app') {
            jQuery("#info_mr2app").removeClass('hide')
            jQuery("#info_onesignal").addClass('hide')
        }
    });
</script>
