<?php

if(!class_exists('WP_List_Table')){
	require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
}
class TT_Example_List_Table_ad2app extends WP_List_Table {

	var $data = array();

	function __construct(){
		global $status, $page;

		//Set parent defaults
		parent::__construct( array(
			'singular'  => 'ad2app_report',     //singular name of the listed records
			'plural'    => 'ad2app_reports',    //plural name of the listed records
			'ajax'      => false        //does this table support ajax?
		) );

	}

	function column_default($item, $column_name){
		switch($column_name){
			case 'title':
				return $item[$column_name];
			case 'content':
				return $item[$column_name];
			case 'ID':
				return $item[$column_name];
			case 'ad_id':
				return $this->show_button($item[$column_name]);
			case 'post_date':
				return function_exists('jdate') ? jdate('l, j F , Y , H:i:s',$item[$column_name]) : $item[$column_name];
			default:
				return print_r($item,true); //Show the whole array for troubleshooting purposes
		}
	}

	function show_button($ad_id){
	    return get_post( $ad_id )? edit_post_link('مشاهده آگهی','','',$ad_id,'') : 'آگهی پاک شده است. ';
    }
	function column_title($item){

		//Build row actions
		$actions = array(
			'delete'    => sprintf('<a  href="?page=%s&action=%s&post_id=%s">حذف</a>',$_REQUEST['page'],'delete',$item['ID']),
		);

		//Return the title contents
		return sprintf('%1$s %2$s',
			/*$1%s*/ $item['title'],
			/*$2%s*/ $this->row_actions($actions)
		);
	}


	function get_bulk_actions() {
		$actions = array(
			'delete'    => 'حذف'
		);
		//return $actions;
	}

	public function search_box( $text, $input_id ) {
		if ( empty( $_REQUEST['s'] ) && !$this->has_items() )
			return;

		$input_id = $input_id . '-search-input';

		if ( ! empty( $_REQUEST['orderby'] ) )
			echo '<input type="hidden" name="orderby" value="' . esc_attr( $_REQUEST['orderby'] ) . '" />';
		if ( ! empty( $_REQUEST['order'] ) )
			echo '<input type="hidden" name="order" value="' . esc_attr( $_REQUEST['order'] ) . '" />';
		if ( ! empty( $_REQUEST['post_mime_type'] ) )
			echo '<input type="hidden" name="post_mime_type" value="' . esc_attr( $_REQUEST['post_mime_type'] ) . '" />';
		if ( ! empty( $_REQUEST['detached'] ) )
			echo '<input type="hidden" name="detached" value="' . esc_attr( $_REQUEST['detached'] ) . '" />';
		?>
		<p class="search-box">
			<label class="screen-reader-text" for="<?php echo esc_attr( $input_id ); ?>"><?php echo $text; ?>:</label>
			<input type="search" id="<?php echo esc_attr( $input_id ); ?>" name="s" value="<?php _admin_search_query(); ?>" />
			<?php submit_button( $text, '', '', false, array( 'id' => 'search-submit' ) ); ?>
		</p>
		<?php
	}

	function process_bulk_action() {
		//Detect when a bulk action is being triggered...
		if( 'delete' === $this->current_action() ) {
			if(isset($_POST['delete_submit'])){
				$post_id = $_POST['post_id'];
				wp_delete_post($post_id);
				delete_post_meta($post_id,'ad_id');
				?>
				<p>
					رکورد حذف شد.
				</p>
				<a href="<?= admin_url().'admin.php?page=ad2app/pages/report.php' ?>" class="button button-primary" > بازگشت</a>
				<?php
			}
			else{
				$post = get_post($_GET['post_id']);
				?>
                <br>
                <p>
                    <strong> عنوان : </strong>
                    <span> <?= $post->post_title;?></span>
                </p>
                <p>
                    <strong> محتوا : </strong>
                    <span> <?= $post->post_content;?></span>
                </p>
                <p>
                    <strong> تاریخ ثبت : </strong>
                    <span> <?= function_exists('jdate') ?  jdate('l, j F , Y , H:i:s',$post->post_date) : $post->post_date;?></span>
                </p>
                <p>
                <form method="post">
                    <input type="hidden" name="post_id" value="<?= $post->ID?>">
                    <input name="delete_submit" id="submit" class="button button-primary" value="پاک شود" type="submit">
                </form>
                </p>
				<?php
			}
			exit();
		}
	}

	function get_columns(){
		$columns = array(
			//'num'        => '#', //Render a checkbox instead of text
			'title'     => ' عنوان',
			'content'    => 'محتوا',
			'post_date'  => 'تاریخ ثبت',
			'ad_id'  => '---------',
		);
		return $columns;
	}

	function get_sortable_columns() {
		$sortable_columns = array(
			'title'     => array('title',false),     //true means it's already sorted
			'content'    => array('content',false),
			'post_date'  => array('post_date',false),
		);
		return $sortable_columns;
	}

	function get_data(){
		$args = array(
			's' => isset($_REQUEST['s']) ? $_REQUEST['s'] : '',
			'post_type'   => 'ad2app_report',
			'post_status' => 'draft',
			//'posts_per_page' => -1,
		);
		$the_query = get_posts( $args );
		$i = 0;
		$array = array();
		foreach ($the_query as $p){
			$i++;
			$array[] = array(
				'num' => $i,
				'ID' => $p->ID,
				'title' => $p->post_title,
				'content' => $p->post_content,
				'post_date' => $p->post_date,
				'ad_id' => get_post_meta($p->ID , 'ad_id' , true),
			);
		}
		return $array;
	}

	function prepare_items() {
		global $wpdb; //This is used only if making any database queries

		$per_page = 10;

		$columns = $this->get_columns();
		$hidden = array();
		$sortable = $this->get_sortable_columns();

		$this->_column_headers = array($columns, $hidden, $sortable);

		$this->process_bulk_action();
		$data = $this->get_data();

		function usort_reorder($a,$b){
			$orderby = (!empty($_REQUEST['orderby'])) ? $_REQUEST['orderby'] : 'post_date'; //If no sort, default to title
			$order = (!empty($_REQUEST['order'])) ? $_REQUEST['order'] : 'desc'; //If no order, default to asc
			$result = strcmp($a[$orderby], $b[$orderby]); //Determine sort order
			return ($order==='asc') ? $result : -$result; //Send final sort direction to usort
		}
		usort($data, 'usort_reorder');



		$current_page = $this->get_pagenum();

		$total_items = count($data);



		$data = array_slice($data,(($current_page-1)*$per_page),$per_page);




		$this->items = $data;


		/**
		 * REQUIRED. We also have to register our pagination options & calculations.
		 */
		$this->set_pagination_args( array(
			'total_items' => $total_items,                  //WE have to calculate the total number of items
			'per_page'    => $per_page,                     //WE have to determine how many items to show on a page
			'total_pages' => ceil($total_items/$per_page)   //WE have to calculate the total number of pages
		) );
	}

	function delete_sale_post($post_id){
		echo  $post_id;
		return;
	}

}
$ListTable = new TT_Example_List_Table_ad2app();
$ListTable->prepare_items();

?>
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/css/select2.min.css" rel="stylesheet" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/js/select2.min.js"></script>

<div class="wrap">
	<h2>  لیست گزارشات خطا </h2>
	<form id="movies-filter" method="get">
		<input type="hidden" name="page" value="<?php echo $_REQUEST['page'] ?>" />
		<?php $ListTable->search_box('search', 'search_id');?>

		<?php $ListTable->display() ?>
	</form>
</div>
