<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class WOO2APP_REST_Controller extends WP_REST_Controller {

	/**
	 * Endpoint namespace.
	 *
	 * @var string
	 */
	protected $namespace = 'mr2app/api/v';
	protected $version = '2';

	public function register_routes() {
		$rest_base = $this->namespace . $this->version;
		register_rest_route( $rest_base, '/' . $this->rest_base . '/post_order',
			array(
				'methods'             => WP_REST_Server::CREATABLE,
				'callback'            => array( $this, 'post_order' ),
				'permission_callback' => array( $this, 'permissions_check' ),
			)
		);
		register_rest_route( $rest_base, '/' . $this->rest_base . '/get_order',
			array(
				'methods'             => WP_REST_Server::CREATABLE,
				'callback'            => array( $this, 'get_order' ),
				'permission_callback' => array( $this, 'permissions_check' ),
			)
		);
		register_rest_route( $rest_base, '/' . $this->rest_base . '/reviews',
			array(
				'methods'             => WP_REST_Server::CREATABLE,
				'callback'            => array( $this, 'create_reviews' ),
				'permission_callback' => array( $this, 'permissions_check' ),
			)
		);
		register_rest_route( $rest_base, '/' . $this->rest_base . '/reviews',
			array(
				'methods'             => WP_REST_Server::READABLE,
				'callback'            => array( $this, 'get_reviews' ),
				'permission_callback' => array( $this, 'permissions_check' ),
			)
		);
		register_rest_route( $rest_base, '/' . $this->rest_base . '/register',
			array(
				'methods'             => WP_REST_Server::CREATABLE,
				'callback'            => array( $this, 'register' ),
				'permission_callback' => array( $this, 'permissions_check' ),
			)
		);
		register_rest_route( $rest_base, '/' . $this->rest_base . '/user_edit',
			array(
				'methods'             => WP_REST_Server::EDITABLE,
				'callback'            => array( $this, 'user_edit' ),
				'permission_callback' => array( $this, 'permissions_check' ),
			)
		);
		register_rest_route( $rest_base, '/' . $this->rest_base . '/login',
			array(
				'methods'             => WP_REST_Server::READABLE,
				'callback'            => array( $this, 'login' ),
				'permission_callback' => array( $this, 'permissions_check' ),
			)
		);
		register_rest_route( $rest_base, '/' . $this->rest_base . '/forget',
			array(
				'methods'             => WP_REST_Server::READABLE,
				'callback'            => array( $this, 'forget' ),
				'permission_callback' => array( $this, 'permissions_check' ),
			)
		);
		register_rest_route( $rest_base, '/' . $this->rest_base . '/coupon',
			array(
				'methods'             => WP_REST_Server::CREATABLE,
				'callback'            => array( $this, 'coupon' ),
				'permission_callback' => array( $this, 'permissions_check' ),
			)
		);
		register_rest_route( $rest_base, '/' . $this->rest_base . '/login_m',
			array(
				'methods'             => WP_REST_Server::CREATABLE,
				'callback'            => array( $this, 'login_m' ),
				'permission_callback' => array( $this, 'permissions_check' ),
			)
		);
		register_rest_route( $rest_base, '/' . $this->rest_base . '/register_m',
			array(
				'methods'             => WP_REST_Server::CREATABLE,
				'callback'            => array( $this, 'register_m' ),
				'permission_callback' => array( $this, 'permissions_check' ),
			)
		);
		register_rest_route( $rest_base, '/' . $this->rest_base . '/forget_m',
			array(
				'methods'             => WP_REST_Server::READABLE,
				'callback'            => array( $this, 'forget_m' ),
				'permission_callback' => array( $this, 'permissions_check' ),
			)
		);
		register_rest_route( $rest_base, '/' . $this->rest_base . '/verify_m',
			array(
				'methods'             => WP_REST_Server::CREATABLE,
				'callback'            => array( $this, 'verify_m' ),
				'permission_callback' => array( $this, 'permissions_check' ),
			)
		);
		register_rest_route( $rest_base, '/' . $this->rest_base . '/user_edit_m',
			array(
				'methods'             => WP_REST_Server::CREATABLE,
				'callback'            => array( $this, 'user_edit_m' ),
				'permission_callback' => array( $this, 'permissions_check' ),
			)
		);
		register_rest_route( $rest_base, '/' . $this->rest_base . '/make_icode',
			array(
				'methods'             => WP_REST_Server::CREATABLE,
				'callback'            => array( $this, 'make_icode' ),
				'permission_callback' => array( $this, 'permissions_check' ),
			)
		);
		register_rest_route( $rest_base, '/' . $this->rest_base . '/apply_icode',
			array(
				'methods'             => WP_REST_Server::CREATABLE,
				'callback'            => array( $this, 'apply_icode' ),
				'permission_callback' => array( $this, 'permissions_check' ),
			)
		);
		register_rest_route( $rest_base, '/' . $this->rest_base . '/get_icode',
			array(
				'methods'             => WP_REST_Server::CREATABLE,
				'callback'            => array( $this, 'get_icode' ),
				'permission_callback' => array( $this, 'permissions_check' ),
			)
		);
		register_rest_route( $rest_base, '/' . $this->rest_base . '/GetVendors',
			array(
				'methods'             => WP_REST_Server::READABLE,
				'callback'            => array( $this, 'GetVendors' ),
				'permission_callback' => array( $this, 'permissions_check' ),
			)
		);
		register_rest_route( $rest_base, '/' . $this->rest_base . '/GetStoreRating',
			array(
				'methods'             => WP_REST_Server::CREATABLE,
				'callback'            => array( $this, 'GetStoreRating' ),
				'permission_callback' => array( $this, 'permissions_check' ),
			)
		);
		register_rest_route( $rest_base, '/' . $this->rest_base . '/GetStoreReview',
			array(
				'methods'             => WP_REST_Server::READABLE,
				'callback'            => array( $this, 'GetStoreReview' ),
				'permission_callback' => array( $this, 'permissions_check' ),
			)
		);
		register_rest_route( $rest_base, '/' . $this->rest_base . '/SubmitReview',
			array(
				'methods'             => WP_REST_Server::CREATABLE,
				'callback'            => array( $this, 'SubmitReview' ),
				'permission_callback' => array( $this, 'permissions_check' ),
			)
		);
	}

	public function post_order() {
		//get parameters from request
		$order = new woo2app_core_api_orders();
		$data = $order->woo2app_POST_order( $return = 1);
		return new WP_REST_Response( $data ,200);
	}
	public function get_order() {
		//get parameters from request
		$order = new woo2app_core_api_orders();
		$data = $order->woo2app_GET_order( $return = 1);
		return new WP_REST_Response( $data ,200);
	}
	public function get_reviews(){
		include_once( WOO2APP_PATH . 'api/woo2app_Reviews.php' );
		$review = new Reviews();
		$data = $review->get_reviews();
		return new WP_REST_Response( $data ,200);
	}
	public function create_reviews(){
		include_once( WOO2APP_PATH . 'api/woo2app_Reviews.php' );
		$review = new Reviews();
		$data = $review->create_reviews();
		return new WP_REST_Response( $data ,200);
	}
	public function register(){
		$register = new woo2app_core_api_customers();
		$data = $register->woo2app_POST_customer();
		return new WP_REST_Response( $data ,200);
	}
	public function user_edit(){
		$register = new woo2app_core_api_customers();
		$data = $register->woo2app_PUT_customer();
		return new WP_REST_Response( $data ,200);
	}
	public function login(){
		$register = new woo2app_core_api_customers();
		$data = $register->woo2app_GET_login();
		return new WP_REST_Response( $data ,200);
	}
	public function forget(){
		$register = new api_webservices_hami_user();
		$data = $register->hami_forget_webservice($return = true);
		return new WP_REST_Response( $data ,200);
	}
	public function coupon(){
		$register = new woo2app_core_api_coupon();
		$data = $register->woo2app_coupon();
		return new WP_REST_Response( $data ,200);
	}
	public function login_m(){
		global  $class_custom_register_woo2app;
		$data = $class_custom_register_woo2app->login_register_form($return = true);
		return new WP_REST_Response( $data ,200);
	}
	public function verify_m(){
		global  $class_custom_register_woo2app;
		$data = $class_custom_register_woo2app->send_sms($return = true);
		return new WP_REST_Response( $data ,200);
	}
	public function forget_m(){
		global  $class_custom_register_woo2app;
		$data = $class_custom_register_woo2app->generate_password($return = true);
		return new WP_REST_Response( $data ,200);
	}
	public function register_m(){
		global  $class_custom_register_woo2app;
		$data = $class_custom_register_woo2app->register($return = true);
		return new WP_REST_Response( $data ,200);
	}
	public function user_edit_m(){
		global  $class_custom_register_woo2app;
		$data = $class_custom_register_woo2app->user_edit($return = true);
		return new WP_REST_Response( $data ,200);
	}
	public function make_icode(){
		include_once( WOO2APP_PATH . 'api/woo2app_Inviter.php' );
		$inviter = new woo2app_Inviter();
		$data = $inviter->make_icode($return = true);
		return new WP_REST_Response( $data ,200);
	}
	public function apply_icode(){
		include_once( WOO2APP_PATH . 'api/woo2app_Inviter.php' );
		$inviter = new woo2app_Inviter();
		$data = $inviter->apply_icode($return = true);
		return new WP_REST_Response( $data ,200);
	}
	public function get_icode(){
		include_once( WOO2APP_PATH . 'api/woo2app_Inviter.php' );
		$inviter = new woo2app_Inviter();
		$data = $inviter->get_icode($return = true);
		return new WP_REST_Response( $data ,200);
	}
	public function GetVendors(){
		global  $woo2app_vendors;
		$data = $woo2app_vendors->GetSeller($return = true);
		return new WP_REST_Response( $data ,200);
	}
	public function GetStoreRating(){
		global  $woo2app_vendors;
		$data = $woo2app_vendors->replace_rating_value(0 , $_GET['store_id']);
		return new WP_REST_Response( $data ,200);
	}
	public function GetStoreReview(){
		global  $woo2app_vendors;
		$data = $woo2app_vendors->replace_ratings_list( 0 ,$_GET['store_id'] , true);
		return new WP_REST_Response( $data ,200);
	}
	public function SubmitReview(){
		global  $woo2app_vendors;
		$woo2app_vendors->SubmitReview();
		//return new WP_REST_Response( $data ,200);
	}

	public function permissions_check( $request ) {
		return apply_filters( 'woo2app_rest_check_permissions',  woo2app_permissions_check() , $request );
	}

}
$rest_controller = new WOO2APP_REST_Controller();
$rest_controller->register_routes();
function woo2app_permissions_check(){
	include_once( WOO2APP_PATH . 'api/woo2app_authentication.php' );
	$auth = new woo2app_authentication();
	return $auth->check_oauth_signature();
}
