<?php
/**
 * Created by PhpStorm.
 * User: Hani
 * Date: 3/27/2019
 * Time: 11:51 AM
 */

class woo2app_Inviter {

	public function make_icode($return = false) {
		header('Content-Type: application/json; charset=utf-8');
		$result = array(
			'status' => false,
			'code' => -1,
			'msg' => 'Service encountered an error.'
		);
		if(isset($_POST['in'])) {
			$result = array(
				'status' => false,
				'code' => -2,
				'msg' => 'User does not have this information.'
			);
			$in = $_POST['in'];
			$slashless = stripcslashes($in);
			$url_json = urldecode($slashless);
			$json = (array) json_decode($url_json);
			$user = get_user_by('id' , $json['uid']);
			if($user){
				$result = array(
					'status' => false,
					'code' => -3,
					'msg' => 'Reagent code already exists.',
					'invite_code' => get_user_meta($user->ID , 'my_invitecode' , true)
				);
				$meta_invite_code = get_user_meta($user->ID,'my_invitecode',true);
				if(!$meta_invite_code){
					$code = $this->make_code($user->user_login);
					update_user_meta($user->ID,'my_invitecode' , $code);
					$result = array(
						'status' => true,
						'code' => 1,
						'msg' => 'The code was created successfully.'
					);
				}
			}
		}
		if ($return) return $result;
		echo json_encode($result);
	}

	public function make_code($username){
		$code = '';
		$setting_inviter  = get_option('woo2app_inviter_setting');
		$type_code = $setting_inviter['type_make_code'];
		if($type_code == 'username') $code = $username;
		if($type_code == 'random_digit') {
			$code = rand(1000000,9999999);
			if($this->check_code($code)){
				$this->make_code($username);
			}
		}
		if($type_code == 'random_alphabet') {
			$code = $this->generateRandomString(7);
			if($this->check_code($code)){
				$this->make_code($username);
			}
		}

		return $code;
	}
	public function generateRandomString($length = 10) {
		$characters = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
		$charactersLength = strlen($characters);
		$randomString = '';
		for ($i = 0; $i < $length; $i++) {
			$randomString .= $characters[rand(0, $charactersLength - 1)];
		}
		return $randomString;
	}
	protected function check_code($meta_value){
		$user_query = new WP_User_Query(
			array(
				'meta_key'	  =>	'my_invitecode',
				'meta_value'	=>	$meta_value
			)
		);

		// Get the results from the query, returning the first user
		$users = $user_query->get_results();

		return $users[0];
	}

	public function apply_icode($return = false){
		header('Content-Type: application/json; charset=utf-8');
		$result = array(
			'status' => false,
			'code' => -1,
			'msg' => 'Service encountered an error.'
		);
		if(isset($_POST['in'])) {
			$in = $_POST['in'];
			$slashless = stripcslashes($in);
			$url_json = urldecode($slashless);
			$json = (array) json_decode($url_json);
			$password = $json['password'] ? $json['password'] : $json['ramz'];
			$result = array(
				'status' => false,
				'code' => -5,
				'msg' => 'The code does not exist.'
			);
			if( $invitor = $this->check_code($json['invitor']) && $json['invitor'] != ""){

				$result = array(
					'status' => false,
					'code' => -2,
					'msg' => 'User does not have this information.'
				);
				$user = get_user_by('login' , $json['username']);
				if($user){
					$result = array(
						'status' => false,
						'code' => -3,
						'msg' => 'The password is incorrect.'
					);
					$pass = wp_check_password( $password , $user->data->user_pass, $user->ID );
					if($pass){
						$result = array(
							'status' => false,
							'code' => -4,
							'msg' => 'The tag code has already been saved.'
						);
						$check = get_user_meta($user->ID , 'my_invitor',true);
						if(!$check){

							update_user_meta($user->ID , 'my_invitor' , $json['invitor']);
							$this->set_score_invitor($json['invitor']  , $user->user_login);
							$result = array(
								'status' => true,
								'code' => 1,
								'msg' => 'The code was registered.'
							);
						}
					}
				}
			}
		}
		if ($return) return $result;
		echo json_encode($result);
	}

	private function set_score_invitor($invitor , $user_login) {
		$user            = $this->check_code( $invitor );
		$setting_inviter = get_option( 'woo2app_inviter_setting' );
		$counter         = $setting_inviter['score_for_inviter_register_value'];
		$type            = $setting_inviter['score_type'];
		if ( $type == 1 ) {
			$score = get_user_meta( $user->ID, 'my_score', true );
			$score = (int) $score + (int) $counter;
			update_user_meta( $user->ID, 'my_score', $score );
		} else if ( $type == 2 ) {
			include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
			if ( is_plugin_active( 'woo-wallet/woo-wallet.php' ) ) {
				//plugin is activated
				woo_wallet()->wallet->credit( $user->ID, (int) $counter, ' Gift Charge for Reagent Code:' . $user_login );
			}
		}
	}

	public function get_icode($return = false){
		header('Content-Type: application/json; charset=utf-8');
		$result = array(
			'status' => false,
			'code' => -1,
			'msg' => 'Service encountered an error.'
		);
		if(isset($_POST['in'])) {
			$result = array(
				'status' => false,
				'code' => -2,
				'msg' => 'User does not have this information.'
			);
			$in = $_POST['in'];
			$slashless = stripcslashes($in);
			$url_json = urldecode($slashless);
			$json = (array) json_decode($url_json);
			$user = get_user_by('id' , $json['uid']);
			if($user){
				$my_invitecode = get_user_meta($user->ID,'my_invitecode',true);
				if($my_invitecode == "" || $my_invitecode == null){
					$my_invitecode =  $this->make_code($user->user_login);
					update_user_meta($user->ID,'my_invitecode' , $my_invitecode);
				}
				$my_score = get_user_meta($user->ID,'my_score',true);
				$result = array(
					'status' => true,
					'code' => 1,
					'my_invitecode' => $my_invitecode,
					'my_score' => (int)$my_score
				);
			}
		}
		if ($return) return $result;
		echo json_encode($result);
	}

}