<?php
if ( ! class_exists('WP_List_Table')) {
	require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
}
define('current_url', admin_url().'admin.php?page=woo2app/feedback/feedback.php');

if(isset($_GET['action']) && $_GET['action'] == 'view'){
	require_once 'show.php';
}
elseif(isset($_GET['action']) && $_GET['action'] == 'remove') {
	if($_GET['id']){
		$id = $_GET['id'];
		if(wp_delete_post($id)){
			?>
            <p> <?= _e('The case was deleted correctly.' , 'woo2app'); ?> </p>
            <?php
		}
		else{
			?>
            <p> <?= _e('Record are not deleted' , 'woo2app'); ?> </p>
            <?php
		}
	}
	else{
		?>
        <p> <?= _e('Record are not deleted' , 'woo2app'); ?> </p>
		<?php
	}
	?>
    <a class="button button-primary" href="<?= current_url?>">
        <?php _e('Back' , 'woo2app');?>
    </a>
	<?php
}
else{
	class Events_List_Table extends WP_List_Table
	{
		function __construct()
		{
			parent::__construct(array(
				'singular'  => 'wp_list_event',
				'plural'    => 'wp_list_events',
				'ajax'      => false
			));
		}

		public $request = array();
		public $sql = "";
		public $role = "";
		function column_default($item, $column_name)
		{
			switch($column_name) {
				case 'ID':
					return $item['ID'];
					break;
				case 'username':
					return $item['post_title'];
					break;
				case 'msg':
					return $this->limit_text($item['post_content'] , 150);
					break;
				case 'rate':
				case 'app-version':
				case 'os-version':
				case 'install-id':
					return get_post_meta($item["ID"] , $column_name , true);
					break;
				case 'action':
					return $this->action($item["ID"]);
					break;
				default:
					return print_r($item,true);
			}
		}

		function  action($id){
			?>
            <a   href="<?= current_url.'&action=view&id='.$id;?>" class="button button-default"> <?php _e('Show' , 'woo2app');?> </a>
            <a   href="<?= current_url.'&action=remove&id='.$id;?>"  onclick="return confirm('<?php _e('Are you sure you want to delete the list?' , 'woo2app'); ?>')" class="button button-warning"> <?php _e('Remove' , 'woo2app');?> </a>
			<?php
		}

		function column_date($date)
		{
			return jdate('l, j F , Y , H:i:s',$date);
		}


		public function limit_text($text, $limit) {
		    //return str_word_count($text, 0);
			if (str_word_count($text, 0) > $limit) {
			    //return 1;
				$words = str_word_count($text, 2);
				$pos   = array_keys($words);
				$text  = substr($text, 0, 150) . '...';
				return $text;
			}
			return $text;
		}

		function get_columns()
		{
			$columns = array(
				'ID'         => __('number' , 'woo2app'),
				'username'         => __('Username' , 'woo2app'),
				'msg'         => __('Message' , 'woo2app'),
				'rate'    => __('Rate' , 'woo2app'),
				'app-version'    => __('App Version' , 'woo2app'),
				'os-version'        => __('Os Version' , 'woo2app'),
				'install-id'        => __( 'Install Id', 'woo2app' ),
				'action'        => __('Action' , 'woo2app'),
			);
//			$columns = array(
//				'ID'         => _e('Number' , 'woo2app'),
//				'username'         =>  _e('Username' , 'woo2app'),
//				'msg'         =>   _e('Message' , 'woo2app'),
//				'rate'    =>   _e('Rate' , 'woo2app'),
//				'app-version'    =>  _e('App Version' , 'woo2app'),
//				'os-version'        =>  _e('Os Version' , 'woo2app'),
//				'install-id'        =>  _e('Install Id' , 'woo2app'),
//				'action'        =>   _e('Action' , 'woo2app'),
//			);

			return $columns;
		}

		function prepare_items()
		{
			global $wpdb;

			$table_name = $wpdb->prefix . 'posts';
			$tbl_postmeta = $wpdb->prefix .'postmeta';
			$per_page = 20;
			$columns = $this->get_columns();
			$hidden = array();
			$sortable = $this->get_sortable_columns();

			$this->_column_headers = array($columns, $hidden, $sortable);


			$paged = isset($_REQUEST['paged']) ? max(0, intval($_REQUEST['paged']) - 1) : 0;
			$paged = $paged * $per_page;
			$orderby = (isset($_REQUEST['orderby']) && in_array($_REQUEST['orderby'], array_keys($this->get_sortable_columns()))) ? $_REQUEST['orderby'] : 'ID';
			$order = (isset($_REQUEST['order']) && in_array($_REQUEST['order'], array('asc', 'desc'))) ? $_REQUEST['order'] : 'desc';



			$total_items = $wpdb->get_var("SELECT COUNT(ID) FROM $table_name 
            WHERE $table_name.post_type = 'app-feedback' ");

			$sql = $wpdb->prepare("SELECT * FROM $table_name 
            WHERE $table_name.post_type = 'app-feedback'  
                        ORDER BY $orderby $order LIMIT %d OFFSET %d", $per_page, $paged);


			$this->items = $wpdb->get_results(
				$sql, ARRAY_A);

			$this->set_pagination_args(array(
				'total_items'   => $total_items,
				'per_page'      => $per_page,
				'total_pages'   => ceil($total_items / $per_page),
			));
		}

	}

	$ListTable = new Events_List_Table();
	$ListTable->prepare_items();
	?>


    <div class="wrap">

        <h2>
            <?php _e('Feedback' , 'woo2app'); ?>
        </h2>

        <form id="movies-filter" method="get">
            <input type="hidden" name="page" value="<?php echo $_REQUEST['page'] ?>" />

			<?php $ListTable->display() ?>
        </form>
    </div>
	<?php
}