<?php
/**
 * Created by mr2app.
 * User: hani
 * Date: 12/13/17
 * Time: 6:10 PM
 */

wp_register_style( 'woo2app_style', WOO2APP_CSS_URL.'woo2app_style.css'  );
wp_enqueue_style( 'woo2app_style'.WOO2APP_FILES_VER );
if(get_locale() == 'fa_IR'){
	wp_register_style('myfont', WOO2APP_CSS_URL . 'font.css');
	wp_enqueue_style( 'myfont'.WOO2APP_FILES_VER);
}

if (!defined( 'ABSPATH' )) exit;
$current_url = "//" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
if(isset($_REQUEST['sort'])){
    if(is_array($_POST['ids'])) {
	    $ids = $_POST['ids'];
	    $i   = 0;
	    $i = 0;
	    foreach ( $ids as $id ) {
		    $i ++;
		    $array = array(
			    'ID'         => $id,
			    'menu_order' => $i,
		    );
		    wp_update_post( $array );
	    }
    }
}
if(isset($_GET['action'])){
	require_once "new_field.php";
}
else {
	if ( isset( $_REQUEST["submit_delete"] ) ) {
		$post_id = ($_POST['delete_id']);
		if ( wp_delete_post( $post_id ) ) {
			?>
            <div class="notice notice-success is-dismissible">
                <p><?php _e('The case was deleted correctly.', 'woo2app'); ?></p>
            </div>
			<?php
		} else {
			?>
            <div class="notice notice-danger is-dismissible">
                <p><?php _e('Sorry, we encountered a problem. Please try again.', 'woo2app'); ?></p>
            </div>
			<?php
		}
	}
	?>
    <div class="wrap">
        <h1> <?php _e('Registration Fields', 'woo2app'); ?>
            <a class="add-new-h2" href="<?= $current_url . '&action=new' ?>"><?php _e('New', 'woo2app'); ?></a>
        </h1>
        <div id="col-container" class="">
            <div>
                <div class="col-wrap ">
                    <form name="form_sort" id="form_sort" method="post" action="">
                        <?php wp_nonce_field('woo2app-admin', 'woo2app-admin'); ?>
                        <table class="wp-list-table widefat fixed striped tags ui-sortable ">
                            <thead>
                            <tr>
                                <th scope="col" id='name' class='manage-column column-name'>
                                    <span> <?php _e('Title', 'woo2app'); ?> </span>
                                </th>
                                <th scope="col" id='name' class='manage-column column-name'>
                                    <span> <?php _e('Name', 'woo2app'); ?> </span>
                                </th>
                                <th scope="col" style="width: 70px" id='name' class='manage-column column-name'>
                                    <span style="cursor: pointer"> <?php _e('Required', 'woo2app'); ?> </span>
                                </th>
                                <th scope="col" style="width: 70px" id='name' class='manage-column column-name'>
                                    <span style="cursor: pointer"> <?php _e('Active', 'woo2app'); ?>  </span>
                                </th>
                                <th scope="col" style="width: 70px" id='name' class='manage-column column-name'>
                                    <span style="cursor: pointer"> <?php _e('Show in register', 'woo2app'); ?>  </span>
                                </th>
                                <th scope="col" style="width: 70px" id='name' class='manage-column column-name'>
                                    <span style="cursor: pointer"> <?php _e('Show in edit ', 'woo2app'); ?> </span>
                                </th>
                                <th scope="col" id='name' class='manage-column column-name'>
                                    <span style="cursor: pointer"> <?php _e('Edit / Delete', 'woo2app'); ?> </span>
                                </th>
                            </tr>
                            </thead>
                            <tbody id="sortable">
							<?php
							$args      = array(
								'post_type'   => 'woo2app_register',
								'post_status' => 'draft',
								'posts_per_page' => -1,
								'orderby' => 'menu_order',
								'order' => 'ASC'
							);
							$the_query = get_posts( $args );
							$default_fields  = array( 'user_login'  , 'user_email' , 'user_pass','user_url' ,  'display_name' ,
								'first_name' , 'last_name' , 'description' , 'billing_first_name' , 'billing_last_name','billing_company','billing_address_1',
								'billing_address_2','billing_city','billing_state','billing_postcode','billing_country','billing_email','billing_phone');
							//var_dump($default_fields);
							foreach ( $the_query as $value ) {
								?>
                                <tr  id="tag-<?= $value->ID; ?>" style="cursor: move" class="<?= 'tag-' . $value->ID; ?>">
                                    <input type="hidden" name="ids[]" value="<?= $value->ID; ?>">
                                    <form action="" onsubmit="return confirm('Are You Sure ?');"
                                          method="post" id="form_<?= $value->ID ?>">
                                        <?php wp_nonce_field('woo2app-admin', 'woo2app-admin'); ?>
                                        <input type="hidden" name="delete_id" value="<?= $value->ID; ?>">
                                        <td class='name column-name has-row-actions column-primary' data-colname="Name">
                                            <p>
                                                <strong>
                                                    <a href="<?= $current_url.'&action=edit&id='.$value->ID;?>"> <?= $value->post_title; ?>  </a>
                                                </strong>
                                            </p>
                                        </td>
                                        <td class='description column-description'>
                                            <p><?= $value->post_content; ?> </p>
                                        </td>
                                        <td class='description column-description'>
                                            <p >
												<?php
												$r = get_post_meta($value->ID,'required' , true);
												if($r){
													?>
                                                    <input checked onchange="update_post_meta(this,'<?= $value->ID?>' , 'required')" type="checkbox" <?= ($value->post_content == 'user_login' || $value->post_content == 'user_email' ||$value->post_content == 'user_pass') ? 'disabled': ''?>  name="required">
													<?php
												}
												else{
													?>
                                                    <input  type="checkbox" onchange="update_post_meta(this,'<?= $value->ID?>' , 'required')" <?= ($value->post_content == 'user_login' || $value->post_content == 'user_email' ||$value->post_content == 'user_pass') ? 'disabled': ''?> name="required">
													<?php
												}
												?>
                                            </p>
                                        </td>
                                        <td class='description column-description'>
                                            <p >
												<?php
												$r = get_post_meta($value->ID,'active' , true);
												if($r){
													?>
                                                    <input checked type="checkbox" onchange="update_post_meta(this,'<?= $value->ID?>' , 'active')" <?= ($value->post_content == 'user_login' || $value->post_content == 'user_email' ||$value->post_content == 'user_pass') ? 'disabled': ''?>  name="active">
													<?php
												}
												else{
													?>
                                                    <input  type="checkbox" onchange="update_post_meta(this,'<?= $value->ID?>' , 'active')" <?= ($value->post_content == 'user_login' || $value->post_content == 'user_email' ||$value->post_content == 'user_pass') ? 'disabled': ''?> name="active">
													<?php
												}
												?>
                                            </p>
                                        </td>
                                        <td class='description column-description'>
                                            <p >
												<?php
												$r = get_post_meta($value->ID,'display_register' , true);
												if($r){
													?>
                                                    <input checked type="checkbox" onchange="update_post_meta(this,'<?= $value->ID?>' , 'display_register')"  <?= ( $value->post_content == 'user_pass') ? 'disabled': ''?>  name="display_register">
													<?php
												}
												else{
													?>
                                                    <input  type="checkbox" onchange="update_post_meta(this,'<?= $value->ID?>' , 'display_register')" <?= ($value->post_content == 'user_pass') ? 'disabled': ''?> name="display_register">
													<?php
												}
												if($value->post_content == 'user_email'){
													?>
                                                    <span class="woocommerce-help-tip"
                                                          title="<?php _e('(If this field is disable, save email such as Example: username@site.com)', 'woo2app'); ?>"></span>
													<?php
												}
												?>
                                            </p>
                                        </td>
                                        <td class='description column-description'>
                                            <p >
												<?php
												$r = get_post_meta($value->ID,'display_edit' , true);
												if($r){
													?>
                                                    <input checked type="checkbox" onchange="update_post_meta(this,'<?= $value->ID?>' , 'display_edit')"  name="display_edit">
													<?php
												}
												else{
													?>
                                                    <input  type="checkbox" onchange="update_post_meta(this,'<?= $value->ID?>' , 'display_edit')" name="display_edit">
													<?php
												}
												?>
                                            </p>
                                        </td>
                                        <td class='description column-description'>
                                            <a href="<?= $current_url . '&action=edit&id=' . $value->ID; ?>"
                                               class="button button-primary"> <?php _e('Edit', 'woo2app'); ?> </a>
											<?php
											if(!in_array($value->post_content , $default_fields)){
												?>
                                                <input type="submit" name="submit_delete" class="button button-danger"
                                                       value="<?php _e('Delete', 'woo2app'); ?>">
												<?php
											}
											else{
                                                echo '<span style="color: red">' . _e('Can not delete.', 'woo2app') . '</span>';
											}
											?>
                                            <img class="display-none" width="25px"
                                                 id="img_change_menu_<?= $value->ID ?>"
                                                 src="<?php echo WP_PLUGIN_URL . "/" . dirname(plugin_basename(__FILE__)) . '/../files/img/load.gif' ?>">
                                        </td>
                                    </form>
                                </tr>
								<?php
							}
							?>
                            </tbody>
                        </table>
                        <p>
                            <input type="submit" name="sort" class="button button-default"
                                   value="<?php _e('Sort', 'woo2app'); ?>">
                            <?php _e('Drag&Drop to sort.', 'woo2app'); ?>
                        </p>
                    </form>
                </div>
            </div>
        </div>
    </div>
	<?php
}
?>
<script>
    jQuery(function() {
        jQuery( "#sortable" ).sortable();
        jQuery( "#sortable" ).disableSelection();
    });
    function update_post_meta(e ,post_id , meta_key) {
        jQuery("#img_change_menu_" + post_id).attr("style", "display:inline-block");
        jQuery("#tag-" + post_id + " input").attr('disabled' , 'disabled')
        var active = 0;
        if(e.checked == true) active = 1;
        jQuery.ajax({
            url: ajaxurl,
            data: {
                action: "mr2app_update_post_meta",
                post_id : post_id,
                meta_key : meta_key,
                active : active
            },
            success:function(data) {
                jQuery("#img_change_menu_" + post_id).attr("style", "display:none");
                jQuery("#tag-" + post_id + " input").removeAttr('disabled')
                //alert(data);
                data = data.substring(0,data.length -1);
                if(data == 1){
                    alert(_e('Change made.', 'woo2app'))
                }
                else{
                    alert(_e('Change has encountered a problem, please do it again.', 'woo2app'))
                }
            }
        });
    }
</script>