<?php


class mr2app_send_feedback {

	function __construct(){
		add_action( 'init', array( $this , 'mr2app_send_feedback_api_regular_url' ));
		add_filter( 'query_vars', array( $this , 'mr2app_send_feedback_api_query_vars' ));
		add_action( 'parse_request', array( $this , 'mr2app_send_feedback_api_parse_request' ));
	}
	function mr2app_send_feedback_api_regular_url(){

		add_rewrite_rule('^mr2app/send-feedback', 'index.php?send-feedback=$matches[1]', 'top');
		flush_rewrite_rules();
	}
	function mr2app_send_feedback_api_query_vars($query_vars) {
		$query_vars[] = 'send-feedback';

		return $query_vars;
	}

	function mr2app_send_feedback_api_parse_request(&$wp){
		if ( array_key_exists( 'send-feedback', $wp->query_vars ) ) {
			$this->send_feedback();
			exit();
		}
		return;
	}

	public function send_feedback(){
		$result = array('state' => -1);
		if(isset($_GET['app-version']) & isset($_GET['os-version'])){
			$app_version = $_GET['app-version'];
			$os_version =  $_GET['os-version'];
			$username =    isset($_GET['username']) ? $_GET['username'] : '';
			$msg =         isset($_GET['msg']) ? $_GET['msg'] : '';
			$rate =        isset($_GET['rate']) ? $_GET['rate'] : '';
			$install_id =  isset($_GET['install_id']) ? $_GET['install_id'] : '';

			$id = wp_insert_post(array(
				'post_title'   => $username,
				'post_type'    => 'app-feedback',
				'post_content' => $msg
			));
//			var_dump($id);
//			exit();
			if($id){
				add_post_meta($id , 'rate' , $rate);
				add_post_meta($id , 'app-version' , $app_version);
				add_post_meta($id , 'os-version' , $os_version);
				add_post_meta($id , 'install-id' , $install_id);
				add_post_meta($id , 'time' , time());
				$result = array('state' => 1);
			}

		}
		echo json_encode($result);
	}
}