<?php
if (!defined( 'ABSPATH' )) exit;
class woo2app_core_api_pay_methods {
    public function __construct(){
        add_action( 'init', array( $this , 'woo2app_api_regular_url' ));
        add_filter( 'query_vars', array( $this , 'woo2app_api_query_vars' ));
        add_action( 'parse_request', array( $this , 'woo2app_api_parse_request' ));
    }
    function woo2app_api_regular_url(){
        add_rewrite_rule('', 'index.php?GET_pay_methods', 'top');
    }
    function woo2app_api_query_vars($query_vars){
        $query_vars[] = 'GET_pay_methods';
        return $query_vars;
    }
    function woo2app_api_parse_request(&$wp){
        if ( array_key_exists( 'GET_pay_methods' , $wp->query_vars ) ) {
            $this->woo2app_GET_pay_methods();
            exit();
        }
        return;
    }
    function woo2app_GET_pay_methods(){
        if(isset($_POST['in'])){
            $in = $_POST['in'];
            $slashless = stripcslashes($in);
            $url_json = urldecode($slashless);
            $json = (array) json_decode($url_json);
            $package = array();
            $package['contents'] = array();
            $entity_body = $json;
	        $username = $json['username'] ? $json['username'] : $json['nameKarbari'];
	        $password = $json['password'] ? $json['password'] : $json['ramz'];
            if($json['customer_id'] != '-1'){
	            $user = wp_authenticate_username_password(NULL , $username , $password);
	            if(!isset($user->errors)){
		            //$user->data->ID;
		            wp_set_current_user($user->data->ID , $json['username']);
	            }
            }
            $line_items = $entity_body["items"];
            WC()->cart->empty_cart();
	        wc()->customer->set_shipping_country($entity_body["shipping"]->country);
	        wc()->customer->set_shipping_state($entity_body["shipping"]->state);
            foreach ($line_items as $line_item) {
                wc()->cart->add_to_cart( $line_item->product_id , $line_item->quantity , $line_item->variation_id  );
            }
            if(isset($json['coupon_lines'])){
                WC()->cart->add_discount( $json['coupon_lines'][0]->code);
            }
	        if(isset($json['shipping_lines']) && !empty($json['shipping_lines'])){
		        $method_rate_id = $json['shipping_lines'][0]->method_id;
		        $cost_rate = $this->get_title_shipping_method_from_method_id( $method_rate_id );
		        wc()->cart->set_shipping_total($cost_rate);
	        }
            $p = new WC_Payment_Gateways();
            $payment_methods = $p->get_available_payment_gateways();
            $array = array();
            foreach ($payment_methods as $key => $value) {
                $array[] = $value;
            }
            $payment_methods = $array;
            wp_send_json(array('currency' => get_option('woocommerce_currency'), 'payment_methods' => $payment_methods));
        }
    }

	public  function get_title_shipping_method_from_method_id( $method_rate_id = '' ){
		if( ! empty( $method_rate_id ) ){
			$method_key_id = str_replace( ':', '_', $method_rate_id ); // Formating
			$option_name = 'woocommerce_'.$method_key_id.'_settings'; // Get the complete option slug
			return get_option( $option_name, true )['cost']; // Get the title and return it
		} else {
			return false;
		}
	}
}