<?php
if (!defined( 'ABSPATH' )) exit;
class woo2app_core_api_setting {
	public function __construct(){
		add_action( 'init', array( $this , 'woo2app_api_regular_url' ));
		add_filter( 'query_vars', array( $this , 'woo2app_api_query_vars' ));
		add_action( 'parse_request', array( $this , 'woo2app_api_parse_request' ));
	}
	function woo2app_api_regular_url(){
		add_rewrite_rule('', 'index.php?GET_setting', 'top');
		add_rewrite_rule('', 'index.php?wp_get_a_post', 'top');
		add_rewrite_rule('', 'index.php?woo2app_version', 'top');
		add_rewrite_rule('', 'index.php?mr2app_login_web_view', 'top');
		add_rewrite_rule('', 'index.php?mr2app_logout_web_view', 'top');
	}
	function woo2app_api_query_vars($query_vars){
		$query_vars[] = 'GET_setting';
		$query_vars[] = 'wp_get_a_post';
		$query_vars[] = 'woo2app_version';
		$query_vars[] = 'mr2app_login_web_view';
		$query_vars[] = 'mr2app_logout_web_view';
		return $query_vars;
	}
	function woo2app_api_parse_request(&$wp){
		if( array_key_exists( 'GET_setting', $wp->query_vars )) {
			$this->woo2app_GET_setting();
			exit();
		}
		if( array_key_exists( 'woo2app_version', $wp->query_vars ) ) {
			$arr = array();
			$arr['version'] = WOO2APP_VERSION;
			echo json_encode($arr);
			exit();
		}
		if(array_key_exists( 'wp_get_a_post', $wp->query_vars)) {
			$this->wp_get_a_post();
			exit();
		}
		if(array_key_exists( 'mr2app_login_web_view', $wp->query_vars ) ) {
			$this->mr2app_login_web_view();
			exit();
		}
		if(array_key_exists( 'mr2app_logout_web_view', $wp->query_vars ) ) {
			$this->mr2app_logout_web_view();
			exit();
		}
		return;
	}

	function mr2app_login_web_view(){
		header('Content-Type: application/json; charset=utf-8');
		if(isset($_GET["api_key"]) && !empty($_GET['api_key'])){
			//wp_logout();
			$json = base64_decode($_GET['api_key']);
			$json =  (array) json_decode($json);
			$username = isset($json['username']) ? $json['username'] : $json['nameKarbari'];
			$password = isset($json['password']) ? $json['password'] : $json['ramz'];
			if (!empty($username) && !empty($password)) {
				$user = array(
					'user_login' => $username,
					'user_password' => $password,
					'remember' => false
				);
				$user_login = wp_signon($user, false);
				if($user_login->errors){
					if($user[0] == 0){
						$user = array(
							'user_login' => ltrim($username, '0'),
							'user_password' => $password,
							'remember' => false
						);
						$user = ltrim($user, '0');
						$user_login = wp_signon($user, false);
					}
                }
			}
		}
		else{
			echo json_encode(array('status' => false));
		}
		exit();
	}

	function mr2app_logout_web_view(){
		wp_logout();
		exit();
	}

	function wp_get_a_post(){
		?>
        <meta charset="<?php bloginfo( 'charset' ); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
		<?php wp_head(); ?>
        <div  style="width: 96%;padding: 0 10px">
			<?php
			$post_id = $_GET['post_id'];
			//echo $post_url = get_permalink($post_id);
			$queried_post = get_post($post_id);
			$content = $queried_post->post_content;
			$content = apply_filters('the_content', $content);
			$content = str_replace(']]>', ']]&gt;', $content);
			echo $content;
			?>
        </div>
		<?php
	}

	function woo2app_GET_setting(){
		header('Content-Type: application/json; charset=utf-8');
		ob_start();
		$mainpage_json = $this->get_mainpage();
		$slider_json = $this->get_slider();
		$menu_json = $this->get_menu();
		$setting_json = $this->get_setting();
		$data_zone = $this->get_default_data();
		$pool = array();
		$period =$this->period();
		$update = get_option('woo2app_update');
		$category_setting = get_option('woo2app_category_setting');
		$limit_cart = get_option('woo2app_limit_cart');
		$subdomains = get_option('mr2app_shop');
		$inviter = get_option('woo2app_inviter_setting');
		$primary_setting = get_option('woo2app_primary_setting');
		$page_order_setting = $this->get_page_order_setting();
		if(is_array($primary_setting)) $primary_setting = $primary_setting['primary_setting'];
		else {
			$primary_setting['register_rules']['enable'] =  false;
			$primary_setting['register_rules']['btn_text'] =  '';
			$primary_setting['register_rules']['link'] =  '' ;

			$primary_setting['order_rules']['enable'] =  false;
			$primary_setting['order_rules']['btn_text'] =  '';
			$primary_setting['order_rules']['link'] =  '' ;

			$primary_setting['payment_rules']['enable'] =  false;
			$primary_setting['payment_rules']['btn_text'] =  '';
			$primary_setting['payment_rules']['link'] =  '' ;
		}

		$product_setting = get_option('woo2app_product_page');
		if(!is_array($product_setting)){
			$product_setting = array();
			$product_setting['image'] = true ;
			$product_setting['title'] = true ;
			$product_setting['price'] = true ;
			$product_setting['attribute'] = true ;
			$product_setting['comment'] = true ;
			$product_setting['btn_share'] = true ;
			$product_setting['btn_barcode'] = true ;
			$product_setting['score'] = true ;
			$product_setting['category_name'] = true ;
			$product_setting['author'] = true ;
			$product_setting['sku'] = true ;
			$product_setting['short_description'] = true ;
			$product_setting['full_description'] = true ;
			$product_setting['middle_add_cart'] = true ;
			$product_setting['related_product'] = true ;
			$product_setting['add_cart'] = true ;
			$product_setting['search'] = true ;
			$product_setting['cart'] = true ;
			$product_setting['fav'] = true ;
			$product_setting['show_discount_percent'] = true ;
		}
		$order_setting = get_option('woo2app_order_form');
		if(!is_array($order_setting)){
			$order_setting = array();
			$order_setting['save_order_form'] = 1 ;
		}

		$wallet = array();

		include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		if ( is_plugin_active( 'woo-wallet/woo-wallet.php' ) ) {
			//plugin is activated
			$wallet = get_option('_wallet_settings_general');
			$wallet['product_id'] = get_option('_woo_wallet_recharge_product');
		}

		if(!is_array($subdomains)) $subdomains = array();
		if(!is_array($update)) {
			$update = array();
			$update['android_ver_code'] = '';
			$update['android_update_url'] = '';
			$update['android_update_req'] = false ;
			$update['ios_ver_code'] = '' ;
			$update['ios_update_url'] = '' ;
			$update['ios_update_req'] = false ;
		}
		if(!is_array($category_setting)) {
			$category_setting = array();
			$category_setting['state_receive'] = 'normal' ;
			$category_setting['product_category_page']['level_1']['selling'] = true;
			$category_setting['product_category_page']['level_1']['newer'] = true;

			$category_setting['product_category_page']['level_2']['selling'] = true;
			$category_setting['product_category_page']['level_2']['newer'] = true;

			$category_setting['product_category_page']['level_3']['selling'] = true;
			$category_setting['product_category_page']['level_3']['newer'] = true;

			$category_setting['product_category_page']['level_4']['selling'] = true;
			$category_setting['product_category_page']['level_4']['newer'] = true;
		}
		if(!is_array($limit_cart)) {
			$limit_cart = array();
			$limit_cart['buy_from_unit_store'] = false ;
			$limit_cart['empty_cart_after_reopen'] = false ;
		}
		if(!is_array($inviter)) {
			$inviter = array();
			$inviter['enable_after_register'] = false ;
			$inviter['inviter_title'] = '' ;
			$inviter['inviter_description'] = '' ;
			$inviter['display_score_in_menu'] = false ;
			$inviter['score_for_inviter_register'] = false ;
			$inviter['score_for_inviter_register_value'] = '' ;
			$inviter['score_for_inviter_first_order'] = '' ;
			$inviter['score_for_inviter_first_order_value'] = '' ;
			//$inviter['score_value_for_inviter'] = '' ;
			$inviter['score_type'] = '0' ;
			$inviter['score_user_title'] = '' ;
			$inviter['display_marketer_code'] = false ;
			$inviter['marketer_title'] = '' ;
			$inviter['type_make_code'] = 'username' ;
		}
		$array_all_setting =  array(
			'main_page' => $mainpage_json,
			'slider' => $slider_json,
			'menu' => $menu_json,
			'shop_setting' => $setting_json ,
			'states' => $data_zone,
			'poll' => $pool,
			'update' => $update,
			'subdomains' => $subdomains,
			'wallet' => $wallet,
			'period' => $period,
			'inviter' => $inviter,
			'limit_cart' => $limit_cart,
			'fetch_cats' => $category_setting,
			'actionBar' => $this->get_actionBar(),
			'intro' => $this->get_intro(),
			'primary_setting' => $primary_setting,
			'product_page' => $product_setting,
			'order_setting' => $order_setting,
			'woo2app_orderDetail' => $page_order_setting,
			'woo2app_loginPage' => $this->loginPage(),
			'price_view' => $this->price_view(),
			'popup' => $this->woo2app_popup(),
			'AppListState' => $this->get_AppListState(),
			'AppLoadingImage' => $this->get_LoadingSetting()
		);
		ob_clean();
		echo json_encode($array_all_setting);
	}

	public function get_LoadingSetting(){
		$AppLoadingImage = get_option('AppLoadingImage');
		$LoadingText = get_option('LoadingText');
		$array = array();
		$array['AppLoadingImage'] = $AppLoadingImage;
		$array['LoadingText'] = $LoadingText;
		return $array;
	}

	public function get_AppListState(){
		$AppProductList = get_option('AppProductList');
		$array = array();
		if(!is_array($AppProductList)){
			$array['productsState'] = '1001' ;
			$array['CategoryState'] = '3001' ;
		}
		else{
			$array['productsState'] = $AppProductList['state'] ;
			$array['CategoryState'] = $AppProductList['CategoryState'] ;
		}

		$AppPostList = get_option('AppPostsList');
		if(!is_array($AppPostList)){
			$array['postsState'] = '2001' ;
		}
		else{
			$array['postsState'] = $AppPostList['state'] ;
		}

		return $array;
	}

	public function woo2app_popup(){
		$popup = get_option('woo2app_popup');
		if(!is_array($popup)){
			$popup = array();
			$popup['enable'] = false ;
			$popup['html'] = '' ;
		}
		return $popup;
    }
	public  function get_page_order_setting(){
		$setting = get_option('woo2app_orderDetail');
		if(!is_array($setting))
			return array(
				'order_id' => true,
				'order_date' => true,
				'order_time' => true,
				'order_code' => true,
				'order_family_name' => true,
				'order_address' => true,
				'order_country' => true,
				'order_state' => true,
				'order_city' => true,
				'order_phone' => true,
				'order_post_code' => true,
				'order_tax' => true,
				'order_discount' => true,
				'order_price_all' => true,
				'order_shipping_price' => true,
				'order_final_price' => true,
				'order_payment_method' => true,
				'order_status' => true,
				'order_product_list' => true,
				'order_download_list' => true,
				'description' => true,
				'shipping_method' => true,
				'save_order' => true,
			);
		return array(
			'order_id' => isset($setting['order_id']) ? true : false,
			'order_date' => isset($setting['order_date']) ? true : false,
			'order_time' => isset($setting['order_time']) ? true : false,
			'order_code' => isset($setting['order_code']) ? true : false,
			'order_family_name' => isset($setting['order_family_name']) ? true : false,
			'order_address' => isset($setting['order_address']) ? true : false,
			'order_country' => isset($setting['order_country']) ? true : false,
			'order_state' => isset($setting['order_state']) ? true : false,
			'order_city' => isset($setting['order_city']) ? true : false,
			'order_phone' => isset($setting['order_phone']) ? true : false,
			'order_post_code' => isset($setting['order_post_code']) ? true : false,
			'order_tax' => isset($setting['order_tax']) ? true : false,
			'order_discount' => isset($setting['order_discount']) ? true : false,
			'order_price_all' => isset($setting['order_price_all']) ? true : false,
			'order_shipping_price' => isset($setting['order_shipping_price']) ? true : false,
			'order_final_price' => isset($setting['order_final_price']) ? true : false,
			'order_payment_method' => isset($setting['order_payment_method']) ? true : false,
			'order_status' => isset($setting['order_status']) ? true : false,
			'order_product_list' => isset($setting['order_product_list']) ? true : false,
			'order_download_list' => isset($setting['order_download_list']) ? true : false,
			'description' => isset($setting['description']) ? true : false,
			'shipping_method' => isset($setting['shipping_method']) ? true : false,
			'save_order' => isset($setting['save_order']) ? true : false,
		);
	}

	public  function get_intro(){
		$intro = get_option('mr2app_intro');
		if(!is_array($intro))
			return array(
				'next_before' => false,
				'end_btn' => array(
					'text' => 'اتمام',
					'txt_color' => '000000',
					'bg_color' => 'FFFFFF',
				),
				'display' => false,
				'images' => array()
			);
		return $intro;
	}

	public  function loginPage(){
		$login = get_option('woo2app_loginPage');
		if(!is_array($login))
			return array(
				'background' => '',
				'login' => ''
			);
		return $login;
	}
	public  function price_view(){
		$price_view = get_option('woo2app_price_view');
		if(!is_array($price_view))
			return array(
				'variables' => '1',
				'out_off_stock' => 'unavailable',
				'unavailable' => 'not for selling'
			);
		return $price_view;
	}

	public function get_actionBar(){
		$args = array(
			'post_type'   => 'actionbar_right',
			'post_status' => 'draft',
			'posts_per_page' => -1,
			'orderby' => 'menu_order',
			'order' => 'ASC'
		);
		$the_query = get_posts( $args );
		$array = array();
		$array['right'] = array();
		foreach ($the_query as $key) {
			# code...
			$value = $key->post_content;
			$type = get_post_meta($key->ID , 'type' , true);
			if($type == 'button') $value = 'f'.$value;
			$array['right'][] = array(
				'value' => $value ,
				'type' => $type,
				'action' => get_post_meta($key->ID , 'action' , true),
			);
		}
		$args = array(
			'post_type'   => 'actionbar_left',
			'post_status' => 'draft',
			'posts_per_page' => -1,
			'orderby' => 'menu_order',
			'order' => 'ASC'
		);
		$the_query = get_posts( $args );
		$array['left'] = array();
		foreach ($the_query as $key) {
			# code...
			$value = $key->post_content;
			$type = get_post_meta($key->ID , 'type' , true);
			if($type == 'button') $value = 'f'.$value;
			$array['left'][] = array(
				'value' => $value ,
				'type' => $type,
				'action' => get_post_meta($key->ID , 'action' , true),
			);

		}
		$args = array(
			'post_type'   => 'actionbar_center',
			'post_status' => 'draft',
			'posts_per_page' => -1,
			'orderby' => 'menu_order',
			'order' => 'ASC'
		);
		$the_query = get_posts( $args );
		$array['center'] = array();
		foreach ($the_query as $key) {
			# code...
			$value = $key->post_content;
			$type = get_post_meta($key->ID , 'type' , true);
			if($type == 'button') $value = 'f'.$value;
			$array['center'][] = array(
				'value' => $value ,
				'type' => $type,
				'action' => get_post_meta($key->ID , 'action' , true),
			);

		}

		return $array;
	}
	public function period(){
		$p = array();
		$p = get_option('mr2app_period');
		return $p;
	}
	private function get_mainpage(){
		global $wpdb;
		$table_name = $wpdb->prefix . "woo2app_mainpage";
		$rec = $wpdb->get_results("select * from $table_name ORDER BY mp_order ASC");
		$array = array();
		$count_load = "15";
		foreach ($rec as $key ) {
			$action = $key->mp_type;
			if ($key->mp_showtype == 4) {
				$slashless = $key->mp_value;
			}
            elseif ($key->mp_showtype == 1003) {
				$slashless = stripcslashes($key->mp_value);
				$slashless = json_decode($slashless);
	            $action = $action - time();
			}
            elseif ($key->mp_showtype == 10) {
				$slashless = stripcslashes($key->mp_value);
			}
            elseif ($key->mp_showtype > 1000 && $key->mp_showtype <= 1009 ) {
				$value = stripslashes($key->mp_value);
				$value = json_decode($value);
				if(is_object($value)){
					$count_load = $value->count_load;
					$slashless = $value->value;
				}
				else{
					$slashless = stripcslashes($key->mp_value);
				}
			}

			//This types is for old plugin
			//Horizintal and Vertical products list in old plugin
			elseif ($key->mp_showtype == 2 || $key->mp_showtype == 3) {
				$value = stripslashes($key->mp_value);
				$value = json_decode($value);
				if(is_object($value)){
					$count_load = $value->count_load;
					$slashless = $value->value;
				}
				else{
					$slashless = $key->mp_value;
				}
			}
			
			//This types is for old plugin
			//Custome list and Shegeftangiz list in old plugin
			elseif ($key->mp_showtype == 51 || $key->mp_showtype == 91) {
				$slashless = stripcslashes($key->mp_value);
				$slashless = json_decode($slashless);
				$action = $key->mp_showtype == 51 ?  time() : '';
			}
			
			else{
				$slashless = ($key->mp_value);
			}
			$array[] = array(
				"type" => $key->mp_showtype,
				"action" => $action,
				"value" => $slashless,
				"title" => $key->mp_title,
				"pic" => $key->mp_pic,
				"order" => $key->mp_order,
				"sort" => $key->mp_sort,
				"count_load" => $count_load
			);
		}
		return $array;
	}
	public function vizhe($value){
		require_once "woo2app_class_product.php";
		$x = new woocommerce_services_new();
		$results = json_decode($value);
		$array = array();
		foreach ($results as $key) {
			$y = $x->get_product($key);
			if($y == false) continue;
			foreach ($y as $p) {
				$array['products'][] = $p;
			}
			//$array[] = $y;
		}
		return $array;
	}
	private function get_slider(){
		global $wpdb;
		$table_name = $wpdb->prefix . "woo2app_slider";
		$rec = $wpdb->get_results("SELECT * FROM $table_name ORDER BY sl_sort");
		$array = array();
		foreach ($rec as $key ) {
			$array[] = array(
				"action" => $key->sl_type,
				"value" => $key->sl_value,
				"title" => $key->sl_title,
				"pic" => $key->sl_pic
			);
		}
		return $array;
	}
	private function get_menu(){
		global $wpdb;
		$mode_1 = get_option('App_display_menu_mode_1');
		if(!$mode_1) $mode_1 = '5001';
		$table_name = $wpdb->prefix . "woo2app_menu";
		$rec = $wpdb->get_results("select * from $table_name where menu_menu = 1 ORDER BY menu_order ASC");
		$array = array();
		foreach ($rec as $key) {
			$array[] = array(
				"action" => $key->menu_action,
				"value" => nl2br($key->menu_value),
				"title" => $key->menu_title,
				"pic" => $key->menu_pic,
				"order" => $key->menu_order
			);
		}
		$rec1 = $wpdb->get_results("select * from $table_name where menu_menu = 2 ORDER BY menu_order ASC");
		$array1 = array();
		foreach ($rec1 as $key) {
			$array1[] = array(
				"action" => $key->menu_action,
				"value" => nl2br($key->menu_value),
				"title" => $key->menu_title,
				"pic" => $key->menu_pic,
				"order" => $key->menu_order
			);
		}
		$rec1 = $wpdb->get_results("select * from $table_name where menu_menu = 3 ORDER BY menu_order ASC");
		$array3 = array();
		$mode_2 = get_option('App_display_menu_mode_2');
		if(!$mode_2) $mode_2 = '5001';
		foreach ($rec1 as $key) {
			$array3[] = array(
				"action" => $key->menu_action,
				"value" => $key->menu_value,
				"title" => $key->menu_title,
				"pic" => $key->menu_pic,
				"order" => $key->menu_order,
			);
		}
		$arraymenu1 = array(
			'show_account' => get_option("NUM_MENU1_account"),
			'position' => get_option("NUM_MENU1_POS"),
			'bg' => get_option("bg_menu1"),
			'items'    => $array,
			'mode' => $mode_1
		);
		$arraymenu2 = array(
			'position' => get_option("NUM_MENU2_POS"),
			'items'    => $array1
		);
		$arraymenu3 = array(
			'position' => get_option("NUM_MENU3_POS"),
			'show_account' => get_option("NUM_MENU3_account"),
			'bg' => get_option("bg_menu3"),
			'items'    => $array3,
            'mode' => $mode_2
		);
		return $arrayName = array( $arraymenu1 , $arraymenu2 ,$arraymenu3);
	}
	private function get_setting(){
		$update = get_option('woo2app_update');
		if(!is_array($update)) {
			$update = array();
			$update['android_ver_code'] = '';
			$update['android_update_url'] = '';
			$update['android_update_req'] = false ;
			$update['ios_ver_code'] = '' ;
			$update['ios_update_url'] = '' ;
			$update['ios_update_req'] = false ;
		}
		$color = get_option('woo2app_color_setting');
		if(!is_array($color)){
			$color = array();
		}
		$arraysetting = array(
			//**************general****************************************
			$arrayName = array('key' => 'URL_SPLASH_PIC' , 'value' => get_option("URL_SPLASH_PIC") ? get_option("URL_SPLASH_PIC") : '0') ,
			$arrayName = array('key' => 'NUM_SPLASH_DELAY' , 'value' => get_option("NUM_SPLASH_DELAY") ? get_option("NUM_SPLASH_DELAY") : '0') ,
			$arrayName = array('key' => 'fill_state' , 'value' => get_option("fill_state") ? get_option("fill_state") : 'Center') ,
			$arrayName = array('key' => 'display_loading' , 'value' => get_option("display_loading") ? get_option("display_loading") : '0') ,
			$arrayName = array('key' => 'NUM_MENU1_POS' , 'value' => get_option("NUM_MENU1_POS") ? get_option("NUM_MENU1_POS") : '-1' ) ,
			$arrayName = array('key' => 'NUM_MENU2_POS' , 'value' => get_option("NUM_MENU2_POS") ? get_option("NUM_MENU2_POS") : '-1') ,


			$arrayName = array('key' => 'COLOR_GENERAL_ACTIONBAR_BG' , 'value' => $color['general_setting']['COLOR_GENERAL_ACTIONBAR_BG']['value'] ? substr($color['general_setting']['COLOR_GENERAL_ACTIONBAR_BG']['value'] , 1) : 'f53600' ),
			$arrayName = array('key' => 'COLOR_GENERAL_ACTIONBAR_TXT' , 'value' => $color['general_setting']['COLOR_GENERAL_ACTIONBAR_TXT']['value'] ? substr($color['general_setting']['COLOR_GENERAL_ACTIONBAR_TXT']['value'] , 1) : 'ffffff' ),
			$arrayName = array('key' => 'COLOR_GENERAL_STATUSBAR_BG' , 'value' => $color['general_setting']['COLOR_GENERAL_STATUSBAR_BG']['value'] ? substr($color['general_setting']['COLOR_GENERAL_STATUSBAR_BG']['value'] , 1) : 'eeeeee' ),
			$arrayName = array('key' => 'COLOR_GENERAL_MAIN_BG' , 'value' => $color['general_setting']['COLOR_GENERAL_MAIN_BG']['value'] ? substr($color['general_setting']['COLOR_GENERAL_MAIN_BG']['value'] , 1) : 'ffffff' ),
			$arrayName = array('key' => 'COLOR_CELL_CAT_BG' , 'value' => $color['general_setting']['COLOR_CELL_CAT_BG']['value'] ? substr($color['general_setting']['COLOR_CELL_CAT_BG']['value'] , 1) : 'ffffff' ),
			$arrayName = array('key' => 'COLOR_CELL_CAT_TXT' , 'value' => $color['general_setting']['COLOR_CELL_CAT_TXT']['value'] ? substr($color['general_setting']['COLOR_CELL_CAT_TXT']['value'] , 1) : '000000' ),
			$arrayName = array('key' => 'COLOR_GENERAL_SPLASH_BG' , 'value' => $color['general_setting']['COLOR_GENERAL_SPLASH_BG']['value'] ? substr($color['general_setting']['COLOR_GENERAL_SPLASH_BG']['value'] , 1) : 'ffffff' ),

			//************primary*******************************************
			$arrayName = array('key' => 'COLOR_CATLISTBUTTON_BG' , 'value' => $color['main_page']['COLOR_CATLISTBUTTON_BG']['value'] ? substr($color['main_page']['COLOR_CATLISTBUTTON_BG']['value'] , 1) : '1aac1a' ),
			$arrayName = array('key' => 'COLOR_CATLISTBUTTON_TEXT' , 'value' => $color['main_page']['COLOR_CATLISTBUTTON_TEXT']['value'] ? substr($color['main_page']['COLOR_CATLISTBUTTON_TEXT']['value'] , 1) : 'ffffff' ),
			$arrayName = array('key' => 'COLOR_MOREBUTTON_BG' , 'value' => $color['main_page']['COLOR_MOREBUTTON_BG']['value'] ? substr($color['main_page']['COLOR_MOREBUTTON_BG']['value'] , 1) : 'f5363e' ),
			$arrayName = array('key' => 'COLOR_MOREBUTTON_TEXT' , 'value' => $color['main_page']['COLOR_MOREBUTTON_TEXT']['value'] ? substr($color['main_page']['COLOR_MOREBUTTON_TEXT']['value'] , 1) : 'ffffff' ),
			$arrayName = array('key' => 'COLOR_PRODUCTCELL_BG' , 'value' => $color['main_page']['COLOR_PRODUCTCELL_BG']['value'] ? substr($color['main_page']['COLOR_PRODUCTCELL_BG']['value'] , 1) : 'ffffff' ),
			$arrayName = array('key' => 'COLOR_PRODUCTCELL_TITLE_TEXT' , 'value' => $color['main_page']['COLOR_PRODUCTCELL_TITLE_TEXT']['value'] ? substr($color['main_page']['COLOR_PRODUCTCELL_TITLE_TEXT']['value'] , 1) : '000000' ),
			$arrayName = array('key' => 'COLOR_PRODUCTCELL_PRICE_TEXT' , 'value' => $color['main_page']['COLOR_PRODUCTCELL_PRICE_TEXT']['value'] ? substr($color['main_page']['COLOR_PRODUCTCELL_PRICE_TEXT']['value'] , 1) : '1aac1a' ),
			$arrayName = array('key' => 'COLOR_PRODUCTCELL_OFFPRICE_TEXT' , 'value' => $color['main_page']['COLOR_PRODUCTCELL_OFFPRICE_TEXT']['value'] ? substr($color['main_page']['COLOR_PRODUCTCELL_OFFPRICE_TEXT']['value'] , 1) : 'ff0000' ),
			$arrayName = array('key' => 'COLOR_MENU_BG' , 'value' => $color['main_page']['COLOR_MENU_BG']['value'] ? substr($color['main_page']['COLOR_MENU_BG']['value'] , 1) : 'eeeeee' ),
			$arrayName = array('key' => 'COLOR_MENU_TEXT' , 'value' => $color['main_page']['COLOR_MENU_TEXT']['value'] ? substr($color['main_page']['COLOR_MENU_TEXT']['value'] , 1) : '000000' ),
			$arrayName = array('key' => 'COLOR_LIST_PRICE_DEVIDER_BG' , 'value' => $color['main_page']['COLOR_LIST_PRICE_DEVIDER_BG']['value'] ? substr($color['main_page']['COLOR_LIST_PRICE_DEVIDER_BG']['value'] , 1) : 'cfcdcd' ),
			$arrayName = array('key' => 'COLOR_MENU_FLOT_BG' , 'value' => $color['main_page']['COLOR_MENU_FLOT_BG']['value'] ? substr($color['main_page']['COLOR_MENU_FLOT_BG']['value'] , 1) : 'f5363e' ),
			$arrayName = array('key' => 'COLOR_LIST_TITLE_TEXT' , 'value' => $color['main_page']['COLOR_LIST_TITLE_TEXT']['value'] ? substr($color['main_page']['COLOR_LIST_TITLE_TEXT']['value'] , 1) : '000000' ),
			$arrayName = array('key' => 'UNAVAILABLE_PRODUCT_COLOR' , 'value' => $color['main_page']['UNAVAILABLE_PRODUCT_COLOR']['value'] ? substr($color['main_page']['UNAVAILABLE_PRODUCT_COLOR']['value'] , 1) : '000000' ),
			$arrayName = array('key' => 'BG_BTN_BASKET_CELL' , 'value' => $color['main_page']['BG_BTN_BASKET_CELL']['value'] ? substr($color['main_page']['BG_BTN_BASKET_CELL']['value'] , 1) : '1aac1a' ),
			$arrayName = array('key' => 'TXT_BTN_BASKET_CELL' , 'value' => $color['main_page']['TXT_BTN_BASKET_CELL']['value'] ? substr($color['main_page']['TXT_BTN_BASKET_CELL']['value'] , 1) : 'ffffff' ),
			$arrayName = array('key' => 'BG_BTN_INCREASE_CELL' , 'value' => $color['main_page']['BG_BTN_INCREASE_CELL']['value'] ? substr($color['main_page']['BG_BTN_INCREASE_CELL']['value'] , 1) : 'f5363e' ),
			$arrayName = array('key' => 'TXT_INCREASE_CELL' , 'value' => $color['main_page']['TXT_INCREASE_CELL']['value'] ? substr($color['main_page']['TXT_INCREASE_CELL']['value'] , 1) : 'ffffff' ),
			$arrayName = array('key' => 'COLOR_GENERAL_TABBAR_BG' , 'value' => $color['main_page']['COLOR_GENERAL_TABBAR_BG']['value'] ? substr($color['main_page']['COLOR_GENERAL_TABBAR_BG']['value'] , 1) : 'FF0000' ),
			$arrayName = array('key' => 'COLOR_GENERAL_TABBAR_TXT' , 'value' => $color['main_page']['COLOR_GENERAL_TABBAR_TXT']['value'] ? substr($color['main_page']['COLOR_GENERAL_TABBAR_TXT']['value'] , 1) : 'ffffff' ),
			$arrayName = array('key' => 'COLOR_GENERAL_TABBAR_SEL' , 'value' => $color['main_page']['COLOR_GENERAL_TABBAR_SEL']['value'] ? substr($color['main_page']['COLOR_GENERAL_TABBAR_SEL']['value'] , 1) : 'F5363E' ),


			//***********bascket***********************************************
			$arrayName = array('key' => 'COLOR_BASKET_LIST_BG' , 'value' => $color['shopping_cart_page']['COLOR_BASKET_LIST_BG']['value'] ? substr($color['shopping_cart_page']['COLOR_BASKET_LIST_BG']['value'] , 1) : 'ffffff' ),
			$arrayName = array('key' => 'COLOR_BASKET_P_TITLE_TEXT' , 'value' => $color['shopping_cart_page']['COLOR_BASKET_P_TITLE_TEXT']['value'] ? substr($color['shopping_cart_page']['COLOR_BASKET_P_TITLE_TEXT']['value'] , 1) : '000000' ),
			$arrayName = array('key' => 'COLOR_BASKET_PRICEVAHED_TEXT' , 'value' => $color['shopping_cart_page']['COLOR_BASKET_PRICEVAHED_TEXT']['value'] ? substr($color['shopping_cart_page']['COLOR_BASKET_PRICEVAHED_TEXT']['value'] , 1) : '1aac1a' ),
			$arrayName = array('key' => 'COLOR_BASKET_PRICEVAHED_BG' , 'value' => $color['shopping_cart_page']['COLOR_BASKET_PRICEVAHED_BG']['value'] ? substr($color['shopping_cart_page']['COLOR_BASKET_PRICEVAHED_BG']['value'] , 1) : 'e7e7e7' ),
			$arrayName = array('key' => 'COLOR_BASKET_PRICEKOL_TEXT' , 'value' => $color['shopping_cart_page']['COLOR_BASKET_PRICEKOL_TEXT']['value'] ? substr($color['shopping_cart_page']['COLOR_BASKET_PRICEKOL_TEXT']['value'] , 1) : '1aac1a' ),
			$arrayName = array('key' => 'COLOR_BASKET_PRICEKOL_BG' , 'value' => $color['shopping_cart_page']['COLOR_BASKET_PRICEKOL_BG']['value'] ? substr($color['shopping_cart_page']['COLOR_BASKET_PRICEKOL_BG']['value'] , 1) : 'e7e7e7' ),
			$arrayName = array('key' => 'COLOR_BASKET_DEL_TEXT' , 'value' => $color['shopping_cart_page']['COLOR_BASKET_DEL_TEXT']['value'] ? substr($color['shopping_cart_page']['COLOR_BASKET_DEL_TEXT']['value'] , 1) : 'f5363e' ),
			$arrayName = array('key' => 'COLOR_BASKET_DEL_BG' , 'value' => $color['shopping_cart_page']['COLOR_BASKET_DEL_BG']['value'] ? substr($color['shopping_cart_page']['COLOR_BASKET_DEL_BG']['value'] , 1) : 'e7e7e7' ),
			$arrayName = array('key' => 'COLOR_BASKET_TOTAL_TEXT' , 'value' => $color['shopping_cart_page']['COLOR_BASKET_TOTAL_TEXT']['value'] ? substr($color['shopping_cart_page']['COLOR_BASKET_TOTAL_TEXT']['value'] , 1) : '1aac1a' ),
			$arrayName = array('key' => 'COLOR_BASKET_TOTAL_BG' , 'value' => $color['shopping_cart_page']['COLOR_BASKET_TOTAL_BG']['value'] ? substr($color['shopping_cart_page']['COLOR_BASKET_TOTAL_BG']['value'] , 1) : 'ffffff' ),
			$arrayName = array('key' => 'COLOR_COMPLETEORDER_BG' , 'value' => $color['shopping_cart_page']['COLOR_COMPLETEORDER_BG']['value'] ? substr($color['shopping_cart_page']['COLOR_COMPLETEORDER_BG']['value'] , 1) : '1aac1a' ),
			$arrayName = array('key' => 'COLOR_COMPLETEORDER_TEXT' , 'value' => $color['shopping_cart_page']['COLOR_COMPLETEORDER_TEXT']['value'] ? substr($color['shopping_cart_page']['COLOR_COMPLETEORDER_TEXT']['value'] , 1) : 'ffffff' ),
			$arrayName = array('key' => 'COLOR_BASKET_COUNT_TEXT' , 'value' => $color['shopping_cart_page']['COLOR_BASKET_COUNT_TEXT']['value'] ? substr($color['shopping_cart_page']['COLOR_BASKET_COUNT_TEXT']['value'] , 1) : '000000' ),

			//***********product**************************************************
			$arrayName = array('key' => 'COLOR_ADDCARD_BG' , 'value' => $color['product_page']['COLOR_ADDCARD_BG']['value'] ? substr($color['product_page']['COLOR_ADDCARD_BG']['value'] , 1) : '1aac1a' ),
			$arrayName = array('key' => 'COLOR_ADDCARD_TEXT' , 'value' => $color['product_page']['COLOR_ADDCARD_TEXT']['value'] ? substr($color['product_page']['COLOR_ADDCARD_TEXT']['value'] , 1) : 'ffffff' ),
			$arrayName = array('key' => 'COLOR_PRODUCTGALLERY_BG' , 'value' => $color['product_page']['COLOR_PRODUCTGALLERY_BG']['value'] ? substr($color['product_page']['COLOR_PRODUCTGALLERY_BG']['value'] , 1) : 'eeeeee' ),
			$arrayName = array('key' => 'COLOR_PRODUC_TTITLE_TEXT' , 'value' => $color['product_page']['COLOR_PRODUC_TTITLE_TEXT']['value'] ? substr($color['product_page']['COLOR_PRODUC_TTITLE_TEXT']['value'] , 1) : '000000' ),
			$arrayName = array('key' => 'COLOR_PRODUCT_PRICE_TEXT' , 'value' => $color['product_page']['COLOR_PRODUCT_PRICE_TEXT']['value'] ? substr($color['product_page']['COLOR_PRODUCT_PRICE_TEXT']['value'] , 1) : '1aac1a' ),
			$arrayName = array('key' => 'COLOR_PRODUCT_PRICEOFF_TEXT' , 'value' => $color['product_page']['COLOR_PRODUCT_PRICEOFF_TEXT']['value'] ? substr($color['product_page']['COLOR_PRODUCT_PRICEOFF_TEXT']['value'] , 1) : 'f5363e' ),

			//**********desc order*********************************************
			$arrayName = array('key' => 'COLOR_DETAILO_PAYBUTTON_BG' , 'value' => $color['order_description_page']['COLOR_DETAILO_PAYBUTTON_BG']['value'] ? substr($color['order_description_page']['COLOR_DETAILO_PAYBUTTON_BG']['value'] , 1) : '1aac1a' ),
			$arrayName = array('key' => 'COLOR_DETAILO_PAYBUTTON_TEXT' , 'value' => $color['order_description_page']['COLOR_DETAILO_PAYBUTTON_TEXT']['value'] ? substr($color['order_description_page']['COLOR_DETAILO_PAYBUTTON_TEXT']['value'] , 1) : 'ffffff' ),
			$arrayName = array('key' => 'COLOR_DETAILO_PAYDES_TEXT' , 'value' => $color['order_description_page']['COLOR_DETAILO_PAYDES_TEXT']['value'] ? substr($color['order_description_page']['COLOR_DETAILO_PAYDES_TEXT']['value'] , 1) : '000000' ),
			$arrayName = array('key' => 'COLOR_DETAILO_PAYDES_BG' , 'value' => $color['order_description_page']['COLOR_DETAILO_PAYDES_BG']['value'] ? substr($color['order_description_page']['COLOR_DETAILO_PAYDES_BG']['value'] , 1) : 'ffffff' ),
			$arrayName = array('key' => 'COLOR_DETAILO_PAYITEM_BG' , 'value' => $color['order_description_page']['COLOR_DETAILO_PAYITEM_BG']['value'] ? substr($color['order_description_page']['COLOR_DETAILO_PAYITEM_BG']['value'] , 1) : 'ffffff' ),
			$arrayName = array('key' => 'COLOR_DETAILO_PAYITEM_TEXT' , 'value' => $color['order_description_page']['COLOR_DETAILO_PAYITEM_TEXT']['value'] ? substr($color['order_description_page']['COLOR_DETAILO_PAYITEM_TEXT']['value'] , 1) : '000000' ),

			//*********submit order************************************
			$arrayName = array('key' => 'COLOR_SUBTMIORDER_BG' , 'value' => $color['order_page']['COLOR_SUBTMIORDER_BG']['value'] ? substr($color['order_page']['COLOR_SUBTMIORDER_BG']['value'] , 1) : '1aac1a' ),
			$arrayName = array('key' => 'COLOR_SUBMITORDER_TEXT' , 'value' => $color['order_page']['COLOR_SUBMITORDER_TEXT']['value'] ? substr($color['order_page']['COLOR_SUBMITORDER_TEXT']['value'] , 1) : 'ffffff' ),
			$arrayName = array('key' => 'COLOR_SUBMITORDER_ACCONT_TEXT' , 'value' => $color['order_page']['COLOR_SUBMITORDER_ACCONT_TEXT']['value'] ? substr($color['order_page']['COLOR_SUBMITORDER_ACCONT_TEXT']['value'] , 1) : 'f5363e' ),
			$arrayName = array('key' => 'COLOR_SUBMITORDER_TOTAL_TEXT' , 'value' => $color['order_page']['COLOR_SUBMITORDER_TOTAL_TEXT']['value'] ? substr($color['order_page']['COLOR_SUBMITORDER_TOTAL_TEXT']['value'] , 1) : '1d89e4' ),

			//********register*****************************************
			$arrayName = array('key' => 'COLOR_REGISTERBUTTON_BG' , 'value' => $color['register_page']['COLOR_REGISTERBUTTON_BG']['value'] ? substr($color['register_page']['COLOR_REGISTERBUTTON_BG']['value'] , 1) : '1aac1a' ),
			$arrayName = array('key' => 'COLOR_REGISTERBUTTON_TEXT' , 'value' => $color['register_page']['COLOR_REGISTERBUTTON_TEXT']['value'] ? substr($color['register_page']['COLOR_REGISTERBUTTON_TEXT']['value'] , 1) : 'ffffff' ),

			//*******edit user**************************************
			$arrayName = array('key' => 'COLOR_EDITUSERBUTTON_BG' , 'value' => $color['edit_user_page']['COLOR_EDITUSERBUTTON_BG']['value'] ? substr($color['edit_user_page']['COLOR_EDITUSERBUTTON_BG']['value'] , 1) : '1aac1a' ),
			$arrayName = array('key' => 'COLOR_EDITUSERBUTTON_TEXT' , 'value' => $color['edit_user_page']['COLOR_EDITUSERBUTTON_TEXT']['value'] ? substr($color['edit_user_page']['COLOR_EDITUSERBUTTON_TEXT']['value'] , 1) : 'ffffff' ),

			//***********login***************************************
			$arrayName = array('key' => 'COLOR_LOGINBUTTON_BG' , 'value' => $color['login_page']['COLOR_LOGINBUTTON_BG']['value'] ? substr($color['login_page']['COLOR_LOGINBUTTON_BG']['value'] , 1) : '1aac1a' ),
			$arrayName = array('key' => 'COLOR_LOGINBUTTON_TEXT' , 'value' => $color['login_page']['COLOR_LOGINBUTTON_TEXT']['value'] ? substr($color['login_page']['COLOR_LOGINBUTTON_TEXT']['value'] , 1) : 'ffffff' ),
			$arrayName = array('key' => 'COLOR_LOGIN_FORGETPPASS_TEXT' , 'value' => $color['login_page']['COLOR_LOGIN_FORGETPPASS_TEXT']['value'] ? substr($color['login_page']['COLOR_LOGIN_FORGETPPASS_TEXT']['value'] , 1) : '000000' ),
			$arrayName = array('key' => 'COLOR_LOGIN_REGISTER_TEXT' , 'value' => $color['login_page']['COLOR_LOGIN_REGISTER_TEXT']['value'] ? substr($color['login_page']['COLOR_LOGIN_REGISTER_TEXT']['value'] , 1) : '1d89e4' ),
			$arrayName = array('key' => 'COLOR_LOGIN_TextBox_TEXT' , 'value' => $color['login_page']['COLOR_LOGIN_TextBox_TEXT']['value'] ? substr($color['login_page']['COLOR_LOGIN_TextBox_TEXT']['value'] , 1) : '000000' ),
			$arrayName = array('key' => 'COLOR_LOGIN_BG_Register_BTN' , 'value' => $color['login_page']['COLOR_LOGIN_BG_Register_BTN']['value'] ? substr($color['login_page']['COLOR_LOGIN_BG_Register_BTN']['value'] , 1) : 'ffffff' ),

			//*************change pass******************************
			$arrayName = array('key' => 'COLOR_CHANGEPASS_BG' , 'value' => $color['change_pass_page']['COLOR_CHANGEPASS_BG']['value'] ? substr($color['change_pass_page']['COLOR_CHANGEPASS_BG']['value'] , 1) : '1aac1a' ),
			$arrayName = array('key' => 'COLOR_CHANGEPASS_TEXT' , 'value' => $color['change_pass_page']['COLOR_CHANGEPASS_TEXT']['value'] ? substr($color['change_pass_page']['COLOR_CHANGEPASS_TEXT']['value'] , 1) : 'ffffff' ),

			//***********forgot pass*****************************
			$arrayName = array('key' => 'COLOR_FORGETBUTTON_BG' , 'value' => $color['forget']['COLOR_FORGETBUTTON_BG']['value'] ? substr($color['forget']['COLOR_FORGETBUTTON_BG']['value'] , 1) : '1aac1a' ),
			$arrayName = array('key' => 'COLOR_FORGETBUTTON_TEXT' , 'value' => $color['forget']['COLOR_FORGETBUTTON_TEXT']['value'] ? substr($color['forget']['COLOR_FORGETBUTTON_TEXT']['value'] , 1) : 'ffffff' ),

			$arrayName = array('key' => 'SHOW_BTN_CATLST' , 'value' => get_option("SHOW_BTN_CATLST") ? get_option("SHOW_BTN_CATLST") : '0' ) ,
			$arrayName = array('key' => 'SHOW_MAP' , 'value' => get_option("SHOW_MAP") ? get_option("SHOW_MAP") : '0' ) ,
			//*********** blog color setting*******************************************************************
			$arrayName = array('key' => 'COLOR_BLOG_SELLOL_BG' , 'value' => get_option('COLOR_BLOG_SELLOL_BG') && strlen(get_option('COLOR_BLOG_SELLOL_BG')) == 7 ? substr(get_option("COLOR_BLOG_SELLOL_BG"), 1) : 'ffffff'  ) ,
			$arrayName = array('key' => 'COLOR_BLOG_SELLOL_TXT' , 'value' => get_option("COLOR_BLOG_SELLOL_TXT") && strlen(get_option('COLOR_BLOG_SELLOL_TXT')) == 7 ? substr(get_option("COLOR_BLOG_SELLOL_TXT") , 1) : '000000' ) ,
			$arrayName = array('key' => 'COLOR_BLOG_HEADER_BG' , 'value' => get_option("COLOR_BLOG_HEADER_BG") && strlen(get_option('COLOR_BLOG_HEADER_BG')) == 7 ? substr(get_option("COLOR_BLOG_HEADER_BG") , 1) : 'F5363E' ) ,
			$arrayName = array('key' => 'COLOR_BLOG_HEADER_TXT' , 'value' => get_option("COLOR_BLOG_HEADER_TXT") && strlen(get_option('COLOR_BLOG_HEADER_TXT')) == 7 ? substr(get_option("COLOR_BLOG_HEADER_TXT") , 1) : 'f7f7f7' ) ,
			$arrayName = array('key' => 'COLOR_BLOG_FOOTER_BG' , 'value' => get_option("COLOR_BLOG_FOOTER_BG")  && strlen(get_option('COLOR_BLOG_FOOTER_BG')) == 7 ? substr(get_option("COLOR_BLOG_FOOTER_BG"), 1) : 'D17777'  ) ,
			$arrayName = array('key' => 'COLOR_BLOG_FOOTER_TXT' , 'value' => get_option("COLOR_BLOG_FOOTER_TXT") && strlen(get_option('COLOR_BLOG_FOOTER_TXT')) == 7 ? substr(get_option("COLOR_BLOG_FOOTER_TXT") , 1) : 'ffffff' ) ,
			//*********** pishnehad vizhe color setting*******************************************************************
			$arrayName = array('key' => 'COLOR_VIZHE_TXT' , 'value' => $color['amazing_suggestion']['COLOR_VIZHE_TXT']['value'] ? substr($color['amazing_suggestion']['COLOR_VIZHE_TXT']['value'] , 1) : '666666' ),
			$arrayName = array('key' => 'COLOR_VIZHE_SELLOL_ZAMAN' , 'value' => $color['amazing_suggestion']['COLOR_VIZHE_SELLOL_ZAMAN']['value'] ? substr($color['amazing_suggestion']['COLOR_VIZHE_SELLOL_ZAMAN']['value'] , 1) : '666666' ),
			$arrayName = array('key' => 'COLOR_VIZHE_ZAMAN_TXT' , 'value' => $color['amazing_suggestion']['COLOR_VIZHE_ZAMAN_TXT']['value'] ? substr($color['amazing_suggestion']['COLOR_VIZHE_ZAMAN_TXT']['value'] , 1) : 'ffffff' ),

			//***********primary setting*******************************************************************
			$arrayName = array('key' => 'DEFAULT_BROWSER_IN' , 'value' => 'NO' ) ,
			$arrayName = array('key' => 'DEFAULT_FONT_APP' , 'value' => get_option("DEFAULT_FONT_APP") ?  get_option("DEFAULT_FONT_APP") : '1' ) ,
			$arrayName = array('key' => 'DEFAULT_PRODUCT_CELL' , 'value' => (int) get_option("DEFAULT_PRODUCT_CELL") ?(int) get_option("DEFAULT_PRODUCT_CELL") : 1  ) ,
			$arrayName = array('key' => 'DEFAULT_UNIT_APP' , 'value' => get_option("DEFAULT_UNIT_APP") ? get_option("DEFAULT_UNIT_APP") : 'تومان' ) ,

			$arrayName = array('key' => 'DEFAULT_LNK_APP' , 'value' => $update['android_update_url']) ,
			$arrayName = array('key' => 'DEFAULT_VER_APP' , 'value' => $update['android_ver_code'] ) ,

			$arrayName = array('key' => 'minimum_purchase_amount' , 'value' => get_option("minimum_purchase_amount") ? get_option("minimum_purchase_amount"): '0' ) ,
			$arrayName = array('key' => 'category_them' , 'value' => get_option("category_them") ? get_option("category_them") : '1' ) ,
			$arrayName = array('key' => 'category_select_btn' , 'value' => get_option("category_select_btn")? get_option("category_select_btn") : '1'  ) ,
			$arrayName = array('key' => 'discount_label_list' , 'value' => get_option("discount_label_list")? get_option("discount_label_list") : '1'  ) ,
			$arrayName = array('key' => 'quick_display_product' , 'value' => get_option("quick_display_product")? get_option("quick_display_product") : '1'  ) ,
			$arrayName = array('key' => 'BUY_WITH_LOGIN' , 'value' => get_option("BUY_WITH_LOGIN")? (bool)get_option("BUY_WITH_LOGIN") : false  ) ,
			$arrayName = array('key' => 'ENTER_WITH_LOGIN' , 'value' => get_option("ENTER_WITH_LOGIN")? (bool)get_option("ENTER_WITH_LOGIN") : false  ) ,
			$arrayName = array('key' => 'display_btn_share' , 'value' => get_option("display_btn_share")? (bool)get_option("display_btn_share") : false  ) ,
			$arrayName = array('key' => 'NAVIGATION_BUTTON' , 'value' => get_option("NAVIGATION_BUTTON")? get_option("NAVIGATION_BUTTON") : '0'  ) ,
			$arrayName = array('key' => 'woo2app_googleloginkey' , 'value' => get_option("woo2app_googleloginkey")? get_option("woo2app_googleloginkey") : ''  ) ,
			$arrayName = array('key' => 'calltoprice_tell' , 'value' => get_option("calltoprice_tell")? get_option("calltoprice_tell") : ''  ) ,
			$arrayName = array('key' => 'calltoprice_price' , 'value' => get_option("calltoprice_price") != null ? get_option("calltoprice_price") : ''  ) ,
			$arrayName = array('key' => 'default_product_images' , 'value' => get_option("default_product_images")? get_option("default_product_images") : ''  ) ,
			$arrayName = array('key' => 'woocommerce_enable_reviews' , 'value' => get_option("woocommerce_enable_reviews")? get_option("woocommerce_enable_reviews") : ''  ) ,
			$arrayName = array('key' => 'woocommerce_review_rating_verification_required' , 'value' => get_option("woocommerce_review_rating_verification_required")? get_option("woocommerce_review_rating_verification_required") : ''  ) ,
			$arrayName = array('key' => 'woocommerce_enable_review_rating' , 'value' => get_option("woocommerce_enable_review_rating")? get_option("woocommerce_enable_review_rating") : ''  ) ,
			$arrayName = array('key' => 'woocommerce_review_rating_required' , 'value' => get_option("woocommerce_review_rating_required")? get_option("woocommerce_review_rating_required") : ''  ) ,
		);
		return $arraysetting;
	}
	function get_default_data(){
		global $woocommerce;
		$countries_obj   = new WC_Countries();
		//$countries   = $countries_obj->__get('countries');
		$default_country = $countries_obj->get_base_country();
		$default_county_states = $countries_obj->get_states( $default_country );
		$states = array();
		if(!empty($default_county_states)){
			foreach ($default_county_states as $key=>$state) {
				$states[]= array(
					'id'    => $key,
					'name'  => $state
				);
			}
        }
		return $json['states'] = $states;
	}
}