<?php
/*
Plugin Name: woo2app
Plugin URI: -
Description: WooCommerce mobile app manager and API.
Version: 3.5.1
Author: App Maker
Author URI: -
Text Domain: woo2app
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
define( 'WOO2APP_VERSION', "3.5.1" );
define( 'WOO2APP_PATH', plugin_dir_path( __FILE__ ) );
define( 'WOO2APP_URL', plugin_dir_url( __FILE__ ) );
define( 'WOO2APP_CSS_URL', trailingslashit( WOO2APP_URL . 'files/css' ) );
define( 'WOO2APP_JS_URL', trailingslashit( WOO2APP_URL . 'files/js' ) );
define( 'WOO2APP_FILES_VER', "?ver=3.1.2" );
ini_set( 'display_errors', 0 );


class WOO2APP {
	public function __construct() {
		add_action( 'rest_api_init', array( $this, 'rest_api_init' ) );
		register_activation_hook( __FILE__, array( $this, 'config_woo2app' ) );
		add_action( 'init', array( $this, 'set_api_hami' ) );
		add_action( 'admin_menu', array( $this, 'config_woo2app_menu' ) );
		add_action( 'init', array( $this, 'config_woo2app_ajax' ) );
		add_action( 'init', array( $this, 'woo2app_metabox' ) );
		if ( get_locale() == 'fa_IR' ) {
			$mo_file = dirname( plugin_dir_path( __FILE__ ) ) . '/woo2app/languages/woo2app-fa_IR.mo';
			load_textdomain( 'woo2app', $mo_file );
		}
	}

	public function config_woo2app() {
		require_once WOO2APP_PATH . 'woo2app_config/config_table_woo2app.php';
		$woo = new config_table_woo2app();
		require_once WOO2APP_PATH . 'woo2app_config/config_table_data.php';
		$woo = new woo2app_config_data();
	}

	public function set_api_hami() {
		require_once WOO2APP_PATH . 'service/woocommerce_services_comment.php';
		$woo = new woocommerce_services_comment();
		require_once WOO2APP_PATH . 'service/api_users_hami.php';
		$user = new api_users_hami();//api_webservices_hami_user
		require_once WOO2APP_PATH . 'service/woocommerce_services_new.php';
		$woo = new woocommerce_services_new();
		require_once WOO2APP_PATH . 'service/woo2app_core_api_setting.php';
		$woo = new woo2app_core_api_setting();
		require_once WOO2APP_PATH . 'service/woo2app_core_api_orders.php';
		$order = new woo2app_core_api_orders();
		require_once WOO2APP_PATH . 'service/woo2app_core_api_customers.php';
		$woo = new woo2app_core_api_customers();
		require_once WOO2APP_PATH . 'service/woo2app_core_api_coupon.php';
		$woo = new woo2app_core_api_coupon();
		require_once WOO2APP_PATH . 'service/woo2app_core_api_pay_methods.php';
		$woo = new woo2app_core_api_pay_methods();
		require_once WOO2APP_PATH . 'service/woo2app_core_api_shipping_methods.php';
		$woo = new woo2app_core_api_shipping_methods();
		include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		if ( ! is_plugin_active( 'wp2appir/wp2appir.php' ) ) {
			//wp2app plugin is not activated
			require_once WOO2APP_PATH . 'service/woo2app_api_default_blog.php';
			$woo = new woo2app_api_default_blog();
			require_once WOO2APP_PATH . 'service/woo2app_api_primary_blog.php';
			$woo = new woo2app_api_primary_blog();
		}
		require_once WOO2APP_PATH . 'woo2app_config/mr2app_feed.php';
		$woo = new mr2app_feed();
		require_once WOO2APP_PATH . 'service/woo2app_google_sign_in.php';
		$woo = new woo2app_google_sign_in();

	}

	public function config_woo2app_menu() {
		include_once( 'woo2app_config/config_woo2app_menu.php' );
		$woo2app_config_menu = new woo2app_config_menu();
	}

	public function config_woo2app_ajax() {
		require_once WOO2APP_PATH . 'woo2app_design/config_woo2app_ajax.php';
	}

	public function woo2app_metabox() {
		include_once( 'woo2app_config/config_metabox_woo2app.php' );
		$woo2app_metabox_notif = new woo2app_metabox_notif();
	}

	public function rest_api_init() {
		include_once( WOO2APP_PATH . 'api/class-woo2app-rest-controller.php' );
	}
}

new WOO2APP();

register_activation_hook( __FILE__, 'activation_woo2app_custom_register' );
function activation_woo2app_custom_register() {
	$default_fields    = array();
	$default_fields [] = array( 'name' => 'user_login', 'title' => 'Username', 'order' => 1 );
	$default_fields [] = array( 'name' => 'user_email', 'title' => 'E-Mail', 'order' => 3 );
	$default_fields [] = array( 'name' => 'user_pass', 'title' => 'Password', 'order' => 4 );
	$default_fields [] = array( 'name' => 'user_url', 'title' => 'Site address', 'order' => 5 );
	$default_fields [] = array( 'name' => 'display_name', 'title' => 'Display name', 'order' => 6 );
	$default_fields [] = array( 'name' => 'first_name', 'title' => 'First Name', 'order' => 7 );
	$default_fields [] = array( 'name' => 'last_name', 'title' => 'Last name', 'order' => 8 );
	$default_fields [] = array( 'name' => 'description', 'title' => 'Description', 'order' => 9 );
	$default_fields [] = array( 'name' => 'billing_company', 'title' => 'Company', 'order' => 11 );
	$default_fields [] = array( 'name' => 'billing_address_1', 'title' => 'Address 1', 'order' => 12 );
	$default_fields [] = array( 'name' => 'billing_address_2', 'title' => 'Address 2', 'order' => 13 );
	$default_fields [] = array( 'name' => 'billing_city', 'title' => 'City', 'order' => 14 );
	$default_fields [] = array( 'name' => 'billing_state', 'title' => 'State', 'order' => 15 );
	$default_fields [] = array( 'name' => 'billing_postcode', 'title' => 'Postal code', 'order' => 16 );
	$default_fields [] = array( 'name' => 'billing_country', 'title' => 'Country', 'order' => 17 );
	$default_fields [] = array( 'name' => 'billing_email', 'title' => 'E-Mail', 'order' => 18 );
	$default_fields [] = array( 'name' => 'billing_phone', 'title' => 'Phone', 'order' => 19 );
	$default_fields [] = array( 'name' => 'my_invitor', 'title' => 'My recipe', 'order' => 20 );
	$default_fields [] = array( 'name' => 'my_invitecode', 'title' => 'My Reaction Code', 'order' => 21 );
	$default_fields [] = array( 'name' => 'my_score', 'title' => 'My rating', 'order' => 22 );
	$array_name_new    = array(
		'user_login',
		'user_email',
		'user_pass',
		'user_url',
		'display_name',
		'first_name',
		'last_name',
		'description',
		'billing_company',
		'billing_address_1',
		'billing_address_2',
		'billing_city',
		'billing_state',
		'billing_postcode',
		'billing_country',
		'billing_email',
		'billing_phone'
	,
		'my_invitor',
		'my_invitecode',
		'my_score'
	);
	$args              = array(
		'post_type'      => 'woo2app_register',
		'post_status'    => 'draft',
		'posts_per_page' => - 1,
		'orderby'        => 'menu_order',
		'order'          => 'ASC',
	);
	$disable           = array(
		'user_url',
		'display_name',
		'description',
		'billing_company',
		'billing_address_2',
		'billing_country',
		'billing_email',
		'my_invitecode',
		'my_invitor',
		'my_score'
	);
	$the_query         = get_posts( $args );
	$array_name_old    = array();
	foreach ( $the_query as $p ) {
		$array_name_old[] = $p->post_content;
	}
	$result = array_diff( $array_name_new, $array_name_old );
	foreach ( $default_fields as $f ) {
		if ( in_array( $f['name'], $result ) ) {
			$array = array(
				'post_title'   => $f['title'],
				'post_content' => $f['name'],
				'post_type'    => 'woo2app_register',
				'post_status'  => 'draft',
				'menu_order'   => $f['order'],
			);
			$post  = wp_insert_post( $array );
			if ( ! in_array( $f['name'], $disable ) ) {
				add_post_meta( $post, 'default', '' );
				add_post_meta( $post, 'required', 1 );
				add_post_meta( $post, 'active', 1 );
				add_post_meta( $post, 'display_edit', 1 );
				add_post_meta( $post, 'display_register', 1 );
				add_post_meta( $post, 'values', '' );
				add_post_meta( $post, 'type', 'text' );
				add_post_meta( $post, 'validate', 'general' );
			}
		}
	}
	$array = array(
		'enable'   => 0,
		'field'    => '',
		'panel'    => '',
		'number'   => '',
		'username' => '',
		'password' => ''
	);
	if ( ! get_option( 'mr2app_sms' ) ) {
		add_option( 'mr2app_sms', $array );
	}
}

function woo2app_tm_additional_profile_fields( $user ) {
	$default_fields = array(
		'user_login',
		'user_email',
		'user_pass',
		'user_url',
		'display_name',
		'first_name',
		'last_name',
		'description',
		'billing_company',
		'billing_address_1',
		'billing_address_2',
		'billing_city',
		'billing_state',
		'billing_postcode',
		'billing_country',
		'billing_email',
		'billing_phone'
	);
	$args           = array(
		'post_type'      => 'woo2app_register',
		'post_status'    => 'draft',
		'posts_per_page' => - 1,
		'orderby'        => 'menu_order',
		'order'          => 'ASC'
	);
	$the_query      = get_posts( $args );
	?>
    <table class="form-table">
        <script type="text/javascript"
                src="https://maps.googleapis.com/maps/api/js?key=AIzaSyB1grFb5dYPNOQ5FaDHMkZLmVz3s3OerbI"></script>
		<?php
		foreach ( $the_query as $f ) {
			if ( in_array( $f->post_content, $default_fields ) ) {
				continue;
			}
			$x = get_user_meta( $user->ID, $f->post_content, true );
			if ( get_post_meta( $f->ID, 'type', true ) == 'map' ) {
				$x = explode( ',', $x );
				if ( $x[0] ) {
					$lat = $x[0];
				} else {
					$lat = '32.2972692';
				}
				if ( $x[1] ) {
					$lng = $x[1];
				} else {
					$lng = '54.582283';
				}
				?>
                <tr>
                    <th><label>  <?= $f->post_title; ?></label></th>
                    <td>
                        <div id="map-canvas_<?= $f->ID; ?>" class="height-150 width-300"></div><!-- #map-canvas -->
                        <script type="text/javascript">
                            google.maps.event.addDomListener(window, 'load', gmaps_results_initialize);
                            var map;
                            var markers = [];

                            function gmaps_results_initialize() {
                                map = new google.maps.Map(document.getElementById('map-canvas_' + <?= $f->ID;?>), {
                                    zoom: 13,
                                    center: new google.maps.LatLng(<?= $lat;?>, <?= $lng;?>),
                                });
                                var marker = new google.maps.Marker({
                                    position: new google.maps.LatLng(<?= $lat;?>, <?= $lng;?>),
                                    map: map,
                                    animation: google.maps.Animation.BOUNCE
                                });
                            }
                        </script>
                    </td>
                </tr>
				<?php
			} else {
				?>
                <tr>
                    <th><label>  <?= $f->post_title; ?></label></th>
                    <td>
                        <input type="text" id="<?= $f->post_content; ?>" name="<?= $f->post_content; ?>"
                               class="regular-text" value="<?= $x; ?>">
                    </td>
                </tr>
				<?php
			}
		}
		?>
    </table>
	<?php
}

add_action( 'edit_user_profile', 'woo2app_tm_additional_profile_fields' );

// Hook is used to save custom fields that have been added to the WordPress profile page (if not current user)

add_action( 'edit_user_profile_update', 'woo2app_update_extra_profile_fields' );
function woo2app_update_extra_profile_fields( $user_id ) {
	if ( current_user_can( 'edit_user', $user_id ) ) {
		$default_fields = array(
			'user_login',
			'user_email',
			'user_pass',
			'user_url',
			'display_name',
			'first_name',
			'last_name',
			'description',
			'billing_company',
			'billing_address_1',
			'billing_address_2',
			'billing_city',
			'billing_state',
			'billing_postcode',
			'billing_country',
			'billing_email',
			'billing_phone'
		);
		$args           = array(
			'post_type'      => 'woo2app_register',
			'post_status'    => 'draft',
			'posts_per_page' => - 1,
			'orderby'        => 'menu_order',
			'order'          => 'ASC'
		);
		$the_query      = get_posts( $args );
		foreach ( $the_query as $f ) {
			update_user_meta( $user_id, $f->post_content, $_POST["$f->post_content"] );
		}
	}
}

require_once "register/class_custom_register.php";
$class_custom_register_woo2app = new class_custom_register();
require_once "service/mr2app_send_feedback.php";
$mr2app_send_feedback = new mr2app_send_feedback();

require_once "woo2app_vendor/class_vendors.php";
$woo2app_vendors = new class_vendors();

require_once "order_form/class_custom_order.php";
$class_custom_order = new class_custom_order();

require_once "category_time/category_time.php";

require_once "category/service_category.php";
$class_custom_order = new mr2app_custom_category();

require_once "filter/class_filter.php";
$mr2app_filter = new mr2app_filter();

require_once "inviter/class_inviter.php";
$inviter_woo2app = new class_inviter();

register_activation_hook( __FILE__, 'activation_mr2app_custom_order' );
function activation_mr2app_custom_order() {
	$default_fields    = array();
	$default_fields [] = array( 'name' => 'first_name', 'title' => 'First name', 'order' => 1 );
	$default_fields [] = array( 'name' => 'last_name', 'title' => 'Last name', 'order' => 2 );
	$default_fields [] = array( 'name' => 'address_1', 'title' => 'Address 1', 'order' => 3 );
	$default_fields [] = array( 'name' => 'address_2', 'title' => 'Address 2', 'order' => 4 );
	$default_fields [] = array( 'name' => 'city', 'title' => 'City', 'order' => 5 );
	$default_fields [] = array( 'name' => 'state', 'title' => 'State', 'order' => 6 );
	$default_fields [] = array( 'name' => 'postcode', 'title' => 'Postal code', 'order' => 7 );
	$default_fields [] = array( 'name' => 'country', 'title' => 'Country', 'order' => 8 );
	$default_fields [] = array( 'name' => 'email', 'title' => 'E-Mail', 'order' => 9 );
	$default_fields [] = array( 'name' => 'phone', 'title' => 'Phone', 'order' => 10 );
	$default_fields [] = array( 'name' => 'customer_note', 'title' => 'Customer descriptions', 'order' => 11 );
	$array_name_new    = array(
		'first_name',
		'last_name',
		'address_1',
		'address_2',
		'city',
		'state',
		'postcode',
		'country',
		'email',
		'phone',
		'customer_note'
	);
	$args              = array(
		'post_type'      => 'woo2app_order',
		'post_status'    => 'draft',
		'posts_per_page' => - 1,
		'orderby'        => 'menu_order',
		'order'          => 'ASC',
	);
	$the_query         = get_posts( $args );
	$array_name_old    = array();
	foreach ( $the_query as $p ) {
		$array_name_old[] = $p->post_content;
	}
	$result = array_diff( $array_name_new, $array_name_old );
	foreach ( $default_fields as $f ) {
		if ( in_array( $f['name'], $result ) ) {
			$array = array(
				'post_title'   => $f['title'],
				'post_content' => $f['name'],
				'post_type'    => 'woo2app_order',
				'post_status'  => 'draft',
				'menu_order'   => $f['order'],
			);
			$post  = wp_insert_post( $array );
			add_post_meta( $post, 'default', '' );
			add_post_meta( $post, 'required', 1 );
			add_post_meta( $post, 'active', 1 );
			add_post_meta( $post, 'display', 1 );
			add_post_meta( $post, 'values', '' );
			add_post_meta( $post, 'relation', '' );
			add_post_meta( $post, 'type', 'text' );
			add_post_meta( $post, 'validate', 'general' );
		}
	}

}

function woo2app_add_admin_css_js_everywhere( $hook ) {

	if ( 'plugins.php' === $hook ) {
		wp_enqueue_style( 'woo2app-modal', WOO2APP_URL . '/files/feedback/css/woo2app-modal.css', null, WOO2APP_VERSION );
		wp_enqueue_script( 'woo2app-modal', WOO2APP_URL . '/files/feedback/js/woo2app-modal.js', null, WOO2APP_VERSION, true );
		wp_localize_script( 'woo2app-modal', 'woo2app_ajax_data', array( 'nonce' => wp_create_nonce( 'woo2app-ajax' ) ) );
		echo generate();
	}
}

add_action( 'admin_enqueue_scripts', 'woo2app_add_admin_css_js_everywhere', 11 );


function generate() {

	$data = [
		'deactivation_url' => wp_nonce_url( 'plugins.php?action=deactivate&amp;plugin=' . rawurlencode( 'woo2app/woo2app.php' ), 'deactivate-plugin_woo2app/woo2app.php' ),
	];
	include "deactivate-form.php";

	return trim( ob_get_clean() );
}

function woo2app_direct_filesystem() {
	require_once ABSPATH . 'wp-admin/includes/class-wp-filesystem-base.php';
	require_once ABSPATH . 'wp-admin/includes/class-wp-filesystem-direct.php';

	return new WP_Filesystem_Direct( new StdClass() );
}


add_action( 'admin_init', 'register_woo2app_plugin_settings' );
function register_woo2app_plugin_settings() {
	//register our settings
	register_setting( 'woo2app_orderDetail-group', 'woo2app_orderDetail' );
	register_setting( 'woo2app_authentication-group', 'woo2app_authentication' );
	register_setting( 'woo2app_login-group', 'woo2app_loginPage' );
}


// define the woocommerce_order_status_changed callback
function action_woocommerce_order_status_changed( $order_id, $old_status, $new_status, $instance ) {
	//$arr = array($order_id, $old_status, $new_status, $instance);
	if ( $new_status == 'completed' ) {
		$inviter = get_option( 'woo2app_inviter_setting' );
		if ( is_array( $inviter ) && isset( $inviter['score_for_inviter_first_order'] ) && $inviter['score_for_inviter_first_order'] == true ) {
			$order = new WC_Order( $order_id );
			if ( (int) get_user_meta( $order->get_user_id(), 'score_for_inviter', true ) == 0 ) {
				//$order->get_user_id();
				$code_inviter = get_user_meta( $order->get_user_id(), 'my_invitor', true );
				if ( $code_inviter != "" || $code_inviter != null ) {
					set_score_inviter( $code_inviter, $order->get_user_id() );
				}
				update_user_meta( $order->get_user_id(), 'score_for_inviter', 1 );
				//update_option('test_order_status'  , $order->get_user_id());
			}
		}
	}
}

;

function set_score_inviter( $inviter, $ID ) {
	$user            = check_code( $inviter );
	$setting_inviter = get_option( 'woo2app_inviter_setting' );
	$counter         = $setting_inviter['score_for_inviter_first_order_value'];
	$type            = $setting_inviter['score_type'];
	if ( $type == 1 ) {
		$score = get_user_meta( $user->ID, 'my_score', true );
		$score = (int) $score + (int) $counter;
		update_user_meta( $user->ID, 'my_score', $score );
	} else if ( $type == 2 ) {
		include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		if ( is_plugin_active( 'woo-wallet/woo-wallet.php' ) ) {
			//plugin is activated
			$user1 = get_user_by( 'id', $ID );
			woo_wallet()->wallet->credit( $user->ID, (int) $counter, 'Charge Gift for first order: ' . $user1->user_login );
		}
	}
}

function check_code( $meta_value ) {
	$user_query = new WP_User_Query(
		array(
			'meta_key'   => 'my_invitecode',
			'meta_value' => $meta_value
		)
	);
	// Get the results from the query, returning the first user
	$users = $user_query->get_results();

	return $users[0];
}

// add the action
add_action( 'woocommerce_order_status_changed', 'action_woocommerce_order_status_changed', 10, 4 );


add_filter( 'woocommerce_account_menu_items', 'mr2app_one_more_link' );
function mr2app_one_more_link( $menu_links ) {
	$user = wp_get_current_user();
	if ( in_array( 'seller', (array) $user->roles ) || in_array( 'administrator', (array) $user->roles ) ) {
		//The user has the "author" role
		$new = array( 'woo2app-edit-info' => 'Store Info' );
		// array_slice() is good when you want to add an element between the other ones
		$menu_links = array_slice( $menu_links, 0, 5, true )
		              + $new
		              + array_slice( $menu_links, 5, null, true );
	}

	return $menu_links;
}

add_action( 'init', 'woo2app_add_endpoint' );
function woo2app_add_endpoint() {
	add_rewrite_endpoint( 'woo2app-edit-info', EP_PAGES );
}


add_action( 'woocommerce_account_woo2app-edit-info_endpoint', 'mr2app_my_account_endpoint_content' );
function mr2app_my_account_endpoint_content() {

	if ( isset( $_POST['sub_delete'] ) ) {
		$sore_info = get_user_meta( get_current_user_id(), 'woo2app_store_info', true );
		$s_x       = array();
		foreach ( $sore_info['slider'] as $slider ) {
			if ( $slider['sl_id'] == ( $_POST['slider_id'] ) ) {
				continue;
			}
			$s_x[] = $slider;
		}
		$sore_info['slider'] = $s_x;
		update_user_meta( get_current_user_id(), 'woo2app_store_info', $sore_info );
	}
	if ( isset( $_POST['sbm_save'] ) ) {

		$sore_info = get_user_meta( get_current_user_id(), 'woo2app_store_info', true );
		if ( ! is_array( $sore_info ) ) {
			$sore_info                              = array();
			$sore_info['woo2app_send_state']        = '';
			$sore_info['woo2app_description_state'] = '';
			$sore_info['lat']                       = '';
			$sore_info['lng']                       = '';
			$sore_info['slider']                    = array();
			update_user_meta( get_current_user_id(), 'woo2app_store_info', $sore_info );
		}
		$sore_info['woo2app_send_state']        = ( $_POST['woo2app_send_state'] );
		$sore_info['woo2app_description_state'] = ( $_POST['woo2app_description_state'] );
		$sore_info['lat']                       = $_POST['lat'];
		$sore_info['lng']                       = $_POST['lng'];
		if ( $_POST['select_action_banner'] != 0 && isset( $_FILES['woo2app_slider_src'] ) ) {
			if ( ! function_exists( 'wp_handle_upload' ) ) {
				require_once( ABSPATH . 'wp-admin/includes/file.php' );
			}

			$uploadedfile = ( $_FILES['woo2app_slider_src'] ); /***/

			$upload_overrides = array( 'test_form' => false );

			$movefile = wp_handle_upload( $uploadedfile, $upload_overrides );

			if ( $movefile && ! isset( $movefile['error'] ) ) {
				$pic   = $movefile['url'];
				$value = "";
				$title = ( $_POST['woo2app_slider_title'] );
				if ( $_POST['select_action_banner'] == 2 ) {
					$value = ( $_POST['woo2app_slider_cat'] );
				} elseif ( $_POST['select_action_banner'] == 3 ) {
					$value = esc_url_raw( $_POST['woo2app_slider_link'] );
				} elseif ( $_POST['select_action_banner'] == 5 ) {
					$value = esc_url_raw( $_POST['woo2app_slider_video'] );
				}
				$sore_info['slider'][] = array(
					'sl_id'  => uniqid(),
					'title'  => $title,
					'action' => ( $_POST['select_action_banner'] ),
					'value'  => $value,
					'pic'    => $pic
				);
			} else {
				echo $movefile['error'];
			}

		}
		update_user_meta( get_current_user_id(), 'woo2app_store_info', $sore_info );

	}

	$sore_info = get_user_meta( get_current_user_id(), 'woo2app_store_info', true );
	if ( ! is_array( $sore_info ) ) {
		$sore_info                              = array();
		$sore_info['woo2app_send_state']        = '';
		$sore_info['woo2app_description_state'] = '';
		$sore_info['lat']                       = '';
		$sore_info['lng']                       = '';
		$sore_info['woo2app_description_state'] = '';
		$sore_info['slider']                    = array();
		update_user_meta( get_current_user_id(), 'woo2app_store_info', $sore_info );

	}
	$lat = $sore_info['lat'];
	$lng = $sore_info['lng'];
	if ( $sore_info['lat'] == '' ) {
		$lat = 35.70163;
	}
	if ( $sore_info['lng'] == '' ) {
		$lng = 51.39211;
	}
	$args = array(
		'hide_empty' => 0,
		'taxonomy'   => 'product_cat'
	);
	$cats = get_categories( $args );
	?>
    <script src="https://addmap.parsijoo.ir/leaflet/leaflet.js"></script>
    <link rel="stylesheet" href="https://addmap.parsijoo.ir/leaflet/leaflet.css"/>
    <form action="" method="post" enctype="multipart/form-data">
		<?php wp_nonce_field( 'woo2app-admin', 'woo2app-admin' ); ?>
        <p class="form-row form-row-wide">
            <label for="woo2app_send_state" class="">
				<?php _e( 'Submitted areas', 'woo2app' ); ?>
            </label>
            <span class="woocommerce-input-wrapper">
                <input type="text" class="input-text " name="woo2app_send_state" id="woo2app_send_state" placeholder=""
                       value="<?= $sore_info['woo2app_send_state']; ?>" autocomplete="organization">
            </span>
        </p>
        <p class="form-row form-row-wide">
            <label for="woo2app_description_state" class="">
				<?php _e( 'Store Description', 'woo2app' ); ?>
            </label>
            <span class="woocommerce-input-wrapper">
                <textarea type="text" class="input-text" name="woo2app_description_state" id="woo2app_description_state"
                          placeholder=""
                          autocomplete="organization"><?= $sore_info['woo2app_description_state']; ?></textarea>
            </span>
        </p>
        <p class="form-row form-row-wide">
        <div id="map" class="width-100 height-300 margin-bottom-10"></div>
        <input type="hidden" class="regular-text" value="<?= $lat ?>" name="lat" id="lat"/>
        <input type="hidden" class="regular-text" value="<?= $lng ?>" name="lng" id="lng"/>
        </p>
        <hr>
        <h2>
            <strong><?php _e( 'Store Slider', 'woo2app' ); ?></strong>
        </h2>
        <p class="form-row form-row-wide">
            <label for="woo2app_description_state" class="">
				<?php _e( 'Title', 'woo2app' ); ?>
            </label>
            <span class="woocommerce-input-wrapper">
                <input type="text" class="input-text " name="woo2app_slider_title" id="woo2app_send_state"
                       placeholder="<?php _e( 'Title', 'woo2app' ); ?>" autocomplete="organization">
            </span>
        </p>
        <p class="form-row form-row-wide">
            <label for="woo2app_description_state" class="">
				<?php _e( 'Action', 'woo2app' ); ?>
            </label>
            <span class="woocommerce-input-wrapper">
                <select class="form-control" id="select_action_banner" name="select_action_banner" required="required">
                        <option value="0"><?php _e( 'Please Select ...', 'woo2app' ); ?></option>
                        <option value="2"><?php _e( 'Category', 'woo2app' ); ?></option>
                        <option value="3"><?php _e( 'Link', 'woo2app' ); ?></option>
                        <option value="5"> <?php _e( 'Video', 'woo2app' ); ?> </option>
                        <option value="4"> <?php _e( 'No Action', 'woo2app' ); ?></option>
                </select>
            </span>
        </p>
        <p class="form-row form-row-wide el_type display-none" id="el_cats">
            <label for="woo2app_description_state" class="">
				<?php _e( 'Category', 'woo2app' ); ?>
            </label>
            <span class="woocommerce-input-wrapper">
               <select class="form-control" name="woo2app_slider_cat" id="cat">
                        <?php
                        foreach ( $cats as $cat ) {
	                        ?>
                            <option value="<?= $cat->slug; ?>"><?= $cat->name; ?></option>
	                        <?php
                        }
                        ?>
               </select>
            </span>
        </p>
        <p class="form-row form-row-wide el_type display-none" id="el_link">
            <label for="woo2app_description_state" class="">
				<?php _e( 'Full link with http  *', 'woo2app' ); ?>
            </label>
            <span class="woocommerce-input-wrapper">
                <input type="text" class="input-text " name="woo2app_slider_link" id="woo2app_slider_link"
                       placeholder="<?php _e( 'Full link with http  *', 'woo2app' ); ?>" autocomplete="organization">
            </span>
        </p>
        <p class="form-row form-row-wide el_type display-none" id="el_video">
            <label for="woo2app_description_state" class="">
				<?php _e( 'Full video link with http  *', 'woo2app' ); ?>
            </label>
            <span class="woocommerce-input-wrapper">
                <input type="text" class="input-text " name="woo2app_slider_video" id="woo2app_slider_video"
                       placeholder="<?php _e( 'Full video link with http  *', 'woo2app' ); ?>  autocomplete="
                       organization">
            </span>
        </p>
        <p class="form-row form-row-wide">
            <label for="woo2app_description_state" class="">
				<?php _e( 'Photo link', 'woo2app' ); ?>
            </label>
            <span class="woocommerce-input-wrapper">
                <input type="file" class="input-text " name="woo2app_slider_src" id="woo2app_slider_src">
                <!--                <input type="text" class="input-text " name="woo2app_slider_src" id="woo2app_slider_src" placeholder=" لینک عکس"  autocomplete="organization">-->
            </span>
        </p>
        <input type="submit" name="sbm_save" value="<?php _e( 'Add & Save', 'woo2app' ); ?>"/>
    </form>
    <hr>
    <h2>
        <strong>     <?php _e( 'Store Slider List', 'woo2app' ); ?> </strong>
    </h2>
    <table class="form-table width-100">
        <thead>
        <tr>
            <th> <?php _e( 'Title', 'woo2app' ); ?> </th>
            <th><?php _e( 'Photo link', 'woo2app' ); ?></th>
            <th> ---</th>
        </tr>
        </thead>
        <tbody>
		<?php
		if ( ! $sore_info['slider'] ) {
			echo 'There is no item.';
		}
		foreach ( $sore_info['slider'] as $slider ) {
			?>
            <tr class="border-bottom-2px-solid" id="row_slider_<?= $slider['sl_id']; ?>">
                <td scope="row" class="titledesc">
                    <strong dir="rtl">    <?= esc_html( $slider['title'] ); ?> </strong>
                </td>
                <td class="">
                    <strong dir="rtl"> <a target="_blank"
                                          href="<?= esc_html( $slider['pic'] ); ?>">  <?php _e( 'Show Image', 'woo2app' ); ?> </a></strong>
                </td>
                <td class="">
                    <form action="" method="post">
						<?php wp_nonce_field( 'woo2app-admin', 'woo2app-admin' ); ?>
                        <input name="slider_id" type="hidden" value="<?= $slider['sl_id']; ?>">
                        <input type="submit" value="<?php _e( 'Delete', 'woo2app' ); ?>" name="sub_delete">
                    </form>
                </td>
            </tr>
			<?php
		}
		?>
        </tbody>
    </table>

    <script>
        jQuery('#select_action_banner').on('change', function () {
            var type_val = (jQuery('#select_action_banner').val());
            //alert(type_val)
            jQuery('.el_type').css('display', 'none');
            if (type_val == 5) {
                jQuery('#el_video').css('display', 'block');
            } else if (type_val == 2) {
                jQuery('#el_cats').css('display', 'block');
            } else if (type_val == 3) {
                jQuery('#el_link').css('display', 'block');
            }
        });
        var map = L.map('map').setView(['<?= $lat?>', '<?= $lng?>'], 12);
        L.tileLayer('https://developers.parsijoo.ir/web-service/v1/map/?type=tile&x={x}&y={y}&z={z}&apikey=efe3224bd92441a7abc28cffc591f2f4', {
            maxZoom: 17,
        }).addTo(map);

        var marker = L.marker(['<?= $lat?>', '<?= $lng?>']).addTo(map);
        map.on("click", function (e) {
            if (marker) { // check
                map.removeLayer(marker); // remove
            }
            jQuery("#lat").val(e.latlng.lat);
            jQuery("#lng").val(e.latlng.lng);
            marker = L.marker([e.latlng.lat, e.latlng.lng]).addTo(map);

        });
    </script>
	<?php
}

function add_default_slider() {
	global $wpdb;
	$table_name = $wpdb->prefix . "woo2app_slider";
	$wpdb->query( "DELETE FROM $table_name" );
	$queryScript = "INSERT INTO `$table_name` (`sl_id`, `sl_title`, `sl_type`, `sl_value`, `sl_pic`, `sl_sort`) VALUES
	(1, '', 3, '#SITE#', 'https://mr2app.com/document/uploaded/app-files/slider-1.gif\r\n', 100),
	(2, '', 4, '', 'https://mr2app.com/document/uploaded/app-files/slider-2.jpg', 100),
	(3, '', 4, '', 'https://mr2app.com/document/uploaded/app-files/slider-3.jpg', 100);";
	$wpdb->query( $queryScript );
}

function add_default_menu() {
	global $wpdb;
	$table_name = $wpdb->prefix . "woo2app_menu";
	$wpdb->query( "DELETE FROM $table_name" );

	$queryScript = "INSERT INTO `$table_name` (`menu_id`, `menu_title`, `menu_action`, `menu_value`, `menu_pic`, `menu_menu`, `menu_order`) VALUES
	(1, ' Separator ', 0, '', '', 1, 7),
	(3, 'درباره ما', 3, '#SITE#/about-us', 'https://mr2app.com/document/uploaded/app-files/ic-us.png', 1, 9),
	(4, 'سفارشات من', 4, '', 'https://mr2app.com/document/uploaded/app-files/ic-orders.png', 1, 4),
	(5, 'پرفروشترین محصولات', 5, 'orderby=selling&order=DESC', 'https://mr2app.com/document/uploaded/app-files/ic-best-seller.png', 1, 19),
	(6, 'جدیدترین محصولات', 5, 'orderby=date&order=DESC', 'https://mr2app.com/document/uploaded/app-files/ic-new.png', 1, 16),
	(7, 'جست و جو در محصولات', 7, '', 'https://mr2app.com/document/uploaded/app-files/ic-find.png', 1, 20),
	(8, 'ارسال فایل اپ', 8, '', 'https://mr2app.com/document/uploaded/app-files/ic-send-apk.png', 1, 13),
	(9, 'محصولات موردعلاقه من', 9, '', 'https://mr2app.com/document/uploaded/app-files/ic-fav.png', 1, 6),
	(10, 'دسته بندی محصولات', 10, '', 'https://mr2app.com/document/uploaded/app-files/ic-cats.png', 1, 18),
	(11, 'وبلاگ', 11, '', 'https://mr2app.com/document/uploaded/app-files/ic-blog.png', 1, 8),
	(12, 'رهگیری با کد سفارش', 15, '', 'https://mr2app.com/document/uploaded/app-files/ic-track.png', 1, 5),
	(13, 'تماس با پشتیبانی', 16, '+981111111', 'https://mr2app.com/document/uploaded/app-files/ic-call.png', 1, 11),
	(14, 'کیف پول من', 18, '', 'https://mr2app.com/document/uploaded/app-files/ic-wallet.png', 1, 3),
	(15, 'معرفی اپ و دریافت هدیه', 19, 'از شما دعوت میکنم که اپلیکیشن ما را نصب کنید و از خدمات آن بهرمند شوید.با ورود به لینک زیر میتوانید اپ را دانلود و نصب کنید.\n\n#SITE#/download-app\n\nلطفا هنگام ثبت نام کد معرف من [my_invitecode] را وارد کنید.', 'https://mr2app.com/document/uploaded/app-files/ic-gift.png', 1, 14),
	(16, 'پیام‌های من', 20, '', 'https://mr2app.com/document/uploaded/app-files/ic-inbox.png', 1, 1),
	(17, 'لیست فروشگاه‌ها (دکان)', 21, '', 'https://mr2app.com/document/uploaded/app-files/ic-dokan.png', 1, 22),
	(18, 'اطلاعات اپ', 22, 'لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.', 'https://mr2app.com/document/uploaded/app-files/ic-about.png', 1, 10),
	(19, 'بارکدخوان محصولات', 23, '', 'https://mr2app.com/document/uploaded/app-files/ic-qr.png', 1, 17),
	(20, 'تغییر فروشگاه (چند دامنه‌ای)', 24, '', 'https://mr2app.com/document/uploaded/app-files/ic-domain.png', 1, 23),
	(21, 'فایل‌های من', 25, '', 'https://mr2app.com/document/uploaded/app-files/ic-files.png', 1, 2),
	(22, ' Separator ', 0, '', '', 1, 15),
	(23, ' Separator ', 0, '', '', 1, 21),
	(25, ' Separator ', 0, '', '', 1, 12);";
	$wpdb->query( $queryScript );

}

function add_default_mainpage() {
	global $wpdb;
	$table_name = $wpdb->prefix . "woo2app_mainpage";
	$wpdb->query( "DELETE FROM $table_name" );
	$queryScript = "INSERT INTO `$table_name` (`mp_id`, `mp_title`, `mp_type`, `mp_value`, `mp_showtype`, `mp_pic`, `mp_order`, `mp_sort`) VALUES
	(302, 'لوکس', 2, '{\\\"value\\\":\\\"\\\",\\\"count_load\\\":\\\"4\\\"}', 1008, '', 18, 'orderby=selling&order=DESC'),
	(300, 'محبوب‌ترین', 2, '{\\\"value\\\":\\\"\\\",\\\"count_load\\\":\\\"9\\\"}', 1006, '', 16, 'orderby=popularity&order=DESC'),
	(301, 'ترند‌ها', 2, '{\\\"value\\\":\\\"\\\",\\\"count_load\\\":\\\"3\\\"}', 1007, '', 17, 'orderby=price&order=DESC'),
	(295, 'وبلاگ', 2, '', 2003, '', 10, ''),
	(296, 'وبلاگ', 2, '', 2004, '', 11, ''),
	(297, 'پرفروش‌‌ها', 2, '{\\\"value\\\":\\\"\\\",\\\"count_load\\\":\\\"5\\\"}', 1002, '', 13, 'orderby=selling&order=DESC'),
	(298, 'بیشترین تخفیف', 2, '{\\\"value\\\":\\\"\\\",\\\"count_load\\\":\\\"6\\\"}', 1004, 'http://demo.wp2app.ir/woo1/wp-content/uploads/2021/01/b6c724a0.png', 14, 'orderby=price&order=ASC'),
	(299, 'جدیدترین', 2, '{\\\"value\\\":\\\"\\\",\\\"count_load\\\":\\\"9\\\"}', 1005, '', 15, 'orderby=date&order=DESC'),
	(303, 'ارزان‌ترین', 2, '{\\\"value\\\":\\\"\\\",\\\"count_load\\\":\\\"3\\\"}', 1009, '', 19, 'orderby=price&order=ASC'),
	(304, 'لیست لغزان (بدون تصویر)', 0, '{\"title\":\"\\u0644\\u06cc\\u0633\\u062a \\u0644\\u063a\\u0632\\u0627\\u0646 (\\u0628\\u062f\\u0648\\u0646 \\u062a\\u0635\\u0648\\u06cc\\u0631)\",\"mode\":\"4001\",\"btn_color\":\"137179\",\"text_color\":\"FBFBFB\",\"items\":[{\"title\":\"درباره ما\",\"type\":\"link\",\"val\":\"https:\\/\\/google.com\",\"img\":\"\"},{\"title\":\"تماس با ما\",\"type\":\"link\",\"val\":\"https:\\/\\/google.com\",\"img\":\"\"},{\"title\":\"آموزش خرید از فروشگاه\",\"type\":\"link\",\"val\":\"https:\\/\\/google.com\",\"img\":\"\"},{\"title\":\"محصولات ورزشی\",\"type\":\"category\",\"val\":\"\",\"img\":\"\"},{\"title\":\"محصولات آرایشی\",\"type\":\"category\",\"val\":\"\",\"img\":\"\"},{\"title\":\"محصولات آموزشی\",\"type\":\"category\",\"val\":\"\",\"img\":\"\"}]}', 4001, '', 21, '100'),
	(305, 'لیست لغزان (تصویر چپ)', 0, '{\"title\":\"\\u0644\\u06cc\\u0633\\u062a \\u0644\\u063a\\u0632\\u0627\\u0646 (\\u062a\\u0635\\u0648\\u06cc\\u0631 \\u0686\\u067e)\",\"mode\":\"4002\",\"btn_color\":\"431254\",\"text_color\":\"FFFFFF\",\"items\":[{\"title\":\"سلامتی\",\"type\":\"category\",\"val\":\"\",\"img\":\"http:\\/\\/demo.wp2app.ir\\/woo1\\/wp-content\\/uploads\\/2020\\/08\\/077-job-search.png\"},{\"title\":\"ورزشی\",\"type\":\"category\",\"val\":\"\",\"img\":\"http:\\/\\/demo.wp2app.ir\\/woo1\\/wp-content\\/uploads\\/2020\\/08\\/093-idea.png\"},{\"title\":\"سوپری\",\"type\":\"category\",\"val\":\"\",\"img\":\"http:\\/\\/demo.wp2app.ir\\/woo1\\/wp-content\\/uploads\\/2020\\/08\\/049-mail.png\"},{\"title\":\"گجت هوشمند\",\"type\":\"category\",\"val\":\"\",\"img\":\"http:\\/\\/demo.wp2app.ir\\/woo1\\/wp-content\\/uploads\\/2020\\/08\\/081-checked.png\"},{\"title\":\"الکترونیک\",\"type\":\"category\",\"val\":\"\",\"img\":\"http:\\/\\/demo.wp2app.ir\\/woo1\\/wp-content\\/uploads\\/2020\\/08\\/078-internet.png\"}]}', 4002, '', 22, '100'),
	(306, 'لیست لغزان فقط تصویر', 0, '{\"title\":\"\\u0644\\u06cc\\u0633\\u062a \\u0644\\u063a\\u0632\\u0627\\u0646 \\u0641\\u0642\\u0637 \\u062a\\u0635\\u0648\\u06cc\\u0631\",\"mode\":\"4003\",\"btn_color\":\"F5363E\",\"text_color\":\"EEEEEE\",\"items\":[{\"title\":\"\",\"type\":\"category\",\"val\":\"\",\"img\":\"http:\\/\\/demo.wp2app.ir\\/woo1\\/wp-content\\/uploads\\/2021\\/02\\/brand-logo8.jpg\"},{\"title\":\"\",\"type\":\"category\",\"val\":\"\",\"img\":\"http:\\/\\/demo.wp2app.ir\\/woo1\\/wp-content\\/uploads\\/2021\\/02\\/brand-logo7.jpg\"},{\"title\":\"\",\"type\":\"category\",\"val\":\"\",\"img\":\"http:\\/\\/demo.wp2app.ir\\/woo1\\/wp-content\\/uploads\\/2021\\/02\\/brand-logo6.jpg\"},{\"title\":\"\",\"type\":\"category\",\"val\":\"\",\"img\":\"http:\\/\\/demo.wp2app.ir\\/woo1\\/wp-content\\/uploads\\/2021\\/02\\/brand-logo5.jpg\"},{\"title\":\"\",\"type\":\"category\",\"val\":\"\",\"img\":\"http:\\/\\/demo.wp2app.ir\\/woo1\\/wp-content\\/uploads\\/2021\\/02\\/brand-logo1.jpg\"},{\"title\":\"\",\"type\":\"category\",\"val\":\"\",\"img\":\"http:\\/\\/demo.wp2app.ir\\/woo1\\/wp-content\\/uploads\\/2021\\/02\\/brand-logo2.jpg\"}]}', 4003, '', 23, '100'),
	(307, 'لیست لغزان (تصویر بالا)', 0, '{\"title\":\"\\u0644\\u06cc\\u0633\\u062a \\u0644\\u063a\\u0632\\u0627\\u0646 (\\u062a\\u0635\\u0648\\u06cc\\u0631 \\u0628\\u0627\\u0644\\u0627)\",\"mode\":\"4004\",\"btn_color\":\"FFFFFF\",\"text_color\":\"767676\",\"items\":[{\"title\":\"آرایشی\",\"type\":\"category\",\"val\":\"\",\"img\":\"http:\\/\\/demo.wp2app.ir\\/woo1\\/wp-content\\/uploads\\/2018\\/07\\/dascsvfs-e1602500286836.jpg\"},{\"title\":\"سوپری\",\"type\":\"category\",\"val\":\"\",\"img\":\"http:\\/\\/demo.wp2app.ir\\/woo1\\/wp-content\\/uploads\\/2018\\/07\\/fsdf-e1604677249910.jpg\"},{\"title\":\"شامپو\",\"type\":\"category\",\"val\":\"\",\"img\":\"http:\\/\\/demo.wp2app.ir\\/woo1\\/wp-content\\/uploads\\/2018\\/07\\/csdad-e1604677071114.jpg\"},{\"title\":\"مبلمان\",\"type\":\"category\",\"val\":\"\",\"img\":\"http:\\/\\/demo.wp2app.ir\\/woo1\\/wp-content\\/uploads\\/2018\\/07\\/Untitled-1-3-e1604677166760.jpg\"}]}', 4004, '', 24, '100'),
	(310, '* انواع لیست لغزان با قابلیت اتصال به محصولات برچسب ها و لینک', 0, '{\"title\":\"* \\u0627\\u0646\\u0648\\u0627\\u0639 \\u0644\\u06cc\\u0633\\u062a \\u0644\\u063a\\u0632\\u0627\\u0646 \\u0628\\u0627 \\u0642\\u0627\\u0628\\u0644\\u06cc\\u062a \\u0627\\u062a\\u0635\\u0627\\u0644 \\u0628\\u0647 \\u0645\\u062d\\u0635\\u0648\\u0644\\u0627\\u062a \\u0628\\u0631\\u0686\\u0633\\u0628 \\u0647\\u0627 \\u0648 \\u0644\\u06cc\\u0646\\u06a9\",\"mode\":\"4001\",\"btn_color\":\"F5363E\",\"text_color\":\"EEEEEE\",\"items\":[{\"title\":\"* انواع لیست لغزان با قابلیت اتصال به محصولات برچسب ها و لینک\",\"type\":\"link\",\"val\":\"\",\"img\":\"\"}]}', 4001, '', 20, '100'),
	(311, '* انواع لیست محصولات با قابلیت لینک به دسته بندی برچسب‌ها محصولات دلخواه و مرتب سازی بر اساس قیمت جد', 0, '{\"title\":\"* \\u0627\\u0646\\u0648\\u0627\\u0639 \\u0644\\u06cc\\u0633\\u062a \\u0645\\u062d\\u0635\\u0648\\u0644\\u0627\\u062a \\u0628\\u0627 \\u0642\\u0627\\u0628\\u0644\\u06cc\\u062a \\u0644\\u06cc\\u0646\\u06a9 \\u0628\\u0647 \\u062f\\u0633\\u062a\\u0647 \\u0628\\u0646\\u062f\\u06cc \\u0628\\u0631\\u0686\\u0633\\u0628\\u200c\\u0647\\u0627 \\u0645\\u062d\\u0635\\u0648\\u0644\\u0627\\u062a \\u062f\\u0644\\u062e\\u0648\\u0627\\u0647 \\u0648 \\u0645\\u0631\\u062a\\u0628 \\u0633\\u0627\\u0632\\u06cc \\u0628\\u0631 \\u0627\\u0633\\u0627\\u0633 \\u0642\\u06cc\\u0645\\u062a \\u062c\\u062f\\u06cc\\u062f\\u062a\\u0631\\u06cc\\u0646 \\u0648 ...\",\"mode\":\"4001\",\"btn_color\":\"F5363E\",\"text_color\":\"EEEEEE\",\"items\":[{\"title\":\"* انواع لیست محصولات با قابلیت لینک به دسته بندی برچسب‌ها محصولات دلخواه و مرتب سازی بر اساس قیمت جدیدترین و ...\",\"type\":\"link\",\"val\":\"\",\"img\":\"\"}]}', 4001, '', 12, '100'),
	(312, '* انواع لیست پست‌های وردپرس', 0, '{\"title\":\"* \\u0627\\u0646\\u0648\\u0627\\u0639 \\u0644\\u06cc\\u0633\\u062a \\u067e\\u0633\\u062a\\u200c\\u0647\\u0627\\u06cc \\u0648\\u0631\\u062f\\u067e\\u0631\\u0633\",\"mode\":\"4001\",\"btn_color\":\"F5363E\",\"text_color\":\"EEEEEE\",\"items\":[{\"title\":\"* انواع لیست پست‌های وردپرس\",\"type\":\"link\",\"val\":\"\",\"img\":\"\"}]}', 4001, '', 9, '100'),	
	(313, '* انواع بنر‌های مختلف ثابت و متحرک (GIF)', 0, '{\"title\":\"* \\u0627\\u0646\\u0648\\u0627\\u0639 \\u0628\\u0646\\u0631\\u200c\\u0647\\u0627\\u06cc \\u0645\\u062e\\u062a\\u0644\\u0641 \\u062b\\u0627\\u0628\\u062a \\u0648 \\u0645\\u062a\\u062d\\u0631\\u06a9 (GIF)\",\"mode\":\"4001\",\"btn_color\":\"F5363E\",\"text_color\":\"EEEEEE\",\"items\":[{\"title\":\"* انواع بنر‌های مختلف ثابت و متحرک (GIF)\",\"type\":\"link\",\"val\":\"\",\"img\":\"\"}]}', 4001, '', 25, '100'),	
	(318, 'بنر سه تایی | راست', 0, '{\"banner4\":[{\"title\":\"\",\"type\":\"6\",\"value\":\"\",\"pic\":\"http:\\/\\/demo.wp2app.ir\\/woo1\\/wp-content\\/uploads\\/2018\\/07\\/1-15.jpg\"},{\"title\":\"\",\"type\":\"6\",\"value\":\"\",\"pic\":\"http:\\/\\/demo.wp2app.ir\\/woo1\\/wp-content\\/uploads\\/2018\\/07\\/new-6.jpg\"},{\"title\":\"\",\"type\":\"6\",\"value\":\"\",\"pic\":\"http:\\/\\/demo.wp2app.ir\\/woo1\\/wp-content\\/uploads\\/2018\\/07\\/3-6.jpg\"}],\"height\":\"100\"}', 6, '', 32, '100'),
	(315, 'بنر تکی', 6, '{\"banner1\":[{\"title\":\"\",\"type\":\"6\",\"value\":\"\",\"pic\":\"http:\\/\\/demo.wp2app.ir\\/woo1\\/wp-content\\/uploads\\/2018\\/07\\/b3x1.jpg\"}],\"height\":\"\"}', 1, 'http://demo.wp2app.ir/woo1/wp-content/uploads/2018/07/b3x1.jpg', 27, '100'),
	(316, 'بنر تکی', 6, '{\"banner1\":[{\"title\":\"\",\"type\":\"6\",\"value\":\"\",\"pic\":\"http:\\/\\/demo.wp2app.ir\\/woo1\\/wp-content\\/uploads\\/2018\\/07\\/sl1.jpg\"}],\"height\":\"50\"}', 1, 'http://demo.wp2app.ir/woo1/wp-content/uploads/2018/07/sl1.jpg', 28, '100'),
	(317, 'بنر دو تایی', 0, '{\"banner2\":[{\"title\":\"\",\"type\":\"6\",\"value\":\"\",\"pic\":\"http:\\/\\/demo.wp2app.ir\\/woo1\\/wp-content\\/uploads\\/2018\\/07\\/new-6.jpg\"},{\"title\":\"\",\"type\":\"6\",\"value\":\"\",\"pic\":\"http:\\/\\/demo.wp2app.ir\\/woo1\\/wp-content\\/uploads\\/2018\\/07\\/hyper-4.jpg\"}],\"height\":\"50\"}', 8, '', 30, '100'),
	(319, 'بنر سه تایی | کنار هم', 0, '{\"banner4\":[{\"title\":\"\",\"type\":\"6\",\"value\":\"\",\"pic\":\"http:\\/\\/demo.wp2app.ir\\/woo1\\/wp-content\\/uploads\\/2018\\/07\\/3-5.jpg\"},{\"title\":\"\",\"type\":\"6\",\"value\":\"\",\"pic\":\"http:\\/\\/demo.wp2app.ir\\/woo1\\/wp-content\\/uploads\\/2018\\/07\\/2-5.jpg\"},{\"title\":\"\",\"type\":\"6\",\"value\":\"\",\"pic\":\"http:\\/\\/demo.wp2app.ir\\/woo1\\/wp-content\\/uploads\\/2018\\/07\\/new-8.jpg\"}],\"height\":\"33\"}', 66, '', 33, '100'),
	(320, 'بنر 4 تایی | دوتا دوتا زیر هم', 0, '{\"banner4\":[{\"title\":\"\",\"type\":\"6\",\"value\":\"\",\"pic\":\"http:\\/\\/demo.wp2app.ir\\/woo1\\/wp-content\\/uploads\\/2018\\/07\\/new-8.jpg\"},{\"title\":\"\",\"type\":\"6\",\"value\":\"\",\"pic\":\"http:\\/\\/demo.wp2app.ir\\/woo1\\/wp-content\\/uploads\\/2018\\/07\\/new-6.jpg\"},{\"title\":\"\",\"type\":\"6\",\"value\":\"\",\"pic\":\"http:\\/\\/demo.wp2app.ir\\/woo1\\/wp-content\\/uploads\\/2018\\/07\\/hyper-4.jpg\"},{\"title\":\"\",\"type\":\"6\",\"value\":\"\",\"pic\":\"http:\\/\\/demo.wp2app.ir\\/woo1\\/wp-content\\/uploads\\/2018\\/07\\/2-5.jpg\"}],\"height\":\"100\"}', 4, '', 35, '100'),
	(321, 'بنر 4 تایی | کنار هم', 0, '{\"banner4\":[{\"title\":\"\",\"type\":\"6\",\"value\":\"\",\"pic\":\"http:\\/\\/demo.wp2app.ir\\/woo1\\/wp-content\\/uploads\\/2018\\/07\\/3-5.jpg\"},{\"title\":\"\",\"type\":\"6\",\"value\":\"\",\"pic\":\"http:\\/\\/demo.wp2app.ir\\/woo1\\/wp-content\\/uploads\\/2018\\/07\\/2-5.jpg\"},{\"title\":\"\",\"type\":\"6\",\"value\":\"\",\"pic\":\"http:\\/\\/demo.wp2app.ir\\/woo1\\/wp-content\\/uploads\\/2018\\/07\\/3-6.jpg\"},{\"title\":\"\",\"type\":\"6\",\"value\":\"\",\"pic\":\"http:\\/\\/demo.wp2app.ir\\/woo1\\/wp-content\\/uploads\\/2018\\/07\\/new-6.jpg\"}],\"height\":\"25\"}', 44, '', 36, '100'),	
	(327, '* صفحه اصلی (همین صفحه) و دیگر تنظیمات نمایشی را میتوانید از طریق پلاگین در داشبورد وردپرس تغییر دهی', 0, '{\"title\":\"* \\u0635\\u0641\\u062d\\u0647 \\u0627\\u0635\\u0644\\u06cc (\\u0647\\u0645\\u06cc\\u0646 \\u0635\\u0641\\u062d\\u0647) \\u0648 \\u062f\\u06cc\\u06af\\u0631 \\u062a\\u0646\\u0638\\u06cc\\u0645\\u0627\\u062a \\u0646\\u0645\\u0627\\u06cc\\u0634\\u06cc \\u0631\\u0627 \\u0645\\u06cc\\u062a\\u0648\\u0627\\u0646\\u06cc\\u062f \\u0627\\u0632 \\u0637\\u0631\\u06cc\\u0642 \\u067e\\u0644\\u0627\\u06af\\u06cc\\u0646 \\u062f\\u0631 \\u062f\\u0627\\u0634\\u0628\\u0648\\u0631\\u062f \\u0648\\u0631\\u062f\\u067e\\u0631\\u0633 \\u062a\\u063a\\u06cc\\u06cc\\u0631 \\u062f\\u0647\\u06cc\\u062f.\",\"mode\":\"4001\",\"btn_color\":\"F5363E\",\"text_color\":\"EEEEEE\",\"items\":[{\"title\":\"* صفحه اصلی (همین صفحه) و دیگر تنظیمات نمایشی را میتوانید از طریق پلاگین در داشبورد وردپرس تغییر دهید\",\"type\":\"category\",\"val\":\"\",\"img\":\"\"}]}', 4001, '', 8, '100'),	
	(323, '* بنر‌تکی با ارتفاع متغیر', 0, '{\"title\":\"* \\u0628\\u0646\\u0631\\u200c\\u062a\\u06a9\\u06cc \\u0628\\u0627 \\u0627\\u0631\\u062a\\u0641\\u0627\\u0639 \\u0645\\u062a\\u063a\\u06cc\\u0631\",\"mode\":\"4001\",\"btn_color\":\"F5363E\",\"text_color\":\"EEEEEE\",\"items\":[{\"title\":\"* بنر‌تکی با ارتفاع متغیر\",\"type\":\"link\",\"val\":\"\",\"img\":\"\"}]}', 4001, '', 26, '100'),	
	(324, '* بنر دو تایی با ارتفاع متغیر', 0, '{\"title\":\"* \\u0628\\u0646\\u0631 \\u062f\\u0648 \\u062a\\u0627\\u06cc\\u06cc \\u0628\\u0627 \\u0627\\u0631\\u062a\\u0641\\u0627\\u0639 \\u0645\\u062a\\u063a\\u06cc\\u0631\",\"mode\":\"4001\",\"btn_color\":\"F5363E\",\"text_color\":\"EEEEEE\",\"items\":[{\"title\":\"* بنر دو تایی با ارتفاع متغیر\",\"type\":\"link\",\"val\":\"\",\"img\":\"\"}]}', 4001, '', 29, '100'),	
	(325, '* بنر سه تایی با ارتفاع متغیر و حالات متفاوت', 0, '{\"title\":\"* \\u0628\\u0646\\u0631 \\u0633\\u0647 \\u062a\\u0627\\u06cc\\u06cc \\u0628\\u0627 \\u0627\\u0631\\u062a\\u0641\\u0627\\u0639 \\u0645\\u062a\\u063a\\u06cc\\u0631 \\u0648 \\u062d\\u0627\\u0644\\u0627\\u062a \\u0645\\u062a\\u0641\\u0627\\u0648\\u062a\",\"mode\":\"4001\",\"btn_color\":\"F5363E\",\"text_color\":\"EEEEEE\",\"items\":[{\"title\":\"* بنر سه تایی با ارتفاع متغیر و حالات متفاوت\",\"type\":\"category\",\"val\":\"\",\"img\":\"\"}]}', 4001, '', 31, '100'),	
	(326, '* بنر چهار تایی با ارتفاع متغیر و حالات متفاوت', 0, '{\"title\":\"* \\u0628\\u0646\\u0631 \\u0686\\u0647\\u0627\\u0631 \\u062a\\u0627\\u06cc\\u06cc \\u0628\\u0627 \\u0627\\u0631\\u062a\\u0641\\u0627\\u0639 \\u0645\\u062a\\u063a\\u06cc\\u0631 \\u0648 \\u062d\\u0627\\u0644\\u0627\\u062a \\u0645\\u062a\\u0641\\u0627\\u0648\\u062a\",\"mode\":\"4001\",\"btn_color\":\"F5363E\",\"text_color\":\"EEEEEE\",\"items\":[{\"title\":\"* بنر چهار تایی با ارتفاع متغیر و حالات متفاوت\",\"type\":\"link\",\"val\":\"\",\"img\":\"\"}]}', 4001, '', 34, '100');
	";
	$wpdb->query( $queryScript );
}

function send_notif( $description, $action, $value ) {
	$app_id  = get_option( 'app_id' );
	$api_id  = get_option( 'api_id' );

	$fields = array(
		'app_ids'            => [$app_id],
		'data'              => array(
			'title'  => get_option( 'blogname' ),
			'contents'  => $description,
            "custom_content" => [
	            "action" => $action,
	            'value'  => $value,
	            'title'  => get_option( 'blogname' ),
	            'contents'  => $description,
	            'time'   => time()
            ],
		),
	);
//echo '<pre>';
//	var_dump( $fields );
//	die();
	// initialize curl
	$ch = curl_init("https://api.push-pole.com/v2/messaging/notifications/");

// set header parameters
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		"Content-Type: application/json",
		"Accept: application/json",
		"Authorization: Token " . $api_id,
	));
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

// set data
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));

	return $response = curl_exec($ch);
//echo '<pre>';
//    var_dump($response);die();
// report url only generated on Non-Free plan
//	$hashed_id = json_decode($response)->hashed_id;

//	print_r($hashed_id);

//	curl_close($ch);
}

function send_notif_mr2app( $title, $action, $value ) {

	$oneAppID = get_option( 'app_id' );
	$oneAPIID = get_option( 'api_id' );
	$data     = array(
		"title"  => $title,
		"action" => $action,
		"value"  => $value
	);
	$data     = json_encode( $data );
	$data     = array( "data" => $data );
	$ch       = curl_init();
	$title    = urlencode( $title );
	curl_setopt( $ch, CURLOPT_URL, "http://panel.wp2app.ir/panel/api/send_notification2all2?one_app_id=$oneAppID&one_api_id=$oneAPIID&title=$title" );
	curl_setopt( $ch, CURLOPT_HTTPHEADER, array(
		"Content-Type:multipart/form-data"
	) );
	curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, 0 );
	curl_setopt( $ch, CURLOPT_SSL_VERIFYHOST, 0 );
	curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
	curl_setopt( $ch, CURLOPT_POST, true );
	curl_setopt( $ch, CURLOPT_POSTFIELDS, $data );
	$response = curl_exec( $ch );
	curl_close( $ch );
	var_dump( $response );

	return $response;
}

// add_filter('woocommerce_thankyou_order_received_text', 'backPay_change_order_received_text', 10, 2 );
// function backPay_change_order_received_text( $str, $order ) {
// 	$app_order = get_post_meta($order->id , 'bool_woo_order_type' , true);
// 	if($app_order == 1){
// 		$setting = get_option('woo2app_primary_setting');
// 		if(isset($setting['primary_setting']['app_success_back']) && !empty($setting['primary_setting']['app_success_back'])){
// 			WC()->session->destroy_session();
// 			wp_redirect(get_permalink($setting['primary_setting']['app_success_back']));
// 		}
// 	}
// }

// function backPay_template_redirect() {
// 	session_start();
// 	$setting = get_option('woo2app_primary_setting');
// 	$post_id = $setting['primary_setting']['app_fault_back']; //specify post id here
// 	$post = get_post($post_id);
// 	$slug = $post->post_name;
// 	if (is_checkout()) {
// 		if ( !is_wc_endpoint_url( 'order-pay' ) && !is_wc_endpoint_url( 'order-received' ) ) {
// 			if(WC()->session->get( 'order_app' )){
// 				$setting = get_option('woo2app_primary_setting');
// 				if(isset($setting['primary_setting']['app_fault_back']) && !empty($setting['primary_setting']['app_fault_back'])){
// 					wp_redirect(get_permalink($setting['primary_setting']['app_fault_back']));
// 				}
// 			}
// 		}
// 	}
// 	else if(is_page($slug) && $post){
// 		 WC()->session->forget_session();
// 	}
// }
// add_action('template_redirect', 'backPay_template_redirect');

function secondsToTime( $seconds ) {
	$dtF = new \DateTime( '@0' );
	$dtT = new \DateTime( "@$seconds" );

	return $dtF->diff( $dtT )->format( '%a days, %h hours, %i minutes and %s seconds' );
}

function formatSeconds( $seconds ) {
	$hours        = 0;
	$milliseconds = str_replace( "0.", '', $seconds - floor( $seconds ) );

	if ( $seconds > 3600 ) {
		$hours = floor( $seconds / 3600 );
	}
	$seconds = $seconds % 3600;


	return str_pad( $hours, 2, '0', STR_PAD_LEFT )
	       . gmdate( ':i:s', $seconds )
	       . ( $milliseconds ? ".$milliseconds" : '' );
}

function woo2app_get_role() {
	$setting = get_option( 'mr2app_register_form' );
	if ( isset( $setting['registered_role'] ) && $setting['registered_role'] ) {
		return $setting['registered_role'];
	}

	return 'customer';
}
/*add_filter('posts_clauses', 'order_by_stock_status');
function order_by_stock_status($posts_clauses) {
	global $wpdb;
	if ( get_option("order_by_stock_status")) {
		$posts_clauses['join'] .= " INNER JOIN $wpdb->postmeta istockstatus ON ($wpdb->posts.ID = istockstatus.post_id) ";
		$posts_clauses['orderby'] = " istockstatus.meta_value ASC, " . $posts_clauses['orderby'];
		$posts_clauses['where'] = " AND istockstatus.meta_key = '_stock_status' AND istockstatus.meta_value <> '' " . $posts_clauses['where'];
	}
	return $posts_clauses;
}
*/

