<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class woo2app_config_data{

	public function __construct() {
		$this->insert_into_woo2app_set();
		$this->default_desgin();
	}

	private function default_desgin(){
		if(!get_option('woo2app_DefaultDesign')){
			add_option("woo2app_DefaultDesign",0);
			global $wpdb;
			$table_name = $wpdb->prefix . "woo2app_slider";
			$slider = $wpdb->get_var("SELECT COUNT(*) FROM $table_name");
			$table_name = $wpdb->prefix . "woo2app_menu";
			$menu = $wpdb->get_var("SELECT COUNT(*) FROM $table_name");
			$table_name = $wpdb->prefix . "woo2app_mainpage";
			$mainPage = $wpdb->get_var("SELECT COUNT(*) FROM $table_name");
			if($slider == 0 && $menu == 0 && $mainPage == 0){
				update_option("woo2app_DefaultDesign",1);
				update_option("NUM_MENU1_POS", '1' );
				update_option("NUM_MENU1_account", '1' );
				update_option("NUM_MENU3_POS", '0' );
				update_option("NUM_MENU3_account", '0' );
				add_default_slider();
				add_default_menu();
				add_default_mainpage();
			}
		}
	}
	private function insert_into_woo2app_set(){

		//**************general****************************************

		if(!get_option('URL_SPLASH_PIC')) add_option("URL_SPLASH_PIC","0"); //adress photo splash
		if(!get_option('NUM_SPLASH_DELAY'))	add_option("NUM_SPLASH_DELAY","0");//delay splash
		if(!get_option('NUM_MENU1_POS'))	add_option("NUM_MENU1_POS","-1");//position menu1
		if(!get_option('NUM_MENU2_POS'))	add_option("NUM_MENU2_POS","-1");//position menu2
		if(!get_option('SHOW_BTN_CATLST'))	add_option("SHOW_BTN_CATLST","0");//position menu2
		//*********primary setting***************************
		if(!get_option('DEFAULT_BROWSER_IN'))	add_option("DEFAULT_BROWSER_IN" , "YES");
		if(!get_option('DEFAULT_FONT_APP'))	add_option("DEFAULT_FONT_APP" , 1);
		if(!get_option('DEFAULT_PRODUCT_CELL'))	add_option("DEFAULT_PRODUCT_CELL" , 1);
		if(!get_option('DEFAULT_UNIT_APP'))	add_option("DEFAULT_UNIT_APP" , "تومان");
		if(!get_option('DEFAULT_VER_APP'))	add_option("DEFAULT_VER_APP" , 1);
		if(!get_option('DEFAULT_LNK_APP'))	add_option("DEFAULT_LNK_APP" , "");
		if(!get_option('minimum_purchase_amount'))	add_option("minimum_purchase_amount" , 0);
		if(!get_option('category_them'))	add_option("category_them" , 1);
		if(!get_option('category_select_btn'))	add_option("category_select_btn" , 1);
		if(!get_option('BUY_WITH_LOGIN'))	add_option("BUY_WITH_LOGIN" , false);
		if(!get_option('ENTER_WITH_LOGIN'))	add_option("ENTER_WITH_LOGIN" , false);
		if(!get_option('display_btn_share'))	add_option("display_btn_share" , false);
		if(!get_option('NAVIGATION_BUTTON'))	add_option("NAVIGATION_BUTTON" , 0);

	}

}