<!--اکشن بار-->
<?php
if (!defined( 'ABSPATH' )) exit;
wp_register_style('font-awesome', 'https://use.fontawesome.com/releases/v5.8.2/css/all.css');
wp_enqueue_style( 'font-awesome');

require_once 'icons_div.php';

if(isset($_POST['woo2app-admin']) && wp_verify_nonce($_POST['woo2app-admin'], 'woo2app-admin') && isset($_POST['submit_actionBar'])) {
	$array = array(
		'post_title' => ($_POST['title']),
		'post_content' => ($_POST['value']),
		'post_type' => ($_POST['position']),
		'post_status'   => 'draft',
		'menu_order' => 100,
	);

	if($post = wp_insert_post( $array )){
		add_post_meta($post, 'type', ($_POST['type']));
		$action = array(
			'type' => ($_POST['action']),
			'value' => 'no_value'
		);
		add_post_meta($post,'action', $action);
		wp_redirect("admin.php?page=woo2app/woo2app_design/woo2app_show_design.php&tab=6");

	}
}
if (isset($_POST['woo2app-admin']) && wp_verify_nonce($_POST['woo2app-admin'], 'woo2app-admin') && isset($_REQUEST['actionBar_right_ids'])) {
	$ids = ($_POST['actionBar_right_ids']);
	$i = 0;
	foreach ($ids as $id){
		$i++;
		$array = array(
			'ID'            => $id,
			'menu_order'    => $i,
		);
		wp_update_post($array);
	}
}
if (isset($_POST['woo2app-admin']) && wp_verify_nonce($_POST['woo2app-admin'], 'woo2app-admin') && isset($_REQUEST['actionBar_left_ids'])) {
	$ids = ($_POST['actionBar_left_ids']);
	$i = 0;
	foreach ($ids as $id){
		$i++;
		$array = array(
			'ID'            => $id,
			'menu_order'    => $i,
		);
		wp_update_post($array);
	}
}
if (isset($_POST['woo2app-admin']) && wp_verify_nonce($_POST['woo2app-admin'], 'woo2app-admin') && isset($_REQUEST['actionBar_center_ids'])) {
	$ids = ($_POST['actionBar_center_ids']);
	$i = 0;
	foreach ($ids as $id){
		$i++;
		$array = array(
			'ID'            => $id,
			'menu_order'    => $i,
		);
		wp_update_post($array);
	}
}
?>
<div class="div_mainpage">
    <h3 class="background-color-e5e5e5 padding-7px">
		<?php _e('Action Bar', 'woo2app'); ?>
    </h3>
    <p>
		<?php _e('Add image, text, button and icon to the action bar.', 'woo2app'); ?>
    </p>
    <hr>

    <div class="col-md-4 pull-right text-right">
        <form action="" id="form-list-right" method="post">
			<?php wp_nonce_field('woo2app-admin', 'woo2app-admin'); ?>
            <div class="panel panel-default">
                <div class="panel-heading"> <?php _e('Right', 'woo2app'); ?> </div>
                <ul id="right_actionbar" class="list-group">
					<?php
					$args = array(
						'post_type'   => 'actionbar_right',
						'post_status' => 'draft',
						'posts_per_page' => -1,
						'orderby' => 'menu_order',
						'order' => 'ASC'
					);
					$the_query = get_posts( $args );
					foreach ($the_query as $f) {
						# code...
						?>
                        <li class="list-group-item" id="li_<?= $f->ID?>">
                            <input type="hidden" name="actionBar_right_ids[]" value="<?= $f->ID; ?>">
							<?= $f->post_title;?>
                            <span class="icon_minus pull-left" onclick="delete_actionBar('<?= $f->ID; ?>')"
                                  data-placement="right" data-toggle="tooltip"
                                  title="<?php _e('Remove', 'woo2app'); ?>">
                                    <img class="width-16px height-16px"
                                         src="<?= WP_PLUGIN_URL . "/" . dirname(plugin_basename(__FILE__)) . "/../files/img/minus.png" ?>">
                            </span>
                            <span class="icon_minus pull-left hide margin-left-3px font-size-8px gray"
                                  id="loading_<?= $f->ID; ?>">
                                    <img class="width-20px height-20px"
                                         src="<?= WP_PLUGIN_URL . "/" . dirname(plugin_basename(__FILE__)) . "/../files/img/load.gif" ?>">
                            </span>
                        </li>
						<?php
					}
					?>
                </ul>
                <div class="panel-footer">
                    <span class="icon_plus" onclick="add_item_actionBar('right')" data-placement="right"
                          data-toggle="tooltip" title="<?php _e('Add', 'woo2app'); ?>">
                        <img class="width-16px height-16px"
                             src="<?= WP_PLUGIN_URL . "/" . dirname(plugin_basename(__FILE__)) . "/../files/img/add.png" ?>">
                    </span>
                    <span class="icon_sort pull-left" id="sort_right" data-placement="right" data-toggle="tooltip"
                          title="<?php _e('Sort', 'woo2app'); ?>">
                        <img class="width-16px height-16px"
                             src="<?= WP_PLUGIN_URL . "/" . dirname(plugin_basename(__FILE__)) . "/../files/img/sort.png" ?>">
                    </span>
                </div>
            </div>
        </form>
    </div>
    <div class="col-md-4 pull-right">
        <form action="" id="form-list-center" method="post">
			<?php wp_nonce_field('woo2app-admin', 'woo2app-admin'); ?>
            <div class="panel panel-default">
                <div class="panel-heading text-center"> <?php _e('center', 'woo2app'); ?> </div>
                <ul id="center_actionbar" class="list-group">
					<?php
					$args = array(
						'post_type'   => 'actionbar_center',
						'post_status' => 'draft',
						'posts_per_page' => -1,
						'orderby' => 'menu_order',
						'order' => 'ASC'
					);
					$the_query = get_posts( $args );
					foreach ($the_query as $f) {
						# code...
						?>
                        <li class="list-group-item" id="li_<?= $f->ID?>">
                            <input type="hidden" name="actionBar_center_ids[]" value="<?= $f->ID; ?>">
							<?= $f->post_title;?>
                            <span class="icon_minus pull-left" onclick="delete_actionBar('<?= $f->ID; ?>')"
                                  data-placement="right" data-toggle="tooltip"
                                  title="<?php _e('Remove', 'woo2app'); ?>">
                                <img class="width-16px height-16px"
                                     src="<?= WP_PLUGIN_URL . "/" . dirname(plugin_basename(__FILE__)) . "/../files/img/minus.png" ?>">
                            </span>
                            <span class="icon_minus hide" id="loading_<?= $f->ID; ?>"
                                  style=margin-left:3px;font-size:8px;color:gray;">
                                <img class="width-20px height-20px"
                                     src="<?= WP_PLUGIN_URL . "/" . dirname(plugin_basename(__FILE__)) . "/../files/img/load.gif" ?>">
                            </span>
                        </li>
						<?php
					}
					?>
                </ul>
                <div class="panel-footer text-right">
                    <span class="icon_plus" onclick="add_item_actionBar('center')" data-placement="right"
                          data-toggle="tooltip" title="<?php _e('Add', 'woo2app'); ?>">
                        <img class="width-16px height-16px"
                             src="<?= WP_PLUGIN_URL . "/" . dirname(plugin_basename(__FILE__)) . "/../files/img/add.png" ?>">
                    </span>
                    <span class="icon_sort pull-left" id="sort_center" data-placement="right" data-toggle="tooltip"
                          title="<?php _e('Sort', 'woo2app'); ?>">
                        <img class="width-16px height-16px"
                             src="<?= WP_PLUGIN_URL . "/" . dirname(plugin_basename(__FILE__)) . "/../files/img/sort.png" ?>">
                    </span>
                </div>
            </div>
        </form>
    </div>
    <div class="col-md-4 pull-right">
        <form action="" id="form-list-left" method="post">
			<?php wp_nonce_field('woo2app-admin', 'woo2app-admin'); ?>
            <div class="panel panel-default">
                <div class="panel-heading text-left"> <?php _e('Left', 'woo2app'); ?> </div>
                <ul id="left_actionbar" class="list-group">
					<?php
					$args = array(
						'post_type'   => 'actionbar_left',
						'post_status' => 'draft',
						'posts_per_page' => -1,
						'orderby' => 'menu_order',
						'order' => 'ASC'
					);
					$the_query = get_posts( $args );
					foreach ($the_query as $f) {
						# code...
						?>
                        <li class="list-group-item" id="li_<?= $f->ID?>">
                            <input type="hidden" name="actionBar_left_ids[]" value="<?= $f->ID; ?>">
							<?= $f->post_title;?>
                            <span class="icon_minus pull-left" onclick="delete_actionBar('<?= $f->ID; ?>')"
                                  data-placement="right" data-toggle="tooltip"
                                  title="<?php _e('Remove', 'woo2app'); ?>">
                                <img class="width-16px height-16px"
                                     src="<?= WP_PLUGIN_URL . "/" . dirname(plugin_basename(__FILE__)) . "/../files/img/minus.png" ?>">
                            </span>
                            <span class="icon_minus pull-left hide margin-left-3px font-size-8px gray"
                                  id="loading_<?= $f->ID; ?>">
                                <img class="width-20px height-20px"
                                     src="<?= WP_PLUGIN_URL . "/" . dirname(plugin_basename(__FILE__)) . "/../files/img/load.gif" ?>">
                            </span>
                        </li>
						<?php
					}
					?>
                </ul>
                <div class="panel-footer text-right">
                    <span class="icon_plus" onclick="add_item_actionBar('left')" data-placement="right"
                          data-toggle="tooltip" title="<?php _e('Add', 'woo2app'); ?>">
                        <img class="width-16px height-16px"
                             src="<?= WP_PLUGIN_URL . "/" . dirname(plugin_basename(__FILE__)) . "/../files/img/add.png" ?>">
                        </i></span>
                    <span class="icon_sort pull-left" id="sort_left" data-placement="right" data-toggle="tooltip"
                          title="<?php _e('Sort', 'woo2app'); ?>">
                        <img class="width-16px height-16px"
                             src="<?= WP_PLUGIN_URL . "/" . dirname(plugin_basename(__FILE__)) . "/../files/img/sort.png" ?>">
                    </span>
                </div>
            </div>
        </form>
    </div>
</div>

<?php add_thickbox(); ?>
<div id="modal-window-id" style="display: none">
    <div id="font-awesome-list">
		<?php
		woo2app_icons();
		?>
    </div>
</div>
<!-- Modal -->
<div id="myModal" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <!-- Modal content-->
        <div class="modal-content">
            <form action="" method="post">
				<?php wp_nonce_field('woo2app-admin', 'woo2app-admin'); ?>
                <div class="modal-header">
                    <button type="button" class="close <?= get_locale() == 'fa_IR' ? 'pull-left' : 'pull-right' ?>"
                            data-dismiss="modal">&times;
                    </button>
                    <h4 class="modal-title <?= get_locale() == 'fa_IR' ? 'text-right' : '' ?>"> <?php _e('New Item', 'woo2app'); ?></h4>
                </div>
                <div class="modal-body">
                    <table class="form-table">
                        <tr>
                            <th>
								<?php _e('Position', 'woo2app'); ?>
                            </th>
                            <td>
                                <select name="position" id="position"  class="regular-text">
                                    <option value="actionBar_right"> <?php _e('Right', 'woo2app'); ?> </option>
                                    <option value="actionBar_center"> <?php _e('Center ', 'woo2app'); ?></option>
                                    <option value="actionBar_left"> <?php _e('Left', 'woo2app'); ?> </option>
                                </select>
                            </td>
                        </tr>
                        <tr>
                            <th>
								<?php _e('Name', 'woo2app'); ?>
                            </th>
                            <td>
                                <input type="text" required="required" name="title" class="regular-text" />
                                <p> <?php _e('This name only visible in dashboard', 'woo2app'); ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th>
								<?php _e('Type Item', 'woo2app'); ?>
                            </th>
                            <td>
                                <span class="float-right margin-left-10px">
                                    <?php _e('Image', 'woo2app'); ?>
                                    <input type="radio" value="image" checked class="" name="type"/>
                                </span>
                                <span class="float-right margin-left-10px">
                                    <?php _e('Button', 'woo2app'); ?>
                                    <input type="radio" value="button" class=""   name="type"/>
                                </span>
                                <span class="float-right margin-left-10px">
                                    <?php _e('Text', 'woo2app'); ?>
                                    <input type="radio" value="text" class=""   name="type"/>
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <button id="btn_pic_value"
                                        class="button button-primary for_hide"> <?php _e('Select Image', 'woo2app'); ?></button>
                                <a id="btn_icon_value"
                                   href="#TB_inline?width=700&height=500&inlineId=modal-window-id"
                                   class="for_hide hide thickbox"> <?php _e('Select Icon', 'woo2app'); ?> </a>
                            </th>
                            <td>
                                <input type="text" id="txt_value" required="required"
                                       class="regular-text "
                                       name="value"
                            </td>
                        </tr>
                        <tr>
                            <th>
			                    <?php _e('Action', 'woo2app'); ?>
                            </th>
                            <td>
                                <select name="action"  class="regular-text">
                                    <option value="none"><?php _e('No Action', 'woo2app'); ?></option>
                                    <option value="open_right_menu"> <?php _e('Open right Menu', 'woo2app'); ?>  </option>
                                    <option value="open_left_menu"> <?php _e('Open Left Menu', 'woo2app'); ?> </option>
                                    <option value="open_product_search"> <?php _e('Open Product Search', 'woo2app'); ?> </option>
                                    <option value="open_basket"> <?php _e('Open Cart', 'woo2app'); ?> </option>
                                </select>
                            </td>
                        </tr>
                    </table>
                </div>
                <div class="modal-footer">
                    <button type="submit" name="submit_actionBar"
                            class="button button-primary"> <?php _e('Save', 'woo2app'); ?></button>
                    <button type="button" class="button button-default"
                            data-dismiss="modal"> <?php _e('Close', 'woo2app'); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php
wp_enqueue_media();
wp_enqueue_script( 'custom.min.js'.WOO2APP_FILES_VER , WOO2APP_JS_URL.'custom.min.js', array('jquery'));
?>
<script>
    jQuery(document).ready(function(){
        jQuery('#sort_right').click(function(){
            jQuery("#form-list-right").submit();
        });
        jQuery('#sort_center').click(function(){
            jQuery("#form-list-center").submit();
        });
        jQuery('#sort_left').click(function(){
            jQuery("#form-list-left").submit();
        });
    })
    var custom_uploader_hami;
    jQuery('#btn_pic_value').click(function (e) {
        e.preventDefault();
        custom_uploader_hami = wp.media.frames.custom_uploader_hami = wp.media({
            title: '<?php _e('Select Image', 'woo2app')?>',
            library: {type: 'image'},
            button: {text: '<?php _e('Select', 'woo2app'); ?>'},
            multiple: false
        });
        custom_uploader_hami.on('select', function() {
            attachment = custom_uploader_hami.state().get('selection').first().toJSON();
            jQuery('#txt_value').val(attachment.url);
            //url_image = attachment.url;
            //jQuery('#div_image_item_hami').attr("src",url_image);
        });
        custom_uploader_hami.open();
    })

    function add_item_actionBar(pos){
        if(pos == 'right') jQuery('#position').val('actionBar_right');
        else if(pos == 'center') jQuery('#position').val('actionBar_center');
        else if(pos == 'left') jQuery('#position').val('actionBar_left');
        jQuery('#myModal').modal('show');
    }
    jQuery(function() {
        jQuery( "#left_actionbar" ).sortable();
        jQuery( "#left_actionbar" ).disableSelection();

        jQuery( "#center_actionbar" ).sortable();
        jQuery( "#center_actionbar" ).disableSelection();

        jQuery( "#right_actionbar" ).sortable();
        jQuery( "#right_actionbar" ).disableSelection();

        // tooltip
        jQuery('[data-toggle="tooltip"]').tooltip();
    });

    jQuery('input[type=radio][name=type]').change(function() {
        if (this.value == 'image') {
            jQuery('.for_hide').addClass('hide');
            jQuery('#btn_pic_value').removeClass('hide');
        }
        else if (this.value == 'button') {
            jQuery('.for_hide').addClass('hide');
            jQuery('#btn_icon_value').removeClass('hide');
        }
        else if (this.value == 'text') {
            jQuery('.for_hide').addClass('hide');
            jQuery('#txt_text_value').removeClass('hide');
        }
    });

    function delete_actionBar(id){
        if(confirm("Are you sure you want to delete the item?")){
            jQuery("#loading_" + id).removeClass('hide')
            jQuery.ajax({
                url: ajaxurl,
                data: {
                    action: "delete_actionbar",
                    post_id: id
                },
                success:function(data) {
                    data = data.substring(0,data.length -1);
                    if(data == 1){
                        jQuery("#li_" + id).fadeOut();
                    }
                    //console.log(data);
                }
            });
        }
    }
    let str;
    jQuery("#font-awesome-list div i").click(function () {
        str = jQuery(this).attr('data-content');
        jQuery("#txt_value").val(str);
        jQuery(".tb-close-icon").click();

    });
    jQuery("#font-awesome-list div span").click(function () {
        jQuery("#txt_value").val(jQuery(this).attr('data-content'));
        jQuery(".tb-close-icon").click();
    })
</script>