<?php

	$appid = get_option('app_id');
	$api_id = get_option('api_id');
	if ( $appid != "" ) {
		$url  = "http://panel.wp2app.ir/panel/api/get_notification_os?one_app_id=".$appid."&one_api_id=".$api_id;
		$arg = array(
			'method' => 'GET',
			'timeout' => 45,
			'redirection' => 5,
			'sslverify' => FALSE
		);
		$response = wp_remote_post( $url, $arg );
		$r        = json_decode( $response['body'], true );
		//var_dump($r);
	}

?>

<h2 class="background-color-e5e5e5 padding-7px">
	<?php _e('Last 50 Messages', 'woo2app'); ?>
    -
    <small class="green">
		<?php _e('Total Count' , 'woo2app');?>
		<?= $r['total_count'] ; ?>
		<?php _e('Messages' , 'woo2app');?>
    </small>
</h2>
<table class="wp-list-table widefat fixed striped ">
    <thead>
    <tr>
        <th>  # </th>
        <th>  <?php _e('Title' , 'woo2app') ; ?> </th>
        <th>  <?php _e('Type' , 'woo2app') ; ?> </th>
        <th>  <?php _e('Value' , 'woo2app') ; ?> </th>
        <th>  <?php _e('Recipients' , 'woo2app') ; ?> </th>
        <th>  <?php _e('Date / Time' , 'woo2app') ; ?> </th>
    </tr>
    </thead>
    <tbody>
	<?php
	$i = 0;
	foreach ($r['notifications'] as $notif){
		$i++;
		?>
        <tr>
            <td>  <?= $i ?> </td>
            <td>  <?= $notif['contents']['en']?> </td>
            <th>
				<?php
				if($notif['data']['action'] == 1){
					_e('Link' , 'woo2app') ;
				}
                elseif($notif['data']['action'] == 2){
					_e('Products' , 'woo2app') ;
				}
                elseif($notif['data']['action'] == 3){
					_e('Products Category' , 'woo2app') ;
				}
                elseif($notif['data']['action'] == 4){
					_e('Post' , 'woo2app') ;
				}
                elseif($notif['data']['action'] == 5){
					_e('Post Category' , 'woo2app') ;
				}
				?>
            </th>
            <td>  <?= $notif['data']['value'] ?> </td>
            <td>
				<?php
				if($notif['isAndroid']){
					echo 'Android : ';
					echo (int) $notif['platform_delivery_stats']['android']['successful'] ;
					echo ' Recipients';
					echo '<br>';
				}
				if($notif['isIos']){
					echo 'IOS : ';
					echo (int) $notif['platform_delivery_stats']['ios']['successful'] ;
					echo ' Recipients';
				}
				?>
            </td>
            <td>
				<?php
				if($notif['data']['time']){
					if ( function_exists( 'jdate' ) ) {
						echo jdate( 'Y/m/d - h:i', $notif['data']['time'] );
					} else {
						echo date( 'Y/m/d - h:i', $notif['data']['time'] );
					}
				}
				else{
					echo 'In Valid';
				}
				?>
            </td>
        </tr>
		<?php
	}
	?>
    </tbody>
</table>
