<?php

if (!defined( 'ABSPATH' )) exit;

$default = 0;
if(isset($_POST["select_default"])){
	if($_POST["select_default"] == 1){
		$color = get_option('woo2app_color_setting');
		if(!is_array($color)){
			$color = array();
		}
		$default = 1;
		require_once  "configColor.php";
	}
}
elseif (isset($_POST['woo2app-admin']) && wp_verify_nonce($_POST['woo2app-admin'], 'woo2app-admin')) {
    if(is_array($_POST['color'])){
	    update_option('woo2app_color_setting' , $_POST['color']);
    }
}
else{
	$color = get_option('woo2app_color_setting');
	if(!is_array($color)){
		$color = array();
	}
	require_once  "configColor.php";
}


$color = get_option('woo2app_color_setting');
?>

<div class="div_mainpage">
    <form method="post">
        <table class="form-table width-450px">
            <tr>
                <td>
                    <select class="regular-text" id="select_default" name="select_default">
                        <option value="" disabled
                                selected><?php _e('Choose color themes', 'woo2app'); ?></option>
                        <option value="1"><?php _e('Default color scheme ', 'woo2app'); ?></option>
                    </select>
                </td>
                <td>
                    <button type="submit" id="btn_default_color"
                            class="button button-primary"> <?php _e('Change', 'woo2app'); ?></button>
                </td>
            </tr>
        </table>
    </form>

    <form action="" method="post">
		<?php wp_nonce_field('woo2app-admin', 'woo2app-admin'); ?>
		<?php
        $i = 0;
		foreach ($color as $key => $value){
			?>
            <h4 class="background-color-e5e5e5 padding-7px">
				<?php
				if($key == 'general_setting') {
					_e( 'General', 'woo2app');
				}
                elseif($key == 'amazing_suggestion') {
					_e('Amazing Suggestion', 'woo2app');
				}
                elseif($key == 'main_page') {
					_e('Home Page', 'woo2app');
				}
                elseif($key == 'shopping_cart_page') {
					_e('Cart Page', 'woo2app');
				}
                elseif($key == 'product_page') {
					_e('Product Page', 'woo2app');
				}
                elseif($key == 'order_description_page') {
					_e('Order Detail Page', 'woo2app');
				}
                elseif($key == 'order_page') {
					_e('Order Page', 'woo2app');
				}
                elseif($key == 'register_page') {
					_e('Register Page', 'woo2app');
				}
                elseif($key == 'edit_user_page') {
					_e('Edit User Page', 'woo2app');
				}
                elseif($key == 'login_page') {
					_e('Login Page', 'woo2app');
				}
                elseif($key == 'change_pass_page') {
					_e('Change Password Page', 'woo2app');
				}
                elseif($key == 'forget') {
					_e('Forget Password Page', 'woo2app');
				}
				?>
            </h4>
            <table class="form-table width-600px">
                <tbody>
				<?php
				foreach ($value as $key1 => $value1){
				    $i++;
					?>
                    <tr>
                        <td class="width-450px">
							<?php _e($value1['title'], 'woo2app'); ?>
                        </td>
                        <td>
                            <input type="hidden" name="color[<?= $key; ?>][<?= $key1; ?>][title]" value="<?= $value1['title'] ?>">
                            <input type="color" onchange="change_color('<?= $key; ?>' , '<?= $key1; ?>' , this , '<?= $i ;?>')" name="color[<?= $key; ?>][<?= $key1; ?>][value]" value="<?= $value1['value'] ?>">
                            <img id="img_load_<?= $i;?>" class="hide width-height-25px"
                                 src="<?php echo WP_PLUGIN_URL . "/" . dirname(plugin_basename(__FILE__)) . '/../files/img/load.gif' ?>">
                        </td>
                    </tr>
					<?php
				}
				?>
                </tbody>
            </table>
			<?php
		}
		?>
    </form>

</div>

<script>
    function change_color(sec , index , e , id){
        //console.log(sec + '-' + index + '-' + e.value);
        jQuery("#img_load_"+id).removeClass('hide');
        jQuery.ajax({
            url: ajaxurl,
            data: {
                action: "change_color",
                sec : sec,
                index : index ,
                value : e.value
            },
            success:function(data) {
                jQuery("#img_load_"+id).addClass("hide");
            }
        });
    }
</script>