<?php
if (!defined( 'ABSPATH' )) exit;
wp_register_style( 'woo2app_style', WOO2APP_CSS_URL.'woo2app_style.css'  );
wp_enqueue_style( 'woo2app_style'.WOO2APP_FILES_VER );
if(get_locale() == 'fa_IR'){
	wp_register_style('myfont', WOO2APP_CSS_URL . 'font.css');
	wp_enqueue_style( 'myfont'.WOO2APP_FILES_VER);
}
wp_register_style('select2.min.css', WOO2APP_CSS_URL . 'select2.min.css');
wp_enqueue_style('select2.min.css'.WOO2APP_FILES_VER);
wp_enqueue_script('select2.min.js'.WOO2APP_FILES_VER, WOO2APP_JS_URL . 'select2.min.js');
$current_url="//".$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];

if(isset($_GET["sub_tab"]))
	$sub_tab = $_GET["sub_tab"];
else
	$sub_tab = "rightmenu";
?>
<label id="error_title" class="hide"> <?= _e('Please enter title.' , 'woo2app') ?></label>
<label id="title_separator" class="hide"> <?= _e('Separator ' , 'woo2app') ?></label>
<nav class="nav-tab-wrapper woo-nav-tab-wrapper">
    <a href="<?= $current_url.'&sub_tab=rightmenu' ?>" class="nav-tab <?= ($sub_tab == 'rightmenu') ? 'nav-tab-active' : ''; ?>">
		<?php _e('Right Menu', 'woo2app'); ?>
    </a>
    <a href="<?= $current_url.'&sub_tab=leftmenu' ?>" class="nav-tab <?= ($sub_tab == 'leftmenu') ? 'nav-tab-active' : ''; ?>">
		<?php _e('Left Menu', 'woo2app'); ?>
    </a>
    <a href="<?= $current_url.'&sub_tab=floatingmenu' ?>" class="nav-tab <?= ($sub_tab == 'floatingmenu') ? 'nav-tab-active' : ''; ?>">
		<?php _e('Floating Menu', 'woo2app'); ?>
    </a>
</nav>

<div class="div_mainpage1">
	<?php
	if($sub_tab == 'rightmenu'){
		?>
        <h4 class="background-color-e5e5e5 padding-7px">
			<?php _e('Setting', 'woo2app'); ?>
        </h4>
        <table class="form-table width-600px">
            <tr>
                <th>
					<?php _e('Right Menu', 'woo2app'); ?>
                </th>
                <td>
                    <img id="img_change_menu1" class="hide width-height-25px"
                         src="<?php echo WP_PLUGIN_URL . "/" . dirname(plugin_basename(__FILE__)) . '/../files/img/load.gif' ?>">
                    <select class="regular-text" id="select_position_menu1">
                        <option <?php echo (get_option("NUM_MENU1_POS") == -1) ? "selected" : ""; ?>
                                value="-1"><?php _e('Hide', 'woo2app'); ?></option>
                        <option <?php echo (get_option("NUM_MENU1_POS") == 1) ? "selected" : ""; ?>
                                value="1"> <?php _e('Show', 'woo2app'); ?></option>
                    </select>
                </td>
            </tr>
            <tr>
                <?php
                $display_mode_1 = get_option('App_display_menu_mode_1');
                ?>
                <th>
			        <?php _e('Mode', 'woo2app'); ?>
                </th>
                <td>
                    <img id="img_change_mode_menu1" class="hide width-height-25px"
                         src="<?php echo WP_PLUGIN_URL . "/" . dirname(plugin_basename(__FILE__)) . '/../files/img/load.gif' ?>">
                    <select class="regular-text" id="select_mode_menu1" onchange="change_mode(this , 1)">
                        <option value="5001" <?= selected($display_mode_1 , '5001' )?> > <?= _e('Simple' , 'woo2app'); ?></option>
                        <option value="5002" <?= selected($display_mode_1 , '5002' )?> > <?= _e('Fullscreen' , 'woo2app'); ?></option>
                        <option value="5003" <?= selected($display_mode_1 , '5003' )?> > <?= _e('Minimal' , 'woo2app'); ?></option>
                    </select>
                </td>
            </tr>
            <tr>
                <th>
                    <label>
				        <?php _e('Preview', 'woo2app'); ?>
                    </label>
                </th>
                <td>
                    <img id="img_cat_mode_5001"  style="height: 350px" class="img_cat_prev_mode <?= ($display_mode_1 == '5001') ? '' : 'hide'?>" src="<?= WOO2APP_URL .'/files/img/Menu/menu-1.jpg'?>" />
                    <img id="img_cat_mode_5002"  style="height: 350px" class="img_cat_prev_mode <?= ($display_mode_1 == '5002') ? '' : 'hide'?>" src="<?= WOO2APP_URL .'/files/img/Menu/menu-2.jpg'?>" />
                    <img id="img_cat_mode_5003" style="height: 350px" class="img_cat_prev_mode <?= ($display_mode_1 == '5003') ? '' : 'hide'?>" src="<?= WOO2APP_URL .'/files/img/Menu/menu-3.jpg'?>" />
                </td>
            </tr>
            <tr>
                <th>
					<?php _e('Header', 'woo2app'); ?>
                </th>
                <td >
                    <img id="img_account_menu1" class="hide width-height-25px"
                         src="<?php echo WP_PLUGIN_URL . "/" . dirname(plugin_basename(__FILE__)) . '/../files/img/load.gif' ?>">
                    <select  class="regular-text" id="select_account_menu1">
                        <option <?php echo (get_option("NUM_MENU1_account") == -1) ? "selected" : ""; ?>
                                value="0"><?php _e('Hide', 'woo2app'); ?></option>
                        <option <?php echo (get_option("NUM_MENU1_account") == 1) ? "selected" : ""; ?>
                                value="1"> <?php _e('Show', 'woo2app'); ?> </option>
                    </select>
                </td>
            </tr>
            <tr>
                <th>
                    <button class="button" onclick="change_bg_menu(1)">
						<?php _e('Header Background', 'woo2app'); ?>
                    </button>
                </th>
                <td style="position: relative">
                    <img class="width-200 height-100px;" id="img_bg_menu1"
                         src="<?= (get_option("bg_menu1")) ? get_option("bg_menu1") : "http://placehold.it/150x75&text=2x1"; ?>" />
                    <button class="button btn_delete_bg btn-menu" onclick="delete_bg_menu(1)">
						<?php _e('Delete', 'woo2app'); ?>
                    </button>
                </td>
            </tr>
        </table>
        <hr>
        <h4 class="background-color-e5e5e5 padding-7px">
			<?php _e('New', 'woo2app'); ?>
        </h4>
        <table class="form-table width-600px">
            <tr>
                <th>
					<?php _e('Type', 'woo2app'); ?>
                </th>
                <td>
                    <select class="regular-text" id="select_action_menu1">
                        <option value="0"><?php _e('Separator Line', 'woo2app'); ?> </option>
                        <option value="1"><?php _e('Product', 'woo2app'); ?></option>
                        <option value="2"><?php _e('Product Category', 'woo2app'); ?></option>
                        <option value="3"><?php _e('Link', 'woo2app'); ?></option>
                        <option value="4"><?php _e('Orders', 'woo2app'); ?></option>
                        <option value="5"><?php _e('Product Listing', 'woo2app'); ?></option>
                        <option value="6"><?php _e('Cart', 'woo2app'); ?></option>
                        <option value="7"><?php _e('Product Search', 'woo2app'); ?></option>
                        <option value="8"><?php _e('Share', 'woo2app'); ?></option>
                        <option value="9"><?php _e('Wishlist', 'woo2app'); ?></option>
                        <option value="10"><?php _e('Category List', 'woo2app'); ?></option>
                        <option value="11"> <?php _e('Blog', 'woo2app'); ?> </option>
                        <option value="12"> <?php _e('Login', 'woo2app'); ?> </option>
                        <option value="13"> <?php _e('Register', 'woo2app'); ?> </option>
                        <option value="14"> <?php _e('Profile', 'woo2app'); ?> </option>
                        <option value="15"> <?php _e('Order Tracking', 'woo2app'); ?> </option>
                        <option value="16"> <?php _e('Call', 'woo2app'); ?> </option>
                        <option value="17"> <?php _e('SMS', 'woo2app'); ?> </option>
                        <option value="18"> <?php _e('Wallet', 'woo2app'); ?> </option>
                        <option value="19"> <?php _e('Invite Friends', 'woo2app'); ?> </option>
                        <option value="20"> <?php _e('Message Inbox', 'woo2app'); ?></option>
                        <option value="21"> <?php _e('Vendors', 'woo2app'); ?> </option>
                        <option value="22"> <?php _e('About', 'woo2app'); ?> </option>
                        <option value="23"> <?php _e('Qr Code', 'woo2app'); ?></option>
                        <option value="24"> <?php _e('Multi-Domain', 'woo2app'); ?></option>
                        <option value="25"> <?php _e('Purchased Files', 'woo2app'); ?></option>
                    </select>
                    <div class="alert alert-danger hide padding-2px">
						<?php _e('Please select action.', 'woo2app'); ?>
                    </div>
                </td>
            </tr>
            <tr class="hide" id="product_list" >
                <th> <?php _e('Select Product', 'woo2app'); ?> </th>
                <td>
                    <select name="product1" data-id="product"
                            data-placeholder="<?php _e('Enter at least 3 characters', 'woo2app'); ?>"
                            id="value_post_items_menu1"
                            class="js-data-example-ajax regular-text">
                    </select>
                </td>
            </tr>
            <tr class="hide"  id="category_list" >
                <th>  <?php _e('Select Category', 'woo2app'); ?> </th>
                <td>
                    <select id="value_cat_items_menu1"
                            class="js-example-basic-single regular-text"
                            data-live-search="true" title="<?php _e('Please Select ...', 'woo2app'); ?>">
                        <option value="0"><?php _e('Choose your category', 'woo2app'); ?></option>
						<?php
						$args = array('hide_empty' => 0 ,
						              'taxonomy' => 'product_cat'
						);
						$cats = get_categories($args);
						foreach ($cats as $cat) {
							?>
                            <option value="<?= $cat->slug; ?>"><?= $cat->name; ?></option>
							<?php
						}
						?>
                    </select>
                </td>
            </tr>
            <tr class="hide" id="link_list">
                <th> <?php _e('Link', 'woo2app'); ?> </th>
                <td>
                    <input  id="value_link_items_menu1" type="text" class="regular-text" placeholder="{http | https}://yoursite.com">
                </td>
            </tr>
            <tr class="hide" id="tell_list">
                <th> <?php _e('Phone', 'woo2app'); ?> </th>
                <td>
                    <input id="value_tell_items_menu1" type="text" class="regular-text"
                           placeholder="<?php _e('Phone Number', 'woo2app'); ?>">
                </td>
            </tr>
            <tr class="hide" id="title_menu">
                <th> <?php _e('Title', 'woo2app'); ?> </th>
                <td>
                    <input placeholder="<?php _e('Title', 'woo2app'); ?>"
                           id="value_title_menu1" type="text" class="regular-text">
                </td>
            </tr>
            <tr class="hide"  id="inviter_help">

                <th> <?php _e('Invitation Message', 'woo2app'); ?>  </th>
                <td>
                    <textarea id="value_moaref_items_menu1" type="text"
                              class="regular-text"
                              placeholder="<?php _e('Enter Your Text', 'woo2app'); ?> "></textarea>
                    <p class="p_moaref_items_menu1">
                        <a  href="https://mr2app.com/blog/woocommerce-marketing/"
                            target="_blank"> <?php _e('Guide', 'woo2app'); ?> </a>
                    </p>
                </td>
            </tr>
            <tr class="hide" id="custom_paragraph">
                <th>
					<?php _e('About Content', 'woo2app'); ?>
                </th>
                <td>
                    <textarea id="p_custom_paragraph1" type="text" class="regular-text"
                              placeholder="<?php _e('Enter Text', 'woo2app'); ?>"></textarea>
                </td>
            </tr>
            <tr id="sort_product_list"  class="hide" >
                <th> <?php _e('Sort', 'woo2app'); ?> </th>
                <td>
                    <select id="sort_product_value1" class="regular-text">
                        <option value=""> <?php _e('Default ', 'woo2app'); ?></option>
                        <option value="orderby=popularity&order=DESC"> <?php _e('Popularity', 'woo2app'); ?> </option>
                        <option value="orderby=date&order=DESC"> <?php _e('Newest', 'woo2app'); ?> </option>
                        <option value="orderby=price&order=ASC"> <?php _e('Lowest price ', 'woo2app'); ?></option>
                        <option value="orderby=price&order=DESC"> <?php _e('Highest price', 'woo2app'); ?> </option>
                        <option value="orderby=selling&order=DESC"> <?php _e('Bestseller', 'woo2app'); ?> </option>
                    </select>
                </td>
            </tr>
            <tr class="hide" id="add_item_hami_div1" >
                <th>
					<?php _e('Icon', 'woo2app'); ?>
                </th>
                <td>
                    <input type="hidden" id="txt_url_item_hami1" />
                    <img id="div_image_item_hami1" class="float-right"
                         src="<?= WOO2APP_URL . "files/img/96x96&text=icon.png" ?>"/>
                    <div id="div_sel_pic_banner1">
                        <button id="btn_sel_pic_banner1"
                                type="button"
                                class="button button-primary float-right margin-top-45px margin-right-5px">
							<?php _e('Icon', 'woo2app'); ?>
                        </button>
                        <div class="clear"></div>
                        <p id="description_icon1">
                            <hr>
	                        <?php _e('Best scale', 'woo2app'); ?> : 1X1
                            <hr>
	                        <?php _e('Recommended Resolution', 'woo2app'); ?> : 512X512
                            <hr>
	                        <?php _e('Max Size', 'woo2app'); ?> : 100KB
                            <hr>
	                        <?php _e('Format', 'woo2app'); ?> : PNG - JPG - JPEG - GIF
                        </p>
                    </div>
                </td>
            </tr>
            <tr>
                <td colspan="2">
                    <button  id="btn_form_menu1" class="button button-primary">
						<?php _e('Add', 'woo2app'); ?>
                    </button>
                    <img id="img_load1" class="hide width-height-25px"
                         src="<?php echo WP_PLUGIN_URL . "/" . dirname(plugin_basename(__FILE__)) . '/../files/img/load.gif' ?>">
                </td>
            </tr>
        </table>

        <h4 class="background-color-e5e5e5 padding-7px">
			<?php _e('Items', 'woo2app'); ?>
        </h4>
        <form name="form_sort" id="form_sort_menu1" method="post" action="">
            <table class="form-table">
                <tbody id="sortable">
                </tbody>
            </table>
        </form>
        <div>
            <div>
                <img id="img_load_menu1" class="hide width-height-25px"
                     src="<?php echo WP_PLUGIN_URL . "/" . dirname(plugin_basename(__FILE__)) . '/../files/img/load.gif' ?>">
                <img id="img_load_sort_menu1" class="hide width-height-25px"
                     src="<?php echo WP_PLUGIN_URL . "/" . dirname(plugin_basename(__FILE__)) . '/../files/img/load.gif' ?>">
                <button  id="btn_form_order_menu1" class="btn btn-primary btn-sm">
					<?php _e('Sort', 'woo2app'); ?>
                </button>
            </div>
        </div>
        <div>
            <div>
                <div class="alert alert-success hide" id="alert_sort1">
                </div>
            </div>
        </div>
		<?php
	}
    elseif($sub_tab == 'leftmenu'){
		?>
        <h4 class="background-color-e5e5e5 padding-7px">
			<?php _e('Setting', 'woo2app'); ?>
        </h4>
        <table class="form-table width-600px">
            <tr>
                <th>
					<?php _e('Left Menu', 'woo2app'); ?>
                </th>
                <td>
                    <img id="img_change_menu3" class="hide width-height-25px"
                         src="<?php echo WP_PLUGIN_URL . "/" . dirname(plugin_basename(__FILE__)) . '/../files/img/load.gif' ?>">
                    <select class="regular-text" id="select_position_menu3">
                        <option <?php echo (get_option("NUM_MENU3_POS") == -1) ? "selected" : ""; ?>
                                value="-1"><?php _e('Hide', 'woo2app'); ?></option>
                        <option <?php echo (get_option("NUM_MENU3_POS") == 2) ? "selected" : ""; ?>
                                value="2"> <?php _e('Show', 'woo2app'); ?></option>
                    </select>
                </td>
            </tr>
            <tr>
		        <?php
		        $display_mode_2 = get_option('App_display_menu_mode_2');
		        ?>
                <th>
			        <?php _e('Mode', 'woo2app'); ?>
                </th>
                <td>
                    <img id="img_change_mode_menu2" class="hide width-height-25px"
                         src="<?php echo WP_PLUGIN_URL . "/" . dirname(plugin_basename(__FILE__)) . '/../files/img/load.gif' ?>">
                    <select class="regular-text" id="select_mode_menu2" onchange="change_mode(this , 2)">
                        <option value="5001" <?= selected($display_mode_2 , '5001' )?> > <?= _e('Simple' , 'woo2app'); ?></option>
                        <option value="5002" <?= selected($display_mode_2 , '5002' )?> > <?= _e('Fullscreen' , 'woo2app'); ?></option>
                        <option value="5003" <?= selected($display_mode_2 , '5003' )?> > <?= _e('Minimal' , 'woo2app'); ?></option>
                    </select>
                </td>
            </tr>
            <tr>
                <th>
                    <label>
				        <?php _e('Preview', 'woo2app'); ?>
                    </label>
                </th>
                <td>
                    <img id="img_cat_mode_5001"  style="height: 400px" class="img_cat_prev_mode <?= ($display_mode_2 == '5001') ? '' : 'hide'?>" src="<?= WOO2APP_URL .'/files/img/Menu/menu-1.jpg'?>" />
                    <img id="img_cat_mode_5002"  style="height: 400px" class="img_cat_prev_mode <?= ($display_mode_2 == '5002') ? '' : 'hide'?>" src="<?= WOO2APP_URL .'/files/img/Menu/menu-2.jpg'?>" />
                    <img id="img_cat_mode_5003" style="height: 400px" class="img_cat_prev_mode <?= ($display_mode_2 == '5003') ? '' : 'hide'?>" src="<?= WOO2APP_URL .'/files/img/Menu/menu-3.jpg'?>" />
                </td>
            </tr>
            <tr>
                <th>
					<?php _e('Header', 'woo2app'); ?>
                </th>
                <td >
                    <img id="img_account_menu3" class="hide width-height-25px"
                         src="<?php echo WP_PLUGIN_URL . "/" . dirname(plugin_basename(__FILE__)) . '/../files/img/load.gif' ?>">
                    <select  class="regular-text" id="select_account_menu3">
                        <option <?php echo (get_option("NUM_MENU3_account") == -1) ? "selected" : ""; ?>
                                value="0"><?php _e('Hide', 'woo2app'); ?></option>
                        <option <?php echo (get_option("NUM_MENU3_account") == 1) ? "selected" : ""; ?>
                                value="1"> <?php _e('Show', 'woo2app'); ?> </option>
                    </select>
                </td>
            </tr>

            <tr>
                <th>
                    <button class="button" onclick="change_bg_menu(3)">
						<?php _e('Header Background', 'woo2app'); ?>
                    </button>
                </th>
                <td style="position: relative">
                    <img class="width-200 height-100px;" id="img_bg_menu3"
                         src="<?= (get_option("bg_menu3")) ? get_option("bg_menu3") : "http://placehold.it/150x75&text=2x1"; ?>">
                    <button class="button btn_delete_bg btn-menu" onclick="delete_bg_menu(3)">
						<?php _e('Delete', 'woo2app'); ?>
                    </button>
                </td>
            </tr>
        </table>
        <hr>
        <h4 class="background-color-e5e5e5 padding-7px">
			<?php _e('New', 'woo2app'); ?>
        </h4>
        <table class="form-table width-600px">
            <tr>
                <th>
					<?php _e('Type', 'woo2app'); ?>
                </th>
                <td>
                    <select class="regular-text" id="select_action_menu3">
                        <option value="0"><?php _e('Separator Line', 'woo2app'); ?> </option>
                        <option value="1"><?php _e('Product', 'woo2app'); ?></option>
                        <option value="2"><?php _e('Product Category', 'woo2app'); ?></option>
                        <option value="3"><?php _e('Link', 'woo2app'); ?></option>
                        <option value="4"><?php _e('Orders', 'woo2app'); ?></option>
                        <option value="5"><?php _e('Product Listing', 'woo2app'); ?></option>
                        <option value="6"><?php _e('Cart', 'woo2app'); ?></option>
                        <option value="7"><?php _e('Product Search', 'woo2app'); ?></option>
                        <option value="8"><?php _e('Share', 'woo2app'); ?></option>
                        <option value="9"><?php _e('Wishlist', 'woo2app'); ?></option>
                        <option value="10"><?php _e('Category List', 'woo2app'); ?></option>
                        <option value="11"> <?php _e('Blog', 'woo2app'); ?> </option>
                        <option value="12"> <?php _e('Login', 'woo2app'); ?> </option>
                        <option value="13"> <?php _e('Register', 'woo2app'); ?> </option>
                        <option value="14"> <?php _e('Profile', 'woo2app'); ?> </option>
                        <option value="15"> <?php _e('Order Tracking', 'woo2app'); ?> </option>
                        <option value="16"> <?php _e('Call', 'woo2app'); ?> </option>
                        <option value="17"> <?php _e('SMS', 'woo2app'); ?> </option>
                        <option value="18"> <?php _e('Wallet', 'woo2app'); ?> </option>
                        <option value="19"> <?php _e('Invite Friends', 'woo2app'); ?> </option>
                        <option value="20"> <?php _e('Message Inbox', 'woo2app'); ?></option>
                        <option value="21"> <?php _e('Vendors', 'woo2app'); ?> </option>
                        <option value="22"> <?php _e('About', 'woo2app'); ?> </option>
                        <option value="23"> <?php _e('Qr Code', 'woo2app'); ?></option>
                        <option value="24"> <?php _e('Multi-Domain', 'woo2app'); ?></option>
                        <option value="25"> <?php _e('Purchased Files', 'woo2app'); ?></option>
                    </select>
                    <div class="alert alert-danger hide padding-2px">
						<?php _e('Please select action.', 'woo2app'); ?>
                    </div>
                </td>
            </tr>
            <tr class="hide" id="product_list3" >
                <th> <?php _e('Select Product', 'woo2app'); ?> </th>
                <td>
                    <select name="product1" data-id="product"
                            data-placeholder="<?php _e('Enter at least 3 characters', 'woo2app'); ?>"
                            id="value_post_items_menu3"
                            class="js-data-example-ajax regular-text">
                    </select>
                </td>
            </tr>
            <tr class="hide"  id="category_list3" >
                <th>  <?php _e('Select Category', 'woo2app'); ?> </th>
                <td>
                    <select id="value_cat_items_menu3"
                            class="js-example-basic-single regular-text"
                            data-live-search="true" title="<?php _e('Please Select ...', 'woo2app'); ?>">
                        <option value="0"><?php _e('Choose your category', 'woo2app'); ?></option>
						<?php
						$args = array('hide_empty' => 0 ,
						              'taxonomy' => 'product_cat'
						);
						$cats = get_categories($args);
						foreach ($cats as $cat) {
							?>
                            <option value="<?= $cat->slug; ?>"><?= $cat->name; ?></option>
							<?php
						}
						?>
                    </select>
                </td>
            </tr>
            <tr class="hide" id="link_list3">
                <th> <?php _e('Link', 'woo2app'); ?> </th>
                <td>
                    <input  id="value_link_items_menu3" type="text" class="regular-text" placeholder="{http | https}://yoursite.com">
                </td>
            </tr>
            <tr class="hide" id="tell_list3">
                <th> <?php _e('Phone', 'woo2app'); ?> </th>
                <td>
                    <input id="value_tell_items_menu3" type="text" class="regular-text"
                           placeholder="<?php _e('Phone Number', 'woo2app'); ?>">
                </td>
            </tr>
            <tr class="hide" id="title_menu3">
                <th> <?php _e('Title', 'woo2app'); ?> </th>
                <td>
                    <input placeholder="<?php _e('Title', 'woo2app'); ?>"
                           id="value_title_menu3" type="text" class="regular-text">
                </td>
            </tr>
            <tr class="hide"  id="inviter_help3">

                <th> <?php _e('Invitation Message', 'woo2app'); ?> </th>
                <td>
                    <textarea id="value_moaref_items_menu3" type="text"
                              class="regular-text"
                              placeholder="<?php _e('Enter Your Text', 'woo2app'); ?> "></textarea>
                    <p class="p_moaref_items_menu3">
                        <a  href="https://mr2app.com/blog/woocommerce-marketing/"
                            target="_blank"> <?php _e('Guide', 'woo2app'); ?> </a>
                    </p>
                </td>
            </tr>
            <tr class="hide" id="custom_paragraph3">
                <th>
					<?php _e('About Content', 'woo2app'); ?>
                </th>
                <td>
                    <textarea id="p_custom_paragraph3" type="text" class="regular-text"
                              placeholder="<?php _e('Enter Text', 'woo2app'); ?>"></textarea>
                </td>
            </tr>
            <tr id="sort_product_list3"  class="hide" >
                <th> <?php _e('Sort', 'woo2app'); ?> </th>
                <td>
                    <select id="sort_product_value3" class="regular-text">
                        <option value=""> <?php _e('Default', 'woo2app'); ?></option>
                        <option value="orderby=popularity&order=DESC"> <?php _e('Popularity', 'woo2app'); ?> </option>
                        <option value="orderby=date&order=DESC"> <?php _e('Newest', 'woo2app'); ?> </option>
                        <option value="orderby=price&order=ASC"> <?php _e('Lowest price ', 'woo2app'); ?></option>
                        <option value="orderby=price&order=DESC"> <?php _e('Highest price', 'woo2app'); ?> </option>
                        <option value="orderby=selling&order=DESC"> <?php _e('Bestseller', 'woo2app'); ?> </option>
                    </select>
                </td>
            </tr>
            <tr class="hide" id="add_item_hami_div3" >
                <th>
					<?php _e('Icon', 'woo2app'); ?>
                </th>
                <td>
                    <input type="hidden" id="txt_url_item_hami3" />
                    <img id="div_image_item_hami3" class="float-right"
                         src="<?= WOO2APP_URL . "files/img/96x96&text=icon.png" ?>"/>
                    <div id="div_sel_pic_banner3">
                        <button id="btn_sel_pic_banner3"
                                type="button"
                                class="button button-primary float-right margin-top-45px margin-right-5px">
							<?php _e('Icon', 'woo2app'); ?>
                        </button>
                        <div class="clear"></div>
                        <p id="description_icon1">
                        <hr>
	                    <?php _e('Best scale', 'woo2app'); ?> : 1X1
                        <hr>
	                    <?php _e('Recommended Resolution', 'woo2app'); ?> : 512X512
                        <hr>
	                    <?php _e('Max Size', 'woo2app'); ?> : 100KB
                        <hr>
	                    <?php _e('Format', 'woo2app'); ?> : PNG - JPG - JPEG - GIF
                        </p>
                    </div>
                </td>
            </tr>
            <tr>
                <td colspan="2">
                    <button  id="btn_form_menu3" class="button button-primary">
						<?php _e('Add', 'woo2app'); ?>
                    </button>
                    <img id="img_load3" class="hide width-height-25px"
                         src="<?php echo WP_PLUGIN_URL . "/" . dirname(plugin_basename(__FILE__)) . '/../files/img/load.gif' ?>">
                </td>
            </tr>
        </table>

        <h4 class="background-color-e5e5e5 padding-7px">
			<?php _e('List', 'woo2app'); ?>
        </h4>
        <form name="form_sort" id="form_sort_menu3" method="post" action="">
            <table class="form-table">
                <tbody id="sortable3">
                </tbody>
            </table>
        </form>
        <div >
            <div>
                <img id="img_load_menu3" class="hide width-height-25px"
                     src="<?php echo WP_PLUGIN_URL . "/" . dirname(plugin_basename(__FILE__)) . '/../files/img/load.gif' ?>">
                <img id="img_load_sort_menu3" class="hide width-height-25px"
                     src="<?php echo WP_PLUGIN_URL . "/" . dirname(plugin_basename(__FILE__)) . '/../files/img/load.gif' ?>">
                <button  id="btn_form_order_menu3" class="btn btn-primary btn-sm">
					<?php _e('Sort', 'woo2app'); ?>
                </button>
            </div>
        </div>
        <div>
            <div>
                <div class="alert alert-success hide" id="alert_sort3">
                </div>
            </div>
        </div>
		<?php
	}
    elseif($sub_tab == 'floatingmenu'){
		?>
        <h4 class="background-color-e5e5e5 padding-7px">
			<?php _e('Setting', 'woo2app'); ?>
        </h4>
        <table class="form-table width-600px">
            <tr>
                <th>
					<?php _e('Float Menu', 'woo2app'); ?>
                </th>
                <td>
                    <img id="img_change_menu2" class="hide width-height-25px"
                         src="<?php echo WP_PLUGIN_URL . "/" . dirname(plugin_basename(__FILE__)) . '/../files/img/load.gif' ?>">
                    <select class="regular-text" id="select_position_menu2">
                        <option <?php echo (get_option("NUM_MENU2_POS") == -1 ) ? "selected" : ""; ?> value="-1"><?php _e('Hide', 'woo2app'); ?></option>
                        <option <?php echo (get_option("NUM_MENU2_POS") == 3 ) ? "selected" : ""; ?> value="3"><?php _e('Right', 'woo2app'); ?></option>
                        <option <?php echo (get_option("NUM_MENU2_POS") == 4 ) ? "selected" : ""; ?> value="4"><?php _e('Left', 'woo2app'); ?></option>
                    </select>
                </td>
            </tr>
        </table>
        <hr>
        <h4 class="background-color-e5e5e5 padding-7px">
			<?php _e('New', 'woo2app'); ?>
        </h4>
        <table class="form-table width-600px">
            <tr>
                <th>
					<?php _e('Type', 'woo2app'); ?>
                </th>
                <td>
                    <select class="regular-text" id="select_action_menu2">
                        <option value="1"><?php _e('Product', 'woo2app'); ?></option>
                        <option value="2"><?php _e('Product Category', 'woo2app'); ?></option>
                        <option value="3"><?php _e('Link', 'woo2app'); ?></option>
                        <option value="4"><?php _e('Orders', 'woo2app'); ?></option>
                        <option value="5"><?php _e('Product Listing', 'woo2app'); ?></option>
                        <option value="6"><?php _e('Cart', 'woo2app'); ?></option>
                        <option value="7"><?php _e('Product Search', 'woo2app'); ?></option>
                        <option value="8"><?php _e('Share', 'woo2app'); ?></option>
                        <option value="9"><?php _e('Wishlist', 'woo2app'); ?></option>
                        <option value="10"><?php _e('Category List', 'woo2app'); ?></option>
                        <option value="11"> <?php _e('Blog', 'woo2app'); ?> </option>
                        <option value="12"> <?php _e('Login', 'woo2app'); ?> </option>
                        <option value="13"> <?php _e('Register', 'woo2app'); ?> </option>
                        <option value="14"> <?php _e('Profile', 'woo2app'); ?> </option>
                        <option value="15"> <?php _e('Order Tracking', 'woo2app'); ?> </option>
                        <option value="16"> <?php _e('Call', 'woo2app'); ?> </option>
                        <option value="17"> <?php _e('SMS', 'woo2app'); ?> </option>
                        <option value="18"> <?php _e('Wallet', 'woo2app'); ?> </option>
                        <option value="19"> <?php _e('Invite Friends', 'woo2app'); ?> </option>
                        <option value="20"> <?php _e('Message Inbox', 'woo2app'); ?></option>
                        <option value="21"> <?php _e('Vendors', 'woo2app'); ?> </option>
                        <option value="22"> <?php _e('About', 'woo2app'); ?> </option>
                        <option value="23"> <?php _e('Qr Code', 'woo2app'); ?></option>
                        <option value="24"> <?php _e('Multi-Domain', 'woo2app'); ?></option>
                        <option value="25"> <?php _e('Purchased Files', 'woo2app'); ?></option>
                    </select>
                    <div class="alert alert-danger hide padding-2px">
						<?php _e('Please select action.', 'woo2app'); ?>
                    </div>
                </td>
            </tr>
            <tr id="product_list2" >
                <th> <?php _e('Select Product', 'woo2app'); ?> </th>
                <td>
                    <select name="product1" data-id="product"
                            data-placeholder="<?php _e('Enter at least 3 characters', 'woo2app'); ?>"
                            id="value_post_items_menu2"
                            class="js-data-example-ajax regular-text">
                    </select>
                </td>
            </tr>
            <tr class="hide"  id="category_list2" >
                <th>  <?php _e('Select Category', 'woo2app'); ?> </th>
                <td>
                    <select id="value_cat_items_menu2"
                            class="js-example-basic-single regular-text"
                            data-live-search="true" title="<?php _e('Please Select ...', 'woo2app'); ?>">
                        <option value="0"><?php _e('Choose your category', 'woo2app'); ?></option>
						<?php
						$args = array('hide_empty' => 0 ,
						              'taxonomy' => 'product_cat'
						);
						$cats = get_categories($args);
						foreach ($cats as $cat) {
							?>
                            <option value="<?= $cat->slug; ?>"><?= $cat->name; ?></option>
							<?php
						}
						?>
                    </select>
                </td>
            </tr>
            <tr class="hide" id="link_list2">
                <th> <?php _e('Link', 'woo2app'); ?> </th>
                <td>
                    <input  id="value_link_items_menu2" type="text" class="regular-text" placeholder="{http | https}://yoursite.com">
                </td>
            </tr>
            <tr class="hide" id="tell_list2">
                <th> <?php _e('Phone', 'woo2app'); ?>  </th>
                <td>
                    <input id="value_tell_items_menu2" type="text" class="regular-text"
                           placeholder="<?php _e('Phone Number', 'woo2app'); ?>">
                </td>
            </tr>
            <tr  id="title_menu2">
                <th> <?php _e('Title', 'woo2app'); ?>  </th>
                <td>
                    <input placeholder="<?php _e('Title', 'woo2app'); ?>"
                           id="value_title_menu2" type="text" class="regular-text">
                </td>
            </tr>
            <tr class="hide"  id="inviter_help2">

                <th> <?php _e('Text for Inviter module', 'woo2app'); ?> </th>
                <td>
                    <textarea id="value_moaref_items_menu2" type="text"
                              class="regular-text"
                              placeholder="<?php _e('Invitation Message', 'woo2app'); ?> "></textarea>
                    <p class="p_moaref_items_menu2">
                        <a  href="https://mr2app.com/blog/woocommerce-marketing/"
                            target="_blank"> <?php _e('Guide', 'woo2app'); ?> </a>
                    </p>
                </td>
            </tr>
            <tr class="hide" id="custom_paragraph2">
                <th>
					<?php _e('About Content', 'woo2app'); ?>
                </th>
                <td>
                    <textarea id="p_custom_paragraph2" type="text" class="regular-text"
                              placeholder="<?php _e('Enter Text', 'woo2app'); ?>"></textarea>
                </td>
            </tr>
            <tr id="sort_product_list2"  class="hide" >
                <th> <?php _e('Sort', 'woo2app'); ?> </th>
                <td>
                    <select id="sort_product_value2" class="regular-text">
                        <option value=""> <?php _e('Default', 'woo2app'); ?></option>
                        <option value="orderby=popularity&order=DESC"> <?php _e('Popularity', 'woo2app'); ?> </option>
                        <option value="orderby=date&order=DESC"> <?php _e('Newest', 'woo2app'); ?> </option>
                        <option value="orderby=price&order=ASC"> <?php _e('Lowest price', 'woo2app'); ?></option>
                        <option value="orderby=price&order=DESC"> <?php _e('Highest price', 'woo2app'); ?> </option>
                        <option value="orderby=selling&order=DESC"> <?php _e('Bestseller', 'woo2app'); ?> </option>
                    </select>
                </td>
            </tr>
            <tr id="add_item_hami_div2" >
                <th>
					<?php _e('Icon', 'woo2app'); ?>
                </th>
                <td>
                    <input type="hidden" id="txt_url_item_hami2" />
                    <img id="div_image_item_hami2" class="float-right"
                         src="<?= WOO2APP_URL . "files/img/96x96&text=icon.png" ?>"/>
                    <div id="div_sel_pic_banner2">
                        <button id="btn_sel_pic_banner2"
                                type="button"
                                class="button button-primary float-right margin-top-45px margin-right-5px">
							<?php _e('Icon', 'woo2app'); ?>
                        </button>
                        <div class="clear"></div>
                        <p id="description_icon1">
                        <hr>
	                    <?php _e('Best scale', 'woo2app'); ?> : 1X1
                        <hr>
	                    <?php _e('Recommended Resolution', 'woo2app'); ?> : 512X512
                        <hr>
	                    <?php _e('Max Size', 'woo2app'); ?> : 100KB
                        <hr>
	                    <?php _e('Format', 'woo2app'); ?> : PNG - JPG - JPEG - GIF
                        </p>
                    </div>
                </td>
            </tr>
            <tr>
                <td colspan="2">
                    <button  id="btn_form_menu2" class="button button-primary">
						<?php _e('Add', 'woo2app'); ?>
                    </button>
                    <img id="img_load2" class="hide width-height-25px"
                         src="<?php echo WP_PLUGIN_URL . "/" . dirname(plugin_basename(__FILE__)) . '/../files/img/load.gif' ?>">
                </td>
            </tr>
        </table>

        <h4 class="background-color-e5e5e5 padding-7px">
			<?php _e('List', 'woo2app'); ?>
        </h4>
        <form name="form_sort" id="form_sort_menu2" method="post" action="">
            <table class="form-table">
                <tbody id="sortable1">
                </tbody>
            </table>
        </form>
        <div>
            <div>
                <img id="img_load_menu2" class="hide width-height-25px"
                     src="<?php echo WP_PLUGIN_URL . "/" . dirname(plugin_basename(__FILE__)) . '/../files/img/load.gif' ?>">
                <img id="img_load_sort_menu2" class="hide width-height-25px"
                     src="<?php echo WP_PLUGIN_URL . "/" . dirname(plugin_basename(__FILE__)) . '/../files/img/load.gif' ?>">
                <button  id="btn_form_order_menu2" class="btn btn-primary btn-sm">
					<?php _e('Sort', 'woo2app'); ?>
                </button>
            </div>
        </div>
        <div>
            <div>
                <div class="alert alert-success hide" id="alert_sort2">
                </div>
            </div>
        </div>
		<?php
	}
	?>
</div>
<?php
wp_enqueue_media();
wp_enqueue_script( 'upload_item_banner.js'.WOO2APP_FILES_VER , WOO2APP_JS_URL.'upload_item_banner.js', array('jquery'));
wp_enqueue_script( 'woo2app_menu.js'.WOO2APP_FILES_VER , WOO2APP_JS_URL.'woo2app_menu.js', array('jquery'));
wp_enqueue_script( 'loadajax.js'.WOO2APP_FILES_VER , WOO2APP_JS_URL.'loadAjaxPosts.js', array('jquery'));
?>
<script type="text/javascript">
    jQuery('#search_product_banner1 , #search_product_banner2 , #search_product_banner3').keyup(function(){
        let id = $(this).attr('id');
        id = id.replace("search_product_banner", "");
        var  v = jQuery(this).val();
        if(v.length >= 3){
            jQuery("#loading_product" + id).removeClass("hide");
            jQuery.ajax({
                url: ajaxurl,
                data: {
                    action: "load_all_product",
                    search_product : v
                },
                success:function(data) {
                    jQuery("#loading_product"+id).addClass("hide");
                    jQuery("#value_post_items_menu"+id).html(data);
                }
            });
        }
    });
    function change_img_menu(id) {
        //e.preventDefault();
        custom_uploader_hami = wp.media.frames.custom_uploader_hami = wp.media({
            title: 'Select Image',
            library: {type: 'image'},
            button: {text: 'select'},
            multiple: false
        });
        custom_uploader_hami.on('select', function() {
            attachment = custom_uploader_hami.state().get('selection').first().toJSON();
            url_image = attachment.url;
            jQuery("#1menu_img_" + id).attr('src' , url_image);
            update_item_menu1_woo(id)
        });
        custom_uploader_hami.open();
    }
    function change_bg_menu(id) {
        //e.preventDefault();
        custom_uploader_hami = wp.media.frames.custom_uploader_hami = wp.media({
            title: 'Select Image',
            library: {type: 'image'},
            button: {text: 'select'},
            multiple: false
        });
        custom_uploader_hami.on('select', function() {
            attachment = custom_uploader_hami.state().get('selection').first().toJSON();
            url_image = attachment.url;
            //jQuery("#img_bg_menu" + id).attr('src' , url_image);
            set_bg_menu(id , url_image);
        });
        custom_uploader_hami.open();
    }
    function delete_bg_menu(id) {
        set_bg_menu(id , '');
    }

    function change_mode(e , menu){

        jQuery(".img_cat_prev_mode").addClass('hide');
        jQuery("#img_cat_mode_" + e.value).removeClass('hide');
        jQuery("#img_change_mode_menu" + menu).removeClass('hide');
        jQuery.ajax({
            url: ajaxurl,
            data: {
                action: "set_position_mode_menu",
                val : e.value,
                menu : menu
            },
            success:function(data) {
                jQuery("#img_change_mode_menu" + menu).addClass('hide');
                //data = data.substring(0,data.length -1);
            }
        });
    }
</script>