<?php
session_start();
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

$current_url="//".$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
wp_register_style( 'woo2app_style', WOO2APP_CSS_URL.'woo2app_style.css'  );
wp_enqueue_style( 'woo2app_style'.WOO2APP_FILES_VER );
if(get_locale() == 'fa_IR'){
	wp_register_style('myfont', WOO2APP_CSS_URL . 'font.css');
	wp_enqueue_style( 'myfont'.WOO2APP_FILES_VER);
}
wp_register_style('select2.min.css', WOO2APP_CSS_URL . 'select2.min.css');
wp_enqueue_style('select2.min.css'.WOO2APP_FILES_VER);
wp_enqueue_script('select2.min.js'.WOO2APP_FILES_VER, WOO2APP_JS_URL . 'select2.min.js');

if (isset($_POST['woo2app-admin']) && wp_verify_nonce($_POST['woo2app-admin'], 'woo2app-admin')) {
	$app_id = trim(update_option('app_id', ($_POST['app_id'])));
	$api_id = trim(update_option('api_id', ($_POST['api_id'])));
}

$app_id = get_option('app_id');
$api_id = get_option('api_id');
$email = get_option('email_WOO2APP');
$pass = get_option('password_WOO2APP');
$app_id_2 = get_option('appid_WOO2APP');

if ( isset( $_POST['send_notif_wp2appir'] ) &&
    wp_verify_nonce( $_POST["send_notif_wp2appir"], 'wp2appir_send_notif' )){
	if($_POST["select_notif_hami"] == 1){
		$value = $_POST["txt_link"];
		$action = 1;
	}elseif ($_POST["select_notif_hami"] == 2) {
		$value = $_POST["value_product_notif"];
		$action = 4;
	}elseif ($_POST["select_notif_hami"] == 3) {
		$action = 3;
		$value = $_POST["value_cat_notif"];
	}
    elseif ($_POST["select_notif_hami"] == 4) {
		$action = 6;
		$value = $_POST["value_post_notif"];
	}
    elseif ($_POST["select_notif_hami"] == 5) {
		$action = 5;
		$value = $_POST["post_value_cat_notif"];
	}
	$r = send_notif( $_POST["txt_title"],$action,$value);
    $json = json_decode($r);
//    echo '<pre>';
    print_r($json);
    $msg = 'Successfully sent to '.$json->statistics->recipient_count.' device';
    echo "<script type='text/javascript'>alert('$msg');</script>";
}
if(isset($_GET["tab"]))
	$tab = $_GET["tab"];
else
	$tab = "send";
?>
    <div class="wrap div_mainpage">
        <nav class="nav-tab-wrapper woo-nav-tab-wrapper">
            <a href="<?= $current_url.'&tab=send' ?>" class="nav-tab <?= ($tab == 'send') ? 'nav-tab-active' : ''; ?>">
				<?php _e('Send Notification', 'woo2app'); ?>
            </a>
            <a href="<?= $current_url.'&tab=setting' ?>" class="nav-tab <?= ($tab == 'setting') ? 'nav-tab-active' : ''; ?>">
				<?php _e('Setting', 'woo2app'); ?>
            </a>
            <a href="<?= $current_url.'&tab=messages' ?>" class="nav-tab <?= ($tab == 'messages') ? 'nav-tab-active' : ''; ?>">
				<?php _e('Messages', 'woo2app'); ?>
            </a>
        </nav>
		<?php
		if($tab == 'setting'){
			?>
            <div>
                <form method="POST">
                    <h4 class="background-color-e5e5e5 padding-7px">
						<?php _e('Sending Method', 'woo2app'); ?>
                    </h4>
                    <table class="form-table width-600px">
                        <tr  class="info_onesignal">
                            <td class="col-md-12 form-group">
                                One Signal APP ID
                            </td>
                            <td>
                                <input name="app_id"
                                       placeholder="<?php _e('OneSignal APP-ID', 'woo2app'); ?>"
                                       value="<?= $app_id; ?>" class="regular-text" type="text" />
                            </td>
                        </tr>
                        <tr class="info_onesignal">
                            <td class="col-md-12 form-group">
                                One Signal API KEY
                            </td>
                            <td>
                                <input name="api_id"
                                       placeholder="<?php _e('OneSignal API-KEY', 'woo2app'); ?>"
                                       value="<?= $api_id; ?>" class="regular-text" type="text">
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <button type="submit" name="save_api" class="button button-primary">
									<?php _e('Save Changes', 'woo2app'); ?>
                                </button>
                            </td>
                        </tr>
                    </table>
					<?php wp_nonce_field('woo2app-admin', 'woo2app-admin'); ?>
                </form>
            </div>
			<?php
		}
        elseif($tab == 'messages'){
			require_once  'notif_messages.php';
		}
		else{
			?>
            <div>
                <h4 class="background-color-e5e5e5 padding-7px">
					<?php _e('Send Notification', 'woo2app'); ?>
                </h4>
				<?php
				if(isset($r['recipients'])){
					$array = array(
						'title' => $_POST["txt_title"] ,
						'type' => $action ,
						'value' => $value ,
						'notif_type' => $notif_type ,
						'time' => time(),
						'recipients' =>  $r['recipients']
					);
					?>
                    <span class="green">
					<?php _e('Notification was sent to', 'woo2app'); ?>
					<?= $r['recipients']; ?>
					<?php _e('person.', 'woo2app'); ?>
				</span>
                    <div class="clearfix"></div>
                    <hr>
					<?php
				}
				?>
                <form method="POST">
					<?php wp_nonce_field('wp2appir_send_notif' , 'send_notif_wp2appir'); ?>
                    <table class="form-table width-600px">
                        <tr>
                            <!-- <th class="">

                            </th> -->
                            <!-- <td>
                                <input checked="" type="radio" value="2" name="wp2app_voice" id="wp2app_silent" />
	                            <?php _e('silent', 'woo2app'); ?>
                                <input type="radio"  value="1" name="wp2app_voice" id="wp2app_voice">
                                <span><?php _e('with sound', 'woo2app'); ?></span>
                            </td> -->
                        </tr>
                        <tr>
                            <th>
								<?php _e('Message Title', 'woo2app'); ?>
                            </th>
                            <td>
                                <textarea name="txt_title" class="form-control text-left"></textarea>
                            </td>
                        </tr>
                        <tr>
                            <th>
								<?php _e('Action', 'woo2app'); ?>
                            </th>
                            <td>
                                <select id="select_notif_hami" name="select_notif_hami" class="regular-text">
                                    <option value="1"><?php _e('Link', 'woo2app'); ?></option>
                                    <option value="2"><?php _e('Products', 'woo2app'); ?> </option>
                                    <option value="3"><?php _e('products category', 'woo2app'); ?> </option>
                                    <option value="4"><?php _e('Post', 'woo2app'); ?></option>
                                    <option value="5"><?php _e('Post Category', 'woo2app'); ?></option>
                                </select>
                            </td>
                        </tr>
                        <tr  id="product_list_notif" class="hide">
                            <th> <?php _e('Search Product', 'woo2app'); ?> </th>
                            <td>
                                <select name="value_product_notif" data-id="product" id="value_product_notif"
                                        class="js-data-example-ajax regular-text"></select>
                            </td>
                        </tr>
                        <tr id="post_list_notif" class="hide">
                            <th>
								<?php _e('Search Post', 'woo2app'); ?>
                            </th>
                            <td>
                                <select name="value_post_notif" id="value_post_notif"
                                        class="regular-text js-data-example-ajax"></select>
                            </td>
                        </tr>
                        <tr class="hide" id="category_list_notif">
                            <th><?php _e('Choose Category', 'woo2app'); ?></th>
                            <td>
                                <select name="value_cat_notif" id="value_cat_notif"
                                        class="js-example-basic-single regular-text"
                                        title="<?php _e('Select ...', 'woo2app'); ?>">
                                    <option value="0"><?php _e('Choose a category', 'woo2app'); ?></option>
									<?php
									$cats = get_terms(array('product_cat'));
									foreach ($cats as $cat) {
										?>
                                        <option value="<?= $cat->slug; ?>"><?= $cat->name; ?></option>
										<?php
									}
									?>
                                </select>
                            </td>
                        </tr>
                        <tr class="hide" id="post_category_list_notif">
                            <th>
								<?php _e('Choose Category', 'woo2app'); ?>
                            </th>
                            <td>
                                <select name="post_value_cat_notif" id="post_value_cat_notif"
                                        class="js-example-basic-single regular-text"
                                        title="<?php _e('Select ...', 'woo2app'); ?>">
                                    <option value="0"><?php _e('Choose a category', 'woo2app'); ?></option>
									<?php
									$cats = get_terms(array('category'));
									foreach ($cats as $cat) {
										?>
                                        <option value="<?= $cat->term_id; ?>"><?= $cat->name; ?></option>
										<?php
									}
									?>
                                </select>
                            </td>
                        </tr>
                        <tr id="link_notif_hami" class="">
                            <th>
								<?php _e('Link', 'woo2app'); ?>
                            </th>
                            <td>
                                <input type="text" name="txt_link" class="regular-text"  placeholder="[http || https] :// mysite.ir">
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <button type="submit" class="button button-primary">
									<?php _e('Send Message', 'woo2app'); ?>
                                </button>
                            </td>
                        </tr>
                    </table>
                </form>
            </div>
			<?php
		}
		?>
    </div>
<?php
wp_enqueue_script( 'notification_hami.js'.WOO2APP_FILES_VER , WOO2APP_JS_URL.'notification_hami.js', array('jquery'));
wp_enqueue_script( 'loadajax.js'.WOO2APP_FILES_VER , WOO2APP_JS_URL.'loadAjaxPosts.js', array('jquery'));
?>