<?php
wp_register_style('select2.min.css', WOO2APP_CSS_URL . 'select2.min.css');
wp_enqueue_style('select2.min.css'.WOO2APP_FILES_VER);
wp_enqueue_script('select2.min.js'.WOO2APP_FILES_VER, WOO2APP_JS_URL . 'select2.min.js');
global $wpdb;
$table_name = $wpdb->prefix . "woo2app_slider";
if (isset($_POST['slider_sort']) && wp_verify_nonce($_POST['slider_sort'], 'slider_sort') && isset($_REQUEST['sort'])) {
	$ids = $_POST['ids'];
	$i = 0;
	foreach ($ids as $id){
		$i++;
		$wpdb->update(
			$table_name,
			array(
				'sl_sort' => $i	// integer (number)
			),
			array( 'sl_id' => $id ),
			array(
				'%d'	// value2
			),
			array( '%d' )
		);
	}

}

if (isset($_POST['woo2app-admin']) && wp_verify_nonce($_POST['woo2app-admin'], 'woo2app-admin') && isset($_POST['submit_banner'])) {
	if($_REQUEST["select_action_banner"] && $_REQUEST["src_val"]){
		$title = ($_REQUEST["title"]);
		$pic = esc_url_raw($_REQUEST["src_val"]);
		$type = ($_REQUEST["select_action_banner"]);
		$value = "" ;
		$sort = 100 ;
		if($type == 1) {
			$value = ($_REQUEST["product"]);
		}
        elseif($type == 2){
			$value = ($_REQUEST["cat"]);
		}
        elseif ($type == 3) {
			$value = esc_url_raw($_REQUEST["link"]);
		}
        elseif ($type == 8) {
			$value = json_encode(($_REQUEST["tags"]));
		}
        elseif ($type == 9) {
			$value = explode(',', ($_REQUEST["CustomList"]));
			$value = json_encode($value);
		}
		$r = $wpdb->query( $wpdb->prepare("INSERT INTO $table_name 
		( sl_title , sl_type , sl_value , sl_pic , sl_sort ) 
		VALUES ( %s, %d, %s, %s, %d )", $title,$type,$value,$pic , $sort) );
		if($r){
			echo "<p style='color:green'>" . _e('Slider was saved.', 'woo2app') . '</p>';
		}
	}
	else{
		echo "<p style='color:red'>" . _e('Unfortunately, we encountered a problem.', 'woo2app') . '</p>';
	}
}
$args = array(
	'hide_empty' => 0 ,
	'taxonomy' => 'product_cat'
);
$cats = get_categories($args);
?>
<div >
    <form action="" method="post">
		<?php wp_nonce_field('woo2app-admin', 'woo2app-admin'); ?>
        <h3 class="background-color-e5e5e5 padding-7px">
			<?php _e('Slider', 'woo2app'); ?>
        </h3>
        <hr>
        <table class="form-table " >
            <tbody>
            <tr valign="top" class="">
                <th scope="row" class="titledesc">
                    <label><?php _e('Title', 'woo2app'); ?></label>
                </th>
                <td class="forminp">
                    <input type="text" class="regular-text" name="title" id="title" value=""
                           placeholder="<?php _e('Title', 'woo2app'); ?>">
                </td>
            </tr>
            <tr valign="top" class="">
                <th scope="row" class="titledesc">
                    <label><?php _e('Action', 'woo2app'); ?></label>
                </th>
                <td class="forminp">
                    <select class="regular-text" id="select_action_banner" name="select_action_banner" required="required">
                        <option value="0"> <?php _e('Please Select ...', 'woo2app'); ?></option>
                        <option value="1"><?php _e('Product', 'woo2app'); ?></option>
                        <option value="2"><?php _e('Product Category', 'woo2app'); ?></option>
                        <option value="3"><?php _e('Link', 'woo2app'); ?></option>
                        <option value="8"><?php _e('Product Tag', 'woo2app'); ?></option>
                        <option value="9"><?php _e('Custom List', 'woo2app'); ?></option>
                        <option value="4"><?php _e('No Action', 'woo2app'); ?></option>
                    </select>
                </td>
            </tr>
            <tr valign="top" class="el_type display-none" id="el_tags">
                <th scope="row" class="titledesc">
                    <label> <?php _e('Product Tag', 'woo2app'); ?> </label>
                </th>
                <td class="forminp">
                    <select name="tags" data-id="tags"   class="regular-text js-data-example-ajax">

                    </select>
                </td>
            </tr>
            <tr valign="top" class="el_type display-none" id="el_products">
                <th scope="row" class="titledesc">
                    <label> <?php _e('Product', 'woo2app'); ?> </label>
                </th>
                <td class="forminp">
                    <select name="product" data-id="product"   class="regular-text js-data-example-ajax">

                    </select>
                </td>
            </tr>
            <tr valign="top" class="el_type display-none" id="el_CustomList">
                <th scope="row" class="titledesc">
                    <label> <?php _e('Custom List', 'woo2app'); ?> </label>
                </th>
                <td class="forminp">
                    <select name="CustomList" id="value_custom_list" class="regular-text"
                            data-live-search="true" title="<?php _e('Please Select ...', 'woo2app'); ?>">
						<?php
						$results =  get_option('mr2app_custom_product_list');
						foreach ($results as $key) {
							?>
                            <option value='<?= implode(',',$key['list_product'])?>' > <?= $key['title'];?></option>
							<?php
						}
						?>
                    </select>
                </td>
            </tr>
            <tr valign="top" class="el_type display-none" id="el_cats">
                <th scope="row" class="titledesc">
                    <label> <?php _e('Category', 'woo2app'); ?> </label>
                </th>
                <td class="forminp">
                    <select name="cat" data-id="cat"  class="regular-text js-data-example-ajax">

                    </select>
                </td>
            </tr>
            <tr valign="top" class="el_type display-none" id="el_link">
                <th scope="row" class="titledesc">
                    <label> <?php _e('Link', 'woo2app'); ?></label>
                </th>
                <td class="forminp">
                    <input type="text" class="regular-text" name="link" id="link" value=""
                           placeholder="{http | https}://yoursite.com">
                </td>
            </tr>
            <tr>
                <th scope="row" class="titledesc">
                    <label dir="rtl"> <?php _e('Image', 'woo2app'); ?></label>
                    <p>
                        <hr>
	                    <?php _e('Best scale', 'woo2app'); ?> : 2x1
                        <hr>
	                    <?php _e('Recommended Resolution', 'woo2app'); ?> : 1200x600
                        <hr>
	                    <?php _e('Max Size', 'woo2app'); ?> : 150KB
                        <hr>
	                    <?php _e('Format', 'woo2app'); ?> : PNG - JPG - JPEG - GIF
                    </p>
                </th>
                <td class="forminp">
                    <input type="hidden" id="txt_url_item_hami" name="src_val">
                    <img id="div_image_item_hami" class="banner cursor-pointer width-300px height-150px"
                         src="<?= WOO2APP_URL . "files/img/750x375&text=2x1.png" ?>">
                </td>
            </tr>
            <tr>
                <th scope="row" class="titledesc">
                </th>
                <td class="forminp">
                    <input type="submit" value="<?php _e('Add', 'woo2app'); ?>" class="button button-primary"
                           name="submit_banner">
                </td>
            </tr>
            </tbody>
        </table>
    </form>
</div>
<hr>

<form name="form_sort" id="form_sort" method="post" action="">
	<?php wp_nonce_field('slider_sort', 'slider_sort'); ?>

    <table class="wp-list-table widefat striped tags ui-sortable width-600px">
        <thead>
        <tr>
            <th scope="col" class="width-20px manage-column column-name">
                <span>#</span>
            </th>
            <th scope="col" class='width-100 manage-column column-name'>
                <span><?php _e('Title', 'woo2app'); ?></span>
            </th>
            <th scope="col" class='manage-column column-name'>
                <span><?php _e('Image', 'woo2app'); ?></span>
            </th>
            <th scope="col" class='manage-column column-name width-50px'>
                <span ></span>
            </th>
        </tr>
        </thead>
        <tbody id="sortable">
		<?php
		global $wpdb;
		$table_name = $wpdb->prefix . "woo2app_slider";
		$sliders = $wpdb->get_results("SELECT * FROM $table_name ORDER BY sl_sort ASC");
		$i = 0;
		foreach ($sliders as $slider) {
			$i++;
			?>
            <tr class="border-bottom-2px-solid cursor-move" id="row_slider_<?= $slider->sl_id; ?>">
                <input type="hidden" name="ids[]" value="<?= $slider->sl_id; ?>">
                <td scope="row" class="vertical-align-middle titledesc">
                    <strong dir="rtl">    <?= $i  ?> </strong>
                </td>
                <td scope="row" class="titledesc vertical-align-middle">
                    <strong dir="rtl">    <?= esc_html($slider->sl_title);  ?> </strong>
                </td>
                <td class="vertical-align-middle">
                    <a href="<?= $slider->sl_pic; ?>" target="_blank"><img src="<?= $slider->sl_pic; ?>"
                                                                           class="width-150px height-75px"></a>
                </td>
                <td class="vertical-align-middle text-center">
                    <button onclick="delete_slider_hami(<?= $slider->sl_id; ?>)" type="button"
                            class="button"><?php _e('Delete', 'woo2app'); ?></button>
                </td>
            </tr>
			<?php
		}
		?>
        </tbody>
    </table>
    <p>
		<?php _e('Drag to move', 'woo2app'); ?>
    </p>
    <p>
        <input type="submit" name="sort" class="button button-default" value="<?php _e('Save', 'woo2app'); ?>">
    </p>
</form>
<?php
wp_enqueue_media();
wp_enqueue_script( 'loadajax.js'.WOO2APP_FILES_VER , WOO2APP_JS_URL.'loadAjaxPosts.js', array('jquery'));
?>
<script>
    jQuery(function() {
        jQuery( "#sortable" ).sortable();
        jQuery( "#sortable" ).disableSelection();
    });
    jQuery('#select_action_banner').on('change', function() {
        var type_val = (jQuery('#select_action_banner').val());
        //alert(type_val)
        jQuery('.el_type').css('display','none');
        if(type_val == 1){
            jQuery('#el_products').css('display','table-row');
        }
        else if(type_val == 2){
            jQuery('#el_cats').css('display','table-row');
        }
        else if(type_val == 3){
            jQuery('#el_link').css('display','table-row');
        }
        else if(type_val == 8){
            jQuery('#el_tags').css('display','table-row');
        }
        else if(type_val == 9){
            jQuery('#el_CustomList').css('display','table-row');
        }
    });
    var custom_uploader_hami;
    jQuery('#div_image_item_hami').click(function (e) {
        e.preventDefault();
        custom_uploader_hami = wp.media.frames.custom_uploader_hami = wp.media({
            title: '<?php _e('Select Image', 'woo2app'); ?>',
            library: {type: 'image'},
            button: {text: '<?php _e('Select', 'woo2app'); ?>'},
            multiple: false
        });
        custom_uploader_hami.on('select', function() {
            attachment = custom_uploader_hami.state().get('selection').first().toJSON();
            jQuery('#txt_url_item_hami').val(attachment.url);
            url_image = attachment.url;
            jQuery('#div_image_item_hami').attr("src",url_image);
        });
        custom_uploader_hami.open();
    });
    function delete_slider_hami(id){
        if (confirm('<?php _e('Are You Sure?', 'woo2app'); ?>')) {
            jQuery.ajax({
                url: ajaxurl,
                data: {
                    action: "delete_item_slider_hami",
                    "id" : id
                },
                success:function(data) {
                    jQuery("#img_load_del_sl").addClass("hide");
                    data = data.substring(0,data.length -1);
                    if(data == 1){
                        jQuery('#row_slider_' + id ).remove();
                    }
                }
            });
        }
    }
    jQuery('.search_product_banner').keyup(function(){
        var id = jQuery(this).attr('data-id');
        //alert(id);
        var  v = jQuery(this).val();
        if(v.length >= 3){
            jQuery("#img_load"+id).attr("style",'display:block');
            jQuery.ajax({
                url: ajaxurl,
                data: {
                    action: "load_all_product",
                    search_product : v
                },
                success:function(data) {
                    jQuery("#img_load"+id).attr("style",'display:none');
                    jQuery("#value_post_items_menu"+id).html(data);
                }
            });
        }
    });
</script>