<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

wp_register_style( 'woo2app_style', WOO2APP_CSS_URL . 'woo2app_style.css' );
wp_enqueue_style( 'woo2app_style' );
if(get_locale() == 'fa_IR'){
	wp_register_style('myfont', WOO2APP_CSS_URL . 'font.css');
	wp_enqueue_style( 'myfont');
}

$current_url = "//" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
?>
    <div class="wrap">
        <div id="col-container" class="">
            <h2 class="background-color-e5e5e5 padding-7px">
		        <?php _e('Sort element for displayed home page', 'woo2app'); ?>
            </h2>
            <div>
                <div class="col-wrap ">
                    <form name="form_sort" id="form_sort" method="post" action="">
						<?php wp_nonce_field( 'woo2app-admin', 'woo2app-admin' ); ?>
                        <table class="wp-list-table widefat striped ui-sortable ">
                            <thead>
                            <tr>
                                <th scope="col" style="width: 20px" >
                                    <span class="fa fa-arrows"></span>
                                </th>
                                <th scope="col">
                                    <span> <?php _e( 'Title', 'woo2app' ); ?> </span>
                                </th>
                                <th scope="col">
                                    <span style="cursor: pointer"> <?php _e( 'Action', 'woo2app' ); ?> </span>
                                </th>
                            </tr>
                            </thead>
                            <tbody id="sortable">
							<?php
							global $wpdb;
							$table_name = $wpdb->prefix . "woo2app_mainpage";
							$res        = $wpdb->get_results( "select * from $table_name order by mp_order" );
							$exp        = get_option( 'exp_time_WOO2APP' );
							$i          = - 1;
							$f          = 0;
							foreach ( $res as $key ) {
								$i ++;
								?>
                                <tr id="record<?= $key->mp_id; ?>">
                                    <td style="cursor: move;">
                                        <img style="width: 12px" src="<?= WOO2APP_URL . 'files/img/sort.png' ?>"/>
                                    </td>
                                    <td>
                                        <div class="">

											<?php

											if ( $key->mp_showtype == 1 ) {
												 _e( 'Single Banner :', 'woo2app' );
											} elseif ( $key->mp_showtype == 2 ) {
												_e('Horizontal List :', 'woo2app');
											} elseif ( $key->mp_showtype == 3 ) {
												_e('Vertical List :', 'woo2app');
											} elseif ( $key->mp_showtype == 51 ) {
												_e('Amazing Offer :', 'woo2app');
											} //elseif($key->mp_showtype == 10) echo ' Slider List :';

                                            elseif ( $key->mp_showtype == 9 ) {
	                                            _e('Custom List :', 'woo2app');
											} elseif ( $key->mp_showtype == 10 ) {
												_e('Vertical List [post]  :', 'woo2app');
											} elseif ( $key->mp_showtype == 11 ) {
												_e('Horizontal List [post]  :', 'woo2app');
											} elseif ( $key->mp_showtype == 12 ) {
												_e('Slider List  :', 'woo2app');
											}

											if ( $key->mp_title == "" ) {
												_e('[Untitled]' , 'woo2app');
											}

											?>

											<?= esc_html( $key->mp_title ); ?>

                                            <input type="hidden" name="id[]" value="<?php echo $key->mp_id; ?>">

                                        </div>
                                    </td>
                                    <td>
                                        <span onclick="delete_item_mainepage_woo(<?php echo $key->mp_id; ?>)"   class="cursor-pointer red">
                                            <?= _e( 'Delete', 'woo2app' ); ?>
                                        </span>
										<?php
										if($key->mp_showtype == 51){
											if($key->mp_pic - time() >= 1){
												echo ' - <span class="green">' .' (' . formatSeconds($key->mp_pic - time() ) . ' remains)'. '</span>';
											}
											else{
												echo '<span class="green">' . _e( 'The End', 'woo2app' ) . '</span>';
											}
										}
										?>
                                    </td>

                                </tr>
								<?php
							}
							?>
                            </tbody>
                        </table>
                        <p>
	                        <?php _e( 'Drag & Drop', 'woo2app' ); ?>
                            <input type="button" name="sort" id="btn_form_order" class="button button-primary"
                                   value="<?php _e( 'Sort', 'woo2app' ); ?>">
                        <div class="clear-both"></div>
                        <img id="img_load" class="hide width-height-25px"
                             src="<?php echo WP_PLUGIN_URL . "/" . dirname( plugin_basename( __FILE__ ) ) . '/../files/img/load.gif' ?>">
                        </p>
                    </form>
                    <hr>
	                <?php $r = get_option("SHOW_BTN_CATLST");  ?>
	                <?php $map = get_option("SHOW_MAP");  ?>
                    <p>
                        <input type="checkbox" name="check_list_cat_mainpage" id="check_list_cat_mainpage" <?= checked($r)?> />
                        <span>
                            <?php _e( 'Show Categories Button', 'woo2app' ); ?>
                        </span>
                    </p>
                    <p>
                        <input type="checkbox"  name="check_map_mainpage" id="check_map_mainpage" <?= checked($map)?> />
                        <span> <?php _e('Map' , 'woo2app');?> </span>
                    </p>
                </div>
            </div>
        </div>
    </div>

<?php
wp_enqueue_media();
wp_enqueue_script( 'sort.js'.WOO2APP_FILES_VER, WOO2APP_JS_URL . 'sort.js', array( 'jquery' ));
?>